/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.code.TypeTags;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.TransformationsUtil;
import lombok.javac.Javac;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleGetter
extends JavacAnnotationHandler<Getter> {
    private static final String AR = "java.util.concurrent.atomic.AtomicReference";
    private static final List<JCTree.JCExpression> NIL_EXPRESSION = List.nil();
    private static final Map<Integer, String> TYPE_MAP;

    public void generateGetterForType(JavacNode typeNode, JavacNode errorNode, AccessLevel level, boolean checkForTypeLevelGetter) {
        boolean notAClass;
        if (checkForTypeLevelGetter && typeNode != null) {
            for (JavacNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.ANNOTATION || !JavacHandlerUtil.annotationTypeMatches(Getter.class, child)) continue;
                return;
            }
        }
        JCTree.JCClassDecl typeDecl = null;
        if (typeNode.get() instanceof JCTree.JCClassDecl) {
            typeDecl = (JCTree.JCClassDecl)typeNode.get();
        }
        long modifiers = typeDecl == null ? 0L : typeDecl.mods.flags;
        boolean bl = notAClass = (modifiers & 0x2200L) != 0L;
        if (typeDecl == null || notAClass) {
            errorNode.addError("@Getter is only supported on a class, an enum, or a field.");
            return;
        }
        for (JavacNode field : typeNode.down()) {
            if (!this.fieldQualifiesForGetterGeneration(field)) continue;
            this.generateGetterForField(field, (JCDiagnostic.DiagnosticPosition)errorNode.get(), level, false);
        }
    }

    public boolean fieldQualifiesForGetterGeneration(JavacNode field) {
        if (field.getKind() != AST.Kind.FIELD) {
            return false;
        }
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)field.get();
        if (fieldDecl.name.toString().startsWith("$")) {
            return false;
        }
        return (fieldDecl.mods.flags & 8L) == 0L;
    }

    public void generateGetterForField(JavacNode fieldNode, JCDiagnostic.DiagnosticPosition pos, AccessLevel level, boolean lazy) {
        for (JavacNode child : fieldNode.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION || !JavacHandlerUtil.annotationTypeMatches(Getter.class, child)) continue;
            return;
        }
        this.createGetterForField(level, fieldNode, fieldNode, false, lazy);
    }

    @Override
    public void handle(AnnotationValues<Getter> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        Collection<JavacNode> fields = annotationNode.upFromAnnotationToFields();
        JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, Getter.class);
        JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
        JavacNode node = (JavacNode)annotationNode.up();
        Getter annotationInstance = annotation.getInstance();
        AccessLevel level = annotationInstance.value();
        boolean lazy = annotationInstance.lazy();
        if (level == AccessLevel.NONE) {
            if (lazy) {
                annotationNode.addWarning("'lazy' does not work with AccessLevel.NONE.");
            }
            return;
        }
        if (node == null) {
            return;
        }
        switch (node.getKind()) {
            case FIELD: {
                this.createGetterForFields(level, fields, annotationNode, true, lazy);
                break;
            }
            case TYPE: {
                if (lazy) {
                    annotationNode.addError("'lazy' is not supported for @Getter on a type.");
                }
                this.generateGetterForType(node, annotationNode, level, false);
            }
        }
    }

    private void createGetterForFields(AccessLevel level, Collection<JavacNode> fieldNodes, JavacNode errorNode, boolean whineIfExists, boolean lazy) {
        for (JavacNode fieldNode : fieldNodes) {
            this.createGetterForField(level, fieldNode, errorNode, whineIfExists, lazy);
        }
    }

    private void createGetterForField(AccessLevel level, JavacNode fieldNode, JavacNode source, boolean whineIfExists, boolean lazy) {
        if (fieldNode.getKind() != AST.Kind.FIELD) {
            source.addError("@Getter is only supported on a class or a field.");
            return;
        }
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)fieldNode.get();
        if (lazy) {
            if ((fieldDecl.mods.flags & 2L) == 0L || (fieldDecl.mods.flags & 0x10L) == 0L) {
                source.addError("'lazy' requires the field to be private and final.");
                return;
            }
            if (fieldDecl.init == null) {
                source.addError("'lazy' requires field initialization.");
                return;
            }
        }
        String methodName = Javac.toGetterName(fieldDecl);
        for (String altName : Javac.toAllGetterNames(fieldDecl)) {
            switch (JavacHandlerUtil.methodExists(altName, fieldNode, false)) {
                case EXISTS_BY_LOMBOK: {
                    return;
                }
                case EXISTS_BY_USER: {
                    if (whineIfExists) {
                        String altNameExpl = "";
                        if (!altName.equals(methodName)) {
                            altNameExpl = String.format(" (%s)", altName);
                        }
                        source.addWarning(String.format("Not generating %s(): A method with that name already exists%s", methodName, altNameExpl));
                    }
                    return;
                }
            }
        }
        long access = (long)JavacHandlerUtil.toJavacModifier(level) | fieldDecl.mods.flags & 8L;
        JavacHandlerUtil.injectMethod((JavacNode)fieldNode.up(), this.createGetter(access, fieldNode, fieldNode.getTreeMaker(), lazy, (JCTree)source.get()));
    }

    private JCTree.JCMethodDecl createGetter(long access, JavacNode field, TreeMaker treeMaker, boolean lazy, JCTree source) {
        List<JCTree.JCStatement> statements;
        JCTree.JCVariableDecl fieldNode = (JCTree.JCVariableDecl)field.get();
        JCTree.JCExpression methodType = this.copyType(treeMaker, fieldNode);
        JCTree.JCExpression toClearOfMarkers = null;
        if (lazy) {
            toClearOfMarkers = fieldNode.init;
            statements = this.createLazyGetterBody(treeMaker, field, source);
        } else {
            statements = this.createSimpleGetterBody(treeMaker, field);
        }
        JCTree.JCBlock methodBody = treeMaker.Block(0L, statements);
        Name methodName = field.toName(Javac.toGetterName(fieldNode));
        List<JCTree.JCTypeParameter> methodGenericParams = List.nil();
        List<JCTree.JCVariableDecl> parameters = List.nil();
        List<JCTree.JCExpression> throwsClauses = List.nil();
        JCTree.JCExpression annotationMethodDefaultValue = null;
        List<JCTree.JCAnnotation> nonNulls = JavacHandlerUtil.findAnnotations(field, TransformationsUtil.NON_NULL_PATTERN);
        List<JCTree.JCAnnotation> nullables = JavacHandlerUtil.findAnnotations(field, TransformationsUtil.NULLABLE_PATTERN);
        List<JCTree.JCAnnotation> annsOnMethod = nonNulls.appendList(nullables);
        JCTree.JCMethodDecl decl = JavacHandlerUtil.recursiveSetGeneratedBy(treeMaker.MethodDef(treeMaker.Modifiers(access, annsOnMethod), methodName, methodType, methodGenericParams, parameters, throwsClauses, methodBody, annotationMethodDefaultValue), source);
        if (toClearOfMarkers != null) {
            JavacHandlerUtil.recursiveSetGeneratedBy(toClearOfMarkers, null);
        }
        return decl;
    }

    private List<JCTree.JCStatement> createSimpleGetterBody(TreeMaker treeMaker, JavacNode field) {
        return List.of(treeMaker.Return(JavacHandlerUtil.createFieldAccessor(treeMaker, field, JavacHandlerUtil.FieldAccess.ALWAYS_FIELD)));
    }

    private List<JCTree.JCStatement> createLazyGetterBody(TreeMaker maker, JavacNode fieldNode, JCTree source) {
        String boxed;
        ListBuffer statements = ListBuffer.lb();
        JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)fieldNode.get();
        field.type = null;
        if (field.vartype instanceof JCTree.JCPrimitiveTypeTree && (boxed = TYPE_MAP.get((int)((JCTree.JCPrimitiveTypeTree)field.vartype).typetag)) != null) {
            field.vartype = JavacHandlerUtil.chainDotsString(fieldNode, boxed);
        }
        Name valueName = fieldNode.toName("value");
        JCTree.JCTypeApply valueVarType = maker.TypeApply(JavacHandlerUtil.chainDotsString(fieldNode, AR), List.of(this.copyType(maker, field)));
        statements.append(maker.VarDef(maker.Modifiers(0L), valueName, valueVarType, this.callGet(fieldNode, JavacHandlerUtil.createFieldAccessor(maker, fieldNode, JavacHandlerUtil.FieldAccess.ALWAYS_FIELD))));
        ListBuffer synchronizedStatements = ListBuffer.lb();
        JCTree.JCExpressionStatement newAssign = maker.Exec(maker.Assign(maker.Ident(valueName), this.callGet(fieldNode, JavacHandlerUtil.createFieldAccessor(maker, fieldNode, JavacHandlerUtil.FieldAccess.ALWAYS_FIELD))));
        synchronizedStatements.append(newAssign);
        ListBuffer innerIfStatements = ListBuffer.lb();
        JCTree.JCTypeApply valueVarType2 = maker.TypeApply(JavacHandlerUtil.chainDotsString(fieldNode, AR), List.of(this.copyType(maker, field)));
        JCTree.JCNewClass newInstance = maker.NewClass(null, NIL_EXPRESSION, valueVarType2, List.of(field.init), null);
        JCTree.JCExpressionStatement statement = maker.Exec(maker.Assign(maker.Ident(valueName), newInstance));
        innerIfStatements.append(statement);
        JCTree.JCStatement statement2 = this.callSet(fieldNode, JavacHandlerUtil.createFieldAccessor(maker, fieldNode, JavacHandlerUtil.FieldAccess.ALWAYS_FIELD), maker.Ident(valueName));
        innerIfStatements.append(statement2);
        JCTree.JCBinary isNull = maker.Binary(Javac.getCtcInt(JCTree.class, "EQ"), maker.Ident(valueName), maker.Literal(Javac.getCtcInt(TypeTags.class, "BOT"), null));
        JCTree.JCIf ifStatement = maker.If(isNull, maker.Block(0L, innerIfStatements.toList()), null);
        synchronizedStatements.append(ifStatement);
        JCTree.JCSynchronized synchronizedStatement = maker.Synchronized(JavacHandlerUtil.createFieldAccessor(maker, fieldNode, JavacHandlerUtil.FieldAccess.ALWAYS_FIELD), maker.Block(0L, synchronizedStatements.toList()));
        JCTree.JCBinary isNull2 = maker.Binary(Javac.getCtcInt(JCTree.class, "EQ"), maker.Ident(valueName), maker.Literal(Javac.getCtcInt(TypeTags.class, "BOT"), null));
        JCTree.JCIf ifStatement2 = maker.If(isNull2, maker.Block(0L, List.of(synchronizedStatement)), null);
        statements.append(ifStatement2);
        statements.append(maker.Return(this.callGet(fieldNode, maker.Ident(valueName))));
        field.vartype = JavacHandlerUtil.recursiveSetGeneratedBy(maker.TypeApply(JavacHandlerUtil.chainDotsString(fieldNode, AR), List.of(maker.TypeApply(JavacHandlerUtil.chainDotsString(fieldNode, AR), List.of(this.copyType(maker, field))))), source);
        field.init = JavacHandlerUtil.recursiveSetGeneratedBy(maker.NewClass(null, NIL_EXPRESSION, this.copyType(maker, field), NIL_EXPRESSION, null), source);
        return statements.toList();
    }

    private JCTree.JCMethodInvocation callGet(JavacNode source, JCTree.JCExpression receiver) {
        TreeMaker maker = source.getTreeMaker();
        return maker.Apply(NIL_EXPRESSION, maker.Select(receiver, source.toName("get")), NIL_EXPRESSION);
    }

    private JCTree.JCStatement callSet(JavacNode source, JCTree.JCExpression receiver, JCTree.JCExpression value) {
        TreeMaker maker = source.getTreeMaker();
        return maker.Exec(maker.Apply(NIL_EXPRESSION, maker.Select(receiver, source.toName("set")), List.of(value)));
    }

    private JCTree.JCExpression copyType(TreeMaker treeMaker, JCTree.JCVariableDecl fieldNode) {
        return fieldNode.type != null ? treeMaker.Type(fieldNode.type) : fieldNode.vartype;
    }

    static {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        m.put(Javac.getCtcInt(TypeTags.class, "INT"), "java.lang.Integer");
        m.put(Javac.getCtcInt(TypeTags.class, "DOUBLE"), "java.lang.Double");
        m.put(Javac.getCtcInt(TypeTags.class, "FLOAT"), "java.lang.Float");
        m.put(Javac.getCtcInt(TypeTags.class, "SHORT"), "java.lang.Short");
        m.put(Javac.getCtcInt(TypeTags.class, "BYTE"), "java.lang.Byte");
        m.put(Javac.getCtcInt(TypeTags.class, "LONG"), "java.lang.Long");
        m.put(Javac.getCtcInt(TypeTags.class, "BOOLEAN"), "java.lang.Boolean");
        m.put(Javac.getCtcInt(TypeTags.class, "CHAR"), "java.lang.Character");
        TYPE_MAP = Collections.unmodifiableMap(m);
    }
}

