/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.TypeTags;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.Collections;
import lombok.EqualsAndHashCode;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.javac.Javac;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleEqualsAndHashCode
extends JavacAnnotationHandler<EqualsAndHashCode> {
    private void checkForBogusFieldNames(JavacNode type, AnnotationValues<EqualsAndHashCode> annotation) {
        if (annotation.isExplicit("exclude")) {
            for (int i : JavacHandlerUtil.createListOfNonExistentFields(List.from(annotation.getInstance().exclude()), type, true, true)) {
                annotation.setWarning("exclude", "This field does not exist, or would have been excluded anyway.", i);
            }
        }
        if (annotation.isExplicit("of")) {
            for (int i : JavacHandlerUtil.createListOfNonExistentFields(List.from(annotation.getInstance().of()), type, false, false)) {
                annotation.setWarning("of", "This field does not exist.", i);
            }
        }
    }

    @Override
    public void handle(AnnotationValues<EqualsAndHashCode> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, EqualsAndHashCode.class);
        EqualsAndHashCode ann = annotation.getInstance();
        List<String> excludes = List.from(ann.exclude());
        List<String> includes = List.from(ann.of());
        JavacNode typeNode = (JavacNode)annotationNode.up();
        this.checkForBogusFieldNames(typeNode, annotation);
        Boolean callSuper = ann.callSuper();
        if (!annotation.isExplicit("callSuper")) {
            callSuper = null;
        }
        if (!annotation.isExplicit("exclude")) {
            excludes = null;
        }
        if (!annotation.isExplicit("of")) {
            includes = null;
        }
        if (excludes != null && includes != null) {
            excludes = null;
            annotation.setWarning("exclude", "exclude and of are mutually exclusive; the 'exclude' parameter will be ignored.");
        }
        JavacHandlerUtil.FieldAccess fieldAccess = ann.doNotUseGetters() ? JavacHandlerUtil.FieldAccess.PREFER_FIELD : JavacHandlerUtil.FieldAccess.GETTER;
        this.generateMethods(typeNode, annotationNode, excludes, includes, callSuper, true, fieldAccess);
    }

    public void generateEqualsAndHashCodeForType(JavacNode typeNode, JavacNode source) {
        for (JavacNode child : typeNode.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION || !JavacHandlerUtil.annotationTypeMatches(EqualsAndHashCode.class, child)) continue;
            return;
        }
        this.generateMethods(typeNode, source, null, null, null, false, JavacHandlerUtil.FieldAccess.GETTER);
    }

    private void generateMethods(JavacNode typeNode, JavacNode source, List<String> excludes, List<String> includes, Boolean callSuper, boolean whineIfExists, JavacHandlerUtil.FieldAccess fieldAccess) {
        JCTree.JCVariableDecl fieldDecl;
        Tree extending;
        boolean implicitCallSuper;
        boolean notAClass = true;
        if (typeNode.get() instanceof JCTree.JCClassDecl) {
            long flags = ((JCTree.JCClassDecl)typeNode.get()).mods.flags;
            boolean bl = notAClass = (flags & 0x6200L) != 0L;
        }
        if (notAClass) {
            source.addError("@EqualsAndHashCode is only supported on a class.");
            return;
        }
        boolean isDirectDescendantOfObject = true;
        boolean bl = implicitCallSuper = callSuper == null;
        if (callSuper == null) {
            try {
                callSuper = (boolean)((Boolean)EqualsAndHashCode.class.getMethod("callSuper", new Class[0]).getDefaultValue());
            }
            catch (Exception ignore) {
                throw new InternalError("Lombok bug - this cannot happen - can't find callSuper field in EqualsAndHashCode annotation.");
            }
        }
        if ((extending = ((JCTree.JCClassDecl)typeNode.get()).getExtendsClause()) != null) {
            String p = ((JCTree)extending).toString();
            boolean bl2 = isDirectDescendantOfObject = p.equals("Object") || p.equals("java.lang.Object");
        }
        if (isDirectDescendantOfObject && callSuper.booleanValue()) {
            source.addError("Generating equals/hashCode with a supercall to java.lang.Object is pointless.");
            return;
        }
        if (!isDirectDescendantOfObject && !callSuper.booleanValue() && implicitCallSuper) {
            source.addWarning("Generating equals/hashCode implementation but without a call to superclass, even though this class does not extend java.lang.Object. If this is intentional, add '@EqualsAndHashCode(callSuper=false)' to your type.");
        }
        ListBuffer nodesForEquality = ListBuffer.lb();
        if (includes != null) {
            for (JavacNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.FIELD) continue;
                fieldDecl = (JCTree.JCVariableDecl)child.get();
                if (!includes.contains(fieldDecl.name.toString())) continue;
                nodesForEquality.append(child);
            }
        } else {
            for (JavacNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.FIELD) continue;
                fieldDecl = (JCTree.JCVariableDecl)child.get();
                if ((fieldDecl.mods.flags & 8L) != 0L || (fieldDecl.mods.flags & 0x80L) != 0L || excludes != null && excludes.contains(fieldDecl.name.toString()) || fieldDecl.name.toString().startsWith("$")) continue;
                nodesForEquality.append(child);
            }
        }
        boolean isFinal = (((JCTree.JCClassDecl)typeNode.get()).mods.flags & 0x10L) != 0L;
        boolean needsCanEqual = !isFinal || !isDirectDescendantOfObject;
        ArrayList<JavacHandlerUtil.MemberExistsResult> existsResults = new ArrayList<JavacHandlerUtil.MemberExistsResult>();
        existsResults.add(JavacHandlerUtil.methodExists("equals", typeNode));
        existsResults.add(JavacHandlerUtil.methodExists("hashCode", typeNode));
        existsResults.add(JavacHandlerUtil.methodExists("canEqual", typeNode));
        switch ((JavacHandlerUtil.MemberExistsResult)((Object)Collections.max(existsResults))) {
            case EXISTS_BY_LOMBOK: {
                return;
            }
            case EXISTS_BY_USER: {
                if (whineIfExists) {
                    String msg = String.format("Not generating equals%s: A method with one of those names already exists. (Either all or none of these methods will be generated).", needsCanEqual ? ", hashCode and canEquals" : " and hashCode");
                    source.addWarning(msg);
                }
                return;
            }
        }
        JCTree.JCMethodDecl equalsMethod = this.createEquals(typeNode, nodesForEquality.toList(), callSuper, fieldAccess, needsCanEqual, (JCTree)source.get());
        JavacHandlerUtil.injectMethod(typeNode, equalsMethod);
        if (needsCanEqual) {
            JCTree.JCMethodDecl canEqualMethod = this.createCanEqual(typeNode, (JCTree)source.get());
            JavacHandlerUtil.injectMethod(typeNode, canEqualMethod);
        }
        JCTree.JCMethodDecl hashCodeMethod = this.createHashCode(typeNode, nodesForEquality.toList(), callSuper, fieldAccess, (JCTree)source.get());
        JavacHandlerUtil.injectMethod(typeNode, hashCodeMethod);
    }

    private JCTree.JCMethodDecl createHashCode(JavacNode typeNode, List<JavacNode> fields, boolean callSuper, JavacHandlerUtil.FieldAccess fieldAccess, JCTree source) {
        TreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCAnnotation overrideAnnotation = maker.Annotation(JavacHandlerUtil.chainDots(typeNode, "java", "lang", "Override"), List.<JCTree.JCExpression>nil());
        JCTree.JCModifiers mods = maker.Modifiers(1L, List.of(overrideAnnotation));
        JCTree.JCPrimitiveTypeTree returnType = maker.TypeIdent(Javac.getCtcInt(TypeTags.class, "INT"));
        ListBuffer statements = ListBuffer.lb();
        Name primeName = typeNode.toName("PRIME");
        Name resultName = typeNode.toName("result");
        if (!fields.isEmpty() || callSuper) {
            statements.append(maker.VarDef(maker.Modifiers(16L), primeName, maker.TypeIdent(Javac.getCtcInt(TypeTags.class, "INT")), maker.Literal(31)));
        }
        statements.append(maker.VarDef(maker.Modifiers(0L), resultName, maker.TypeIdent(Javac.getCtcInt(TypeTags.class, "INT")), maker.Literal(1)));
        ListBuffer intoResult = ListBuffer.lb();
        if (callSuper) {
            JCTree.JCMethodInvocation callToSuper = maker.Apply(List.<JCTree.JCExpression>nil(), maker.Select((JCTree.JCExpression)maker.Ident(typeNode.toName("super")), typeNode.toName("hashCode")), List.<JCTree.JCExpression>nil());
            intoResult.append(callToSuper);
        }
        int tempCounter = 0;
        for (JavacNode fieldNode : fields) {
            JCTree.JCExpression fType = JavacHandlerUtil.getFieldType(fieldNode, fieldAccess);
            JCTree.JCExpression fieldAccessor = JavacHandlerUtil.createFieldAccessor(maker, fieldNode, fieldAccess);
            if (fType instanceof JCTree.JCPrimitiveTypeTree) {
                switch (((JCTree.JCPrimitiveTypeTree)fType).getPrimitiveTypeKind()) {
                    case BOOLEAN: {
                        intoResult.append(maker.Conditional(fieldAccessor, maker.Literal(1231), maker.Literal(1237)));
                        break;
                    }
                    case LONG: {
                        intoResult.append(this.longToIntForHashCode(maker, fieldAccessor, JavacHandlerUtil.createFieldAccessor(maker, fieldNode, fieldAccess)));
                        break;
                    }
                    case FLOAT: {
                        intoResult.append(maker.Apply(List.<JCTree.JCExpression>nil(), JavacHandlerUtil.chainDots(typeNode, "java", "lang", "Float", "floatToIntBits"), List.of(fieldAccessor)));
                        break;
                    }
                    case DOUBLE: {
                        Name tempVar = typeNode.toName("temp" + ++tempCounter);
                        JCTree.JCMethodInvocation init = maker.Apply(List.<JCTree.JCExpression>nil(), JavacHandlerUtil.chainDots(typeNode, "java", "lang", "Double", "doubleToLongBits"), List.of(fieldAccessor));
                        statements.append(maker.VarDef(maker.Modifiers(16L), tempVar, maker.TypeIdent(5), init));
                        intoResult.append(this.longToIntForHashCode(maker, maker.Ident(tempVar), maker.Ident(tempVar)));
                        break;
                    }
                    default: {
                        intoResult.append(fieldAccessor);
                        break;
                    }
                }
                continue;
            }
            if (fType instanceof JCTree.JCArrayTypeTree) {
                boolean multiDim = ((JCTree.JCArrayTypeTree)fType).elemtype instanceof JCTree.JCArrayTypeTree;
                boolean primitiveArray = ((JCTree.JCArrayTypeTree)fType).elemtype instanceof JCTree.JCPrimitiveTypeTree;
                boolean useDeepHC = multiDim || !primitiveArray;
                JCTree.JCExpression hcMethod = JavacHandlerUtil.chainDots(typeNode, "java", "util", "Arrays", useDeepHC ? "deepHashCode" : "hashCode");
                intoResult.append(maker.Apply(List.<JCTree.JCExpression>nil(), hcMethod, List.of(fieldAccessor)));
                continue;
            }
            JCTree.JCMethodInvocation hcCall = maker.Apply(List.<JCTree.JCExpression>nil(), maker.Select(JavacHandlerUtil.createFieldAccessor(maker, fieldNode, fieldAccess), typeNode.toName("hashCode")), List.<JCTree.JCExpression>nil());
            JCTree.JCBinary thisEqualsNull = maker.Binary(Javac.getCtcInt(JCTree.class, "EQ"), fieldAccessor, maker.Literal(Javac.getCtcInt(TypeTags.class, "BOT"), null));
            intoResult.append(maker.Conditional(thisEqualsNull, maker.Literal(0), hcCall));
        }
        for (JCTree.JCExpression expr : intoResult) {
            JCTree.JCBinary mult = maker.Binary(Javac.getCtcInt(JCTree.class, "MUL"), maker.Ident(resultName), maker.Ident(primeName));
            JCTree.JCBinary add = maker.Binary(Javac.getCtcInt(JCTree.class, "PLUS"), mult, expr);
            statements.append(maker.Exec(maker.Assign(maker.Ident(resultName), add)));
        }
        statements.append(maker.Return(maker.Ident(resultName)));
        JCTree.JCBlock body = maker.Block(0L, statements.toList());
        return JavacHandlerUtil.recursiveSetGeneratedBy(maker.MethodDef(mods, typeNode.toName("hashCode"), returnType, List.<JCTree.JCTypeParameter>nil(), List.<JCTree.JCVariableDecl>nil(), List.<JCTree.JCExpression>nil(), body, null), source);
    }

    private JCTree.JCExpression longToIntForHashCode(TreeMaker maker, JCTree.JCExpression ref1, JCTree.JCExpression ref2) {
        JCTree.JCBinary shift = maker.Binary(Javac.getCtcInt(JCTree.class, "USR"), ref1, maker.Literal(32));
        JCTree.JCBinary xorBits = maker.Binary(Javac.getCtcInt(JCTree.class, "BITXOR"), shift, ref2);
        return maker.TypeCast(maker.TypeIdent(Javac.getCtcInt(TypeTags.class, "INT")), (JCTree.JCExpression)xorBits);
    }

    private JCTree.JCExpression createTypeReference(JavacNode type) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(type.getName());
        for (JavacNode tNode = (JavacNode)type.up(); tNode != null && tNode.getKind() == AST.Kind.TYPE; tNode = (JavacNode)tNode.up()) {
            list.add(tNode.getName());
        }
        Collections.reverse(list);
        TreeMaker maker = type.getTreeMaker();
        JCTree.JCExpression chain = maker.Ident(type.toName((String)list.get(0)));
        for (int i = 1; i < list.size(); ++i) {
            chain = maker.Select(chain, type.toName((String)list.get(i)));
        }
        return chain;
    }

    private JCTree.JCMethodDecl createEquals(JavacNode typeNode, List<JavacNode> fields, boolean callSuper, JavacHandlerUtil.FieldAccess fieldAccess, boolean needsCanEqual, JCTree source) {
        TreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCClassDecl type = (JCTree.JCClassDecl)typeNode.get();
        Name oName = typeNode.toName("o");
        Name otherName = typeNode.toName("other");
        Name thisName = typeNode.toName("this");
        JCTree.JCAnnotation overrideAnnotation = maker.Annotation(JavacHandlerUtil.chainDots(typeNode, "java", "lang", "Override"), List.<JCTree.JCExpression>nil());
        JCTree.JCModifiers mods = maker.Modifiers(1L, List.of(overrideAnnotation));
        JCTree.JCExpression objectType = JavacHandlerUtil.chainDots(typeNode, "java", "lang", "Object");
        JCTree.JCPrimitiveTypeTree returnType = maker.TypeIdent(Javac.getCtcInt(TypeTags.class, "BOOLEAN"));
        ListBuffer statements = ListBuffer.lb();
        List<JCTree.JCVariableDecl> params = List.of(maker.VarDef(maker.Modifiers(16L), oName, objectType, null));
        statements.append(maker.If(maker.Binary(Javac.getCtcInt(JCTree.class, "EQ"), maker.Ident(oName), maker.Ident(thisName)), this.returnBool(maker, true), null));
        JCTree.JCUnary notInstanceOf = maker.Unary(Javac.getCtcInt(JCTree.class, "NOT"), maker.TypeTest(maker.Ident(oName), this.createTypeReference(typeNode)));
        statements.append(maker.If(notInstanceOf, this.returnBool(maker, false), null));
        if (!fields.isEmpty() || needsCanEqual) {
            JCTree.JCExpression selfType2;
            JCTree.JCExpression selfType1;
            ListBuffer wildcards1 = ListBuffer.lb();
            ListBuffer wildcards2 = ListBuffer.lb();
            for (int i = 0; i < type.typarams.length(); ++i) {
                wildcards1.append(maker.Wildcard(maker.TypeBoundKind(BoundKind.UNBOUND), null));
                wildcards2.append(maker.Wildcard(maker.TypeBoundKind(BoundKind.UNBOUND), null));
            }
            if (type.typarams.isEmpty()) {
                selfType1 = maker.Ident(type.name);
                selfType2 = maker.Ident(type.name);
            } else {
                selfType1 = maker.TypeApply(maker.Ident(type.name), wildcards1.toList());
                selfType2 = maker.TypeApply(maker.Ident(type.name), wildcards2.toList());
            }
            statements.append(maker.VarDef(maker.Modifiers(16L), otherName, selfType1, maker.TypeCast(selfType2, (JCTree.JCExpression)maker.Ident(oName))));
        }
        if (needsCanEqual) {
            List<JCTree.JCExpression> exprNil = List.nil();
            JCTree.JCIdent thisRef = maker.Ident(thisName);
            JCTree.JCTypeCast castThisRef = maker.TypeCast(JavacHandlerUtil.chainDots(typeNode, "java", "lang", "Object"), (JCTree.JCExpression)thisRef);
            JCTree.JCMethodInvocation equalityCheck = maker.Apply(exprNil, maker.Select((JCTree.JCExpression)maker.Ident(otherName), typeNode.toName("canEqual")), List.of(castThisRef));
            statements.append(maker.If(maker.Unary(Javac.getCtcInt(JCTree.class, "NOT"), equalityCheck), this.returnBool(maker, false), null));
        }
        if (callSuper) {
            JCTree.JCMethodInvocation callToSuper = maker.Apply(List.<JCTree.JCExpression>nil(), maker.Select((JCTree.JCExpression)maker.Ident(typeNode.toName("super")), typeNode.toName("equals")), List.of(maker.Ident(oName)));
            JCTree.JCUnary superNotEqual = maker.Unary(Javac.getCtcInt(JCTree.class, "NOT"), callToSuper);
            statements.append(maker.If(superNotEqual, this.returnBool(maker, false), null));
        }
        block5: for (JavacNode fieldNode : fields) {
            JCTree.JCExpression fType = JavacHandlerUtil.getFieldType(fieldNode, fieldAccess);
            JCTree.JCExpression thisFieldAccessor = JavacHandlerUtil.createFieldAccessor(maker, fieldNode, fieldAccess);
            JCTree.JCExpression otherFieldAccessor = JavacHandlerUtil.createFieldAccessor(maker, fieldNode, fieldAccess, maker.Ident(otherName));
            if (fType instanceof JCTree.JCPrimitiveTypeTree) {
                switch (((JCTree.JCPrimitiveTypeTree)fType).getPrimitiveTypeKind()) {
                    case FLOAT: {
                        statements.append(this.generateCompareFloatOrDouble(thisFieldAccessor, otherFieldAccessor, maker, typeNode, false));
                        continue block5;
                    }
                    case DOUBLE: {
                        statements.append(this.generateCompareFloatOrDouble(thisFieldAccessor, otherFieldAccessor, maker, typeNode, true));
                        continue block5;
                    }
                }
                statements.append(maker.If(maker.Binary(Javac.getCtcInt(JCTree.class, "NE"), thisFieldAccessor, otherFieldAccessor), this.returnBool(maker, false), null));
                continue;
            }
            if (fType instanceof JCTree.JCArrayTypeTree) {
                boolean multiDim = ((JCTree.JCArrayTypeTree)fType).elemtype instanceof JCTree.JCArrayTypeTree;
                boolean primitiveArray = ((JCTree.JCArrayTypeTree)fType).elemtype instanceof JCTree.JCPrimitiveTypeTree;
                boolean useDeepEquals = multiDim || !primitiveArray;
                JCTree.JCExpression eqMethod = JavacHandlerUtil.chainDots(typeNode, "java", "util", "Arrays", useDeepEquals ? "deepEquals" : "equals");
                List<JCTree.JCExpression> args = List.of(thisFieldAccessor, otherFieldAccessor);
                statements.append(maker.If(maker.Unary(Javac.getCtcInt(JCTree.class, "NOT"), maker.Apply(List.<JCTree.JCExpression>nil(), eqMethod, args)), this.returnBool(maker, false), null));
                continue;
            }
            JCTree.JCBinary thisEqualsNull = maker.Binary(Javac.getCtcInt(JCTree.class, "EQ"), thisFieldAccessor, maker.Literal(Javac.getCtcInt(TypeTags.class, "BOT"), null));
            JCTree.JCBinary otherNotEqualsNull = maker.Binary(Javac.getCtcInt(JCTree.class, "NE"), otherFieldAccessor, maker.Literal(Javac.getCtcInt(TypeTags.class, "BOT"), null));
            JCTree.JCExpression equalsArg = JavacHandlerUtil.createFieldAccessor(maker, fieldNode, fieldAccess, maker.Ident(otherName));
            JCTree.JCTypeCast castEqualsArg = maker.TypeCast(JavacHandlerUtil.chainDots(typeNode, "java", "lang", "Object"), equalsArg);
            JCTree.JCMethodInvocation thisEqualsThat = maker.Apply(List.<JCTree.JCExpression>nil(), maker.Select(JavacHandlerUtil.createFieldAccessor(maker, fieldNode, fieldAccess), typeNode.toName("equals")), List.of(castEqualsArg));
            JCTree.JCConditional fieldsAreNotEqual = maker.Conditional(thisEqualsNull, otherNotEqualsNull, maker.Unary(Javac.getCtcInt(JCTree.class, "NOT"), thisEqualsThat));
            statements.append(maker.If(fieldsAreNotEqual, this.returnBool(maker, false), null));
        }
        statements.append(this.returnBool(maker, true));
        JCTree.JCBlock body = maker.Block(0L, statements.toList());
        return JavacHandlerUtil.recursiveSetGeneratedBy(maker.MethodDef(mods, typeNode.toName("equals"), returnType, List.<JCTree.JCTypeParameter>nil(), params, List.<JCTree.JCExpression>nil(), body, null), source);
    }

    private JCTree.JCMethodDecl createCanEqual(JavacNode typeNode, JCTree source) {
        TreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCModifiers mods = maker.Modifiers(1L, List.<JCTree.JCAnnotation>nil());
        JCTree.JCPrimitiveTypeTree returnType = maker.TypeIdent(Javac.getCtcInt(TypeTags.class, "BOOLEAN"));
        Name canEqualName = typeNode.toName("canEqual");
        JCTree.JCExpression objectType = JavacHandlerUtil.chainDots(typeNode, "java", "lang", "Object");
        Name otherName = typeNode.toName("other");
        List<JCTree.JCVariableDecl> params = List.of(maker.VarDef(maker.Modifiers(16L), otherName, objectType, null));
        JCTree.JCBlock body = maker.Block(0L, List.of(maker.Return(maker.TypeTest(maker.Ident(otherName), this.createTypeReference(typeNode)))));
        return JavacHandlerUtil.recursiveSetGeneratedBy(maker.MethodDef(mods, canEqualName, returnType, List.<JCTree.JCTypeParameter>nil(), params, List.<JCTree.JCExpression>nil(), body, null), source);
    }

    private JCTree.JCStatement generateCompareFloatOrDouble(JCTree.JCExpression thisDotField, JCTree.JCExpression otherDotField, TreeMaker maker, JavacNode node, boolean isDouble) {
        JCTree.JCExpression clazz = JavacHandlerUtil.chainDots(node, "java", "lang", isDouble ? "Double" : "Float");
        List<JCTree.JCExpression> args = List.of(thisDotField, otherDotField);
        JCTree.JCBinary compareCallEquals0 = maker.Binary(Javac.getCtcInt(JCTree.class, "NE"), maker.Apply(List.<JCTree.JCExpression>nil(), maker.Select(clazz, node.toName("compare")), args), maker.Literal(0));
        return maker.If(compareCallEquals0, this.returnBool(maker, false), null);
    }

    private JCTree.JCStatement returnBool(TreeMaker maker, boolean bool) {
        return maker.Return(maker.Literal(Javac.getCtcInt(TypeTags.class, "BOOLEAN"), bool ? 1 : 0));
    }
}

