/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac;

import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeCopier;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public class TreeMirrorMaker
extends TreeCopier<Void> {
    private final IdentityHashMap<JCTree, JCTree> originalToCopy = new IdentityHashMap();

    public TreeMirrorMaker(TreeMaker maker) {
        super(maker);
    }

    @Override
    public <T extends JCTree> T copy(T original) {
        T copy = super.copy(original);
        this.originalToCopy.put(original, copy);
        return copy;
    }

    @Override
    public <T extends JCTree> T copy(T original, Void p) {
        T copy = super.copy(original, p);
        this.originalToCopy.put(original, copy);
        return copy;
    }

    @Override
    public <T extends JCTree> List<T> copy(List<T> originals) {
        List<T> copies = super.copy(originals);
        if (originals != null) {
            Iterator<T> it1 = originals.iterator();
            Iterator<T> it2 = copies.iterator();
            while (it1.hasNext()) {
                this.originalToCopy.put((JCTree)it1.next(), (JCTree)it2.next());
            }
        }
        return copies;
    }

    @Override
    public <T extends JCTree> List<T> copy(List<T> originals, Void p) {
        List<T> copies = super.copy(originals, p);
        if (originals != null) {
            Iterator<T> it1 = originals.iterator();
            Iterator<T> it2 = copies.iterator();
            while (it1.hasNext()) {
                this.originalToCopy.put((JCTree)it1.next(), (JCTree)it2.next());
            }
        }
        return copies;
    }

    public Map<JCTree, JCTree> getOriginalToCopyMap() {
        return Collections.unmodifiableMap(this.originalToCopy);
    }

    @Override
    public JCTree visitVariable(VariableTree node, Void p) {
        JCTree.JCVariableDecl copy = (JCTree.JCVariableDecl)super.visitVariable(node, p);
        copy.sym = ((JCTree.JCVariableDecl)node).sym;
        return copy;
    }
}

