/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.agent;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import lombok.core.DiagnosticsReceiver;
import lombok.core.PostCompiler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.core.dom.rewrite.TokenScanner;

public class PatchFixes {
    public static final int ALREADY_PROCESSED_FLAG = 0x800000;

    public static int fixRetrieveStartingCatchPosition(int original, int start) {
        return original == -1 ? start : original;
    }

    public static int fixRetrieveIdentifierEndPosition(int original, int end) {
        return original == -1 ? end : original;
    }

    public static int fixRetrieveEllipsisStartPosition(int original, int end) {
        return original == -1 ? end : original;
    }

    public static boolean checkBit24(Object node) throws Exception {
        int bits = (Integer)node.getClass().getField("bits").get(node);
        return (bits & 0x800000) != 0;
    }

    public static boolean skipRewritingGeneratedNodes(ASTNode node) throws Exception {
        return (Boolean)node.getClass().getField("$isGenerated").get(node);
    }

    public static void setIsGeneratedFlag(ASTNode domNode, org.eclipse.jdt.internal.compiler.ast.ASTNode internalNode) throws Exception {
        boolean isGenerated;
        if (internalNode == null || domNode == null) {
            return;
        }
        boolean bl = isGenerated = internalNode.getClass().getField("$generatedBy").get(internalNode) != null;
        if (isGenerated) {
            domNode.getClass().getField("$isGenerated").set(domNode, true);
            domNode.setFlags(domNode.getFlags() & 0xFFFFFFFD);
        }
    }

    public static void setIsGeneratedFlagForSimpleName(SimpleName name, Object internalNode) throws Exception {
        if (internalNode instanceof org.eclipse.jdt.internal.compiler.ast.ASTNode && internalNode.getClass().getField("$generatedBy").get(internalNode) != null) {
            name.getClass().getField("$isGenerated").set(name, true);
        }
    }

    public static int getTokenEndOffsetFixed(TokenScanner scanner, int token, int startOffset, Object domNode) throws CoreException {
        boolean isGenerated = false;
        try {
            isGenerated = (Boolean)domNode.getClass().getField("$isGenerated").get(domNode);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (isGenerated) {
            return -1;
        }
        return scanner.getTokenEndOffset(token, startOffset);
    }

    public static IMethod[] removeGeneratedMethods(IMethod[] methods) throws Exception {
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        for (IMethod m : methods) {
            if (m.getNameRange().getLength() <= 0) continue;
            result.add(m);
        }
        return result.size() == methods.length ? methods : result.toArray(new IMethod[0]);
    }

    public static SimpleName[] removeGeneratedSimpleNames(SimpleName[] in) throws Exception {
        Field f = SimpleName.class.getField("$isGenerated");
        int count = 0;
        for (int i = 0; i < in.length; ++i) {
            if (in[i] != null && ((Boolean)f.get(in[i])).booleanValue()) continue;
            ++count;
        }
        if (count == in.length) {
            return in;
        }
        SimpleName[] newSimpleNames = new SimpleName[count];
        count = 0;
        for (int i = 0; i < in.length; ++i) {
            if (in[i] != null && ((Boolean)f.get(in[i])).booleanValue()) continue;
            newSimpleNames[count++] = in[i];
        }
        return newSimpleNames;
    }

    public static byte[] runPostCompiler(byte[] bytes, String fileName) {
        byte[] transformed = PostCompiler.applyTransformations(bytes, fileName, DiagnosticsReceiver.CONSOLE);
        return transformed == null ? bytes : transformed;
    }

    public static OutputStream runPostCompiler(OutputStream out) throws IOException {
        return PostCompiler.wrapOutputStream(out, "TEST", DiagnosticsReceiver.CONSOLE);
    }

    public static BufferedOutputStream runPostCompiler(BufferedOutputStream out, String path, String name) throws IOException {
        String fileName = path + "/" + name;
        return new BufferedOutputStream(PostCompiler.wrapOutputStream(out, fileName, DiagnosticsReceiver.CONSOLE));
    }

    public static Annotation[] convertAnnotations(Annotation[] out, IAnnotatable annotatable) {
        IAnnotation[] in;
        try {
            in = annotatable.getAnnotations();
        }
        catch (Exception e) {
            return out;
        }
        if (out == null) {
            return null;
        }
        int toWrite = 0;
        for (int idx = 0; idx < out.length; ++idx) {
            String oName = new String(out[idx].type.getLastToken());
            boolean found = false;
            for (IAnnotation i : in) {
                String name = i.getElementName();
                int li = name.lastIndexOf(46);
                if (li > -1) {
                    name = name.substring(li + 1);
                }
                if (!name.equals(oName)) continue;
                found = true;
                break;
            }
            if (!found) {
                out[idx] = null;
                continue;
            }
            ++toWrite;
        }
        Annotation[] replace = out;
        if (toWrite < out.length) {
            replace = new Annotation[toWrite];
            int idx = 0;
            for (int i = 0; i < out.length; ++i) {
                if (out[i] == null) continue;
                replace[idx++] = out[i];
            }
        }
        return replace;
    }
}

