/*
 * Decompiled with CFR 0.152.
 */
package lombok.bytecode;

import java.util.concurrent.atomic.AtomicBoolean;
import lombok.bytecode.AsmUtil;
import lombok.bytecode.ClassFileMetaData;
import lombok.bytecode.FixedClassWriter;
import lombok.bytecode.SneakyThrowsRemover;
import lombok.core.DiagnosticsReceiver;
import lombok.core.PostCompilerTransformation;
import lombok.libs.org.objectweb.asm.AnnotationVisitor;
import lombok.libs.org.objectweb.asm.Attribute;
import lombok.libs.org.objectweb.asm.ClassAdapter;
import lombok.libs.org.objectweb.asm.ClassReader;
import lombok.libs.org.objectweb.asm.Label;
import lombok.libs.org.objectweb.asm.MethodAdapter;
import lombok.libs.org.objectweb.asm.MethodVisitor;

public class SneakyThrowsRemover
implements PostCompilerTransformation {
    public byte[] applyTransformations(byte[] original, String fileName, DiagnosticsReceiver diagnostics) {
        if (!new ClassFileMetaData(original).usesMethod("lombok/Lombok", "sneakyThrow")) {
            return null;
        }
        byte[] fixedByteCode = AsmUtil.fixJSRInlining(original);
        ClassReader reader = new ClassReader(fixedByteCode);
        FixedClassWriter writer = new FixedClassWriter(reader, 3);
        final AtomicBoolean changesMade = new AtomicBoolean();
        reader.accept(new ClassAdapter(writer){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class SneakyThrowsRemoverVisitor
                extends MethodAdapter {
                    boolean justAddedAthrow;
                    final /* synthetic */ AtomicBoolean val$changesMade;
                    final /* synthetic */ SneakyThrowsRemover this$0;

                    SneakyThrowsRemoverVisitor(MethodVisitor mv) {
                        this.this$0 = sneakyThrowsRemover;
                        this.val$changesMade = atomicBoolean;
                        super(mv);
                        this.justAddedAthrow = false;
                    }

                    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                        this.justAddedAthrow = false;
                        boolean hit = true;
                        if (hit && opcode != 184) {
                            hit = false;
                        }
                        if (hit && !"sneakyThrow".equals(name)) {
                            hit = false;
                        }
                        if (hit && !"lombok/Lombok".equals(owner)) {
                            hit = false;
                        }
                        if (hit && !"(Ljava/lang/Throwable;)Ljava/lang/RuntimeException;".equals(desc)) {
                            hit = false;
                        }
                        if (hit) {
                            this.val$changesMade.set(true);
                            this.justAddedAthrow = true;
                            super.visitInsn(191);
                        } else {
                            super.visitMethodInsn(opcode, owner, name, desc);
                        }
                    }

                    public void visitInsn(int opcode) {
                        if (!this.justAddedAthrow || opcode != 191) {
                            super.visitInsn(opcode);
                        }
                        this.justAddedAthrow = false;
                    }

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        this.justAddedAthrow = false;
                        return super.visitAnnotation(desc, visible);
                    }

                    public AnnotationVisitor visitAnnotationDefault() {
                        this.justAddedAthrow = false;
                        return super.visitAnnotationDefault();
                    }

                    public void visitAttribute(Attribute attr) {
                        this.justAddedAthrow = false;
                        super.visitAttribute(attr);
                    }

                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        this.justAddedAthrow = false;
                        super.visitFieldInsn(opcode, owner, name, desc);
                    }

                    public void visitIincInsn(int var, int increment) {
                        this.justAddedAthrow = false;
                        super.visitIincInsn(var, increment);
                    }

                    public void visitIntInsn(int opcode, int operand) {
                        this.justAddedAthrow = false;
                        super.visitIntInsn(opcode, operand);
                    }

                    public void visitJumpInsn(int opcode, Label label) {
                        this.justAddedAthrow = false;
                        super.visitJumpInsn(opcode, label);
                    }

                    public void visitLabel(Label label) {
                        this.justAddedAthrow = false;
                        super.visitLabel(label);
                    }

                    public void visitLdcInsn(Object cst) {
                        this.justAddedAthrow = false;
                        super.visitLdcInsn(cst);
                    }

                    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                        this.justAddedAthrow = false;
                        super.visitLocalVariable(name, desc, signature, start, end, index);
                    }

                    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                        this.justAddedAthrow = false;
                        super.visitLookupSwitchInsn(dflt, keys, labels);
                    }

                    public void visitMultiANewArrayInsn(String desc, int dims) {
                        this.justAddedAthrow = false;
                        super.visitMultiANewArrayInsn(desc, dims);
                    }

                    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                        this.justAddedAthrow = false;
                        return super.visitParameterAnnotation(parameter, desc, visible);
                    }

                    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
                        this.justAddedAthrow = false;
                        super.visitTableSwitchInsn(min, max, dflt, labels);
                    }

                    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                        this.justAddedAthrow = false;
                        super.visitTryCatchBlock(start, end, handler, type);
                    }

                    public void visitTypeInsn(int opcode, String type) {
                        this.justAddedAthrow = false;
                        super.visitTypeInsn(opcode, type);
                    }

                    public void visitVarInsn(int opcode, int var) {
                        this.justAddedAthrow = false;
                        super.visitVarInsn(opcode, var);
                    }
                }
                return new SneakyThrowsRemoverVisitor(SneakyThrowsRemover.this, super.visitMethod(access, name, desc, signature, exceptions), changesMade);
            }
        }, 0);
        return changesMade.get() ? writer.toByteArray() : null;
    }
}

