/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.rule;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.junit.runners.model.Statement;
import org.powermock.core.MockRepository;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.proxyframework.RegisterProxyFramework;

class PowerMockStatement
extends Statement {
    private static final String ANNOTATION_ENABLER = "org.powermock.api.extension.listener.AnnotationEnabler";
    private final Statement fNext;
    private final Object target;

    public PowerMockStatement(Statement base, Object target) {
        this.fNext = base;
        this.target = target;
    }

    public void evaluate() throws Throwable {
        Object annotationEnabler = this.loadAnnotationEnableIfPresent();
        try {
            this.injectMocksUsingAnnotationEnabler(this.target, annotationEnabler);
            PowerMockStatement.registerProxyFramework();
            this.fNext.evaluate();
        }
        finally {
            MockRepository.clear();
            this.clearMockFields(this.target, annotationEnabler);
        }
    }

    private Object loadAnnotationEnableIfPresent() {
        boolean hasAnnotationEnabler = this.hasClass(ANNOTATION_ENABLER);
        if (!hasAnnotationEnabler) {
            return null;
        }
        try {
            return Whitebox.invokeConstructor(Class.forName(ANNOTATION_ENABLER, true, Thread.currentThread().getContextClassLoader()), (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("PowerMock internal error, failed to load annotation enabler.");
        }
    }

    private boolean hasClass(String className) {
        try {
            Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void clearMockFields(Object target, Object annotationEnabler) throws Exception {
        if (annotationEnabler != null) {
            Class[] mockAnnotations = (Class[])Whitebox.invokeMethod((Object)annotationEnabler, (String)"getMockAnnotations", (Object[])new Object[0]);
            Set mockFields = Whitebox.getFieldsAnnotatedWith((Object)target, (Class[])mockAnnotations);
            for (Field field : mockFields) {
                field.set(target, null);
            }
        }
    }

    private void injectMocksUsingAnnotationEnabler(Object target, Object annotationEnabler) throws Exception {
        if (annotationEnabler != null) {
            Whitebox.invokeMethod((Object)annotationEnabler, (String)"beforeTestMethod", (Class[])new Class[]{Object.class, Method.class, Object[].class}, (Object[])new Object[]{target, null, null});
        }
    }

    private static void registerProxyFramework() {
        Class<?> proxyFrameworkClass;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            proxyFrameworkClass = Class.forName("org.powermock.api.extension.proxyframework.ProxyFrameworkImpl", false, contextClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Extension API error: org.powermock.api.extension.proxyframework.ProxyFrameworkImpl could not be located in classpath.");
        }
        Class<?> proxyFrameworkRegistrar = null;
        try {
            proxyFrameworkRegistrar = Class.forName(RegisterProxyFramework.class.getName(), false, contextClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            Whitebox.invokeMethod(proxyFrameworkRegistrar, (String)"registerProxyFramework", (Object[])new Object[]{Whitebox.newInstance(proxyFrameworkClass)});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

