/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.MethodInvocationControl;
import org.powermock.core.spi.NewInvocationControl;
import org.powermock.reflect.exceptions.MethodNotFoundException;
import org.powermock.reflect.internal.TypeUtils;
import org.powermock.reflect.internal.WhiteboxImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockGateway {
    public static final Object PROCEED = new Object();
    public static final Object SUPPRESS = new Object();
    public static final String DONT_MOCK_NEXT_CALL = "DontMockNextCall";
    public static boolean MOCK_STANDARD_METHODS = true;
    public static boolean MOCK_GET_CLASS_METHOD = false;

    public static Object methodCall(Class<?> type, String methodName, Object[] args, Class<?>[] sig, String returnTypeAsString) throws Throwable {
        return MockGateway.doMethodCall(type, methodName, args, sig, returnTypeAsString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object doMethodCall(Object object, String methodName, Object[] args, Class<?>[] sig, String returnTypeAsString) throws Throwable, NoSuchMethodException {
        if (!MockGateway.shouldMockMethod(methodName, sig)) {
            return PROCEED;
        }
        Object returnValue = null;
        MethodInvocationControl methodInvocationControl = null;
        Class objectType = null;
        if (object instanceof Class) {
            objectType = (Class)object;
            methodInvocationControl = MockRepository.getStaticMethodInvocationControl(objectType);
        } else {
            Class<?> type = object.getClass();
            objectType = WhiteboxImpl.getUnmockedType(type);
            methodInvocationControl = MockRepository.getInstanceMethodInvocationControl(object);
        }
        Method method = null;
        try {
            method = WhiteboxImpl.getBestMethodCandidate((Class)objectType, (String)methodName, (Class[])sig, (boolean)true);
        }
        catch (MethodNotFoundException e) {
            try {
                method = WhiteboxImpl.getMethod(Class.class, (String)methodName, (Class[])sig);
            }
            catch (MethodNotFoundException e2) {
                throw e;
            }
        }
        if (method.getName().equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class && Modifier.isFinal(method.getModifiers())) {
            returnValue = PROCEED;
        } else if (methodInvocationControl != null && methodInvocationControl.isMocked(method) && MockGateway.shouldMockThisCall()) {
            returnValue = methodInvocationControl.invoke(object, method, args);
            if (returnValue == SUPPRESS) {
                returnValue = TypeUtils.getDefaultValue((String)returnTypeAsString);
            }
        } else if (MockRepository.hasMethodProxy(method)) {
            InvocationHandler invocationHandler = MockRepository.removeMethodProxy(method);
            try {
                returnValue = invocationHandler.invoke(object, method, args);
            }
            finally {
                MockRepository.putMethodProxy(method, invocationHandler);
            }
        } else {
            returnValue = MockRepository.shouldSuppressMethod(method, objectType) ? TypeUtils.getDefaultValue((String)returnTypeAsString) : (MockRepository.shouldStubMethod(method) ? MockRepository.getMethodToStub(method) : PROCEED);
        }
        return returnValue;
    }

    private static boolean shouldMockMethod(String methodName, Class<?>[] sig) {
        if (MockGateway.isJavaStandardMethod(methodName, sig) && !MOCK_STANDARD_METHODS) {
            return false;
        }
        return !MockGateway.isGetClassMethod(methodName, sig) || MOCK_GET_CLASS_METHOD;
    }

    private static boolean isJavaStandardMethod(String methodName, Class<?>[] sig) {
        return methodName.equals("equals") && sig.length == 1 || methodName.equals("hashCode") && sig.length == 0 || methodName.equals("toString") && sig.length == 0;
    }

    private static boolean isGetClassMethod(String methodName, Class<?>[] sig) {
        return methodName.equals("getClass") && sig.length == 0;
    }

    private static boolean shouldMockThisCall() {
        Object shouldSkipMockingOfNextCall = MockRepository.getAdditionalState(DONT_MOCK_NEXT_CALL);
        boolean shouldMockThisCall = shouldSkipMockingOfNextCall == null;
        MockRepository.removeAdditionalState(DONT_MOCK_NEXT_CALL);
        return shouldMockThisCall;
    }

    public static Object methodCall(Object instance, String methodName, Object[] args, Class<?>[] sig, String returnTypeAsString) throws Throwable {
        return MockGateway.doMethodCall(instance, methodName, args, sig, returnTypeAsString);
    }

    public static Object newInstanceCall(Class<?> type, Object[] args, Class<?>[] sig) throws Throwable {
        NewInvocationControl<?> newInvocationControl = MockRepository.getNewInstanceControl(type);
        if (newInvocationControl != null) {
            if (type.isMemberClass() && Modifier.isStatic(type.getModifiers())) {
                if (args.length > 0 && (args[0] == null || args[args.length - 1] == null) && sig.length > 0) {
                    args = MockGateway.copyArgumentsForInnerOrLocalOrAnonymousClass(args, false);
                }
            } else if ((type.isLocalClass() || type.isAnonymousClass() || type.isMemberClass()) && args.length > 0 && sig.length > 0 && sig[0].equals(type.getEnclosingClass())) {
                args = MockGateway.copyArgumentsForInnerOrLocalOrAnonymousClass(args, true);
            }
            return newInvocationControl.invoke(type, args, sig);
        }
        if (MockRepository.shouldSuppressConstructor(WhiteboxImpl.getConstructor(type, (Class[])sig))) {
            return WhiteboxImpl.getFirstParentConstructor(type);
        }
        return PROCEED;
    }

    public static Object fieldCall(Object instanceOrClassContainingTheField, Class<?> classDefiningField, String fieldName, Class<?> fieldType) {
        if (MockRepository.shouldSuppressField(WhiteboxImpl.getField(classDefiningField, (String)fieldName))) {
            return TypeUtils.getDefaultValue(fieldType);
        }
        return PROCEED;
    }

    public static Object staticConstructorCall(String className) {
        if (MockRepository.shouldSuppressStaticInitializerFor(className)) {
            return "suppress";
        }
        return PROCEED;
    }

    public static Object constructorCall(Class<?> type, Object[] args, Class<?>[] sig) throws Throwable {
        Constructor constructor = WhiteboxImpl.getConstructor(type, (Class[])sig);
        if (MockRepository.shouldSuppressConstructor(constructor)) {
            return null;
        }
        return PROCEED;
    }

    private static Object[] copyArgumentsForInnerOrLocalOrAnonymousClass(Object[] args, boolean excludeEnclosingInstance) {
        Object[] newArgs = new Object[args.length - 1];
        int start = 0;
        int end = 0;
        int j = 0;
        if (args[0] == null || excludeEnclosingInstance) {
            start = 1;
            end = args.length;
        } else {
            start = 0;
            end = args.length - 1;
        }
        for (int i = start; i < end; ++i) {
            newArgs[j++] = args[i];
        }
        args = newArgs;
        return args;
    }
}

