/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.BuiltinCodecSupport;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import reactor.util.annotation.Nullable;

final class BooleanCodec
extends BuiltinCodecSupport<Boolean> {
    BooleanCodec(ByteBufAllocator byteBufAllocator) {
        super(Boolean.class, byteBufAllocator, PostgresqlObjectId.BOOL, PostgresqlObjectId.BOOL_ARRAY, it -> it != false ? "t" : "f");
    }

    @Override
    Boolean doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, @Nullable Format format, @Nullable Class<? extends Boolean> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        if (format == Format.FORMAT_BINARY) {
            return buffer.readBoolean();
        }
        String decoded = ByteBufUtils.decode(buffer);
        return "1".equals(decoded) || "true".equalsIgnoreCase(decoded) || "t".equalsIgnoreCase(decoded) || "yes".equalsIgnoreCase(decoded) || "y".equalsIgnoreCase(decoded) || "on".equalsIgnoreCase(decoded);
    }
}

