/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.netty.handler.ssl.SslContextBuilder;
import io.r2dbc.postgresql.MultiHostConnectionStrategy;
import io.r2dbc.postgresql.OptionMapper;
import io.r2dbc.postgresql.PostgresqlConnectionConfiguration;
import io.r2dbc.postgresql.PostgresqlConnectionFactory;
import io.r2dbc.postgresql.client.SSLMode;
import io.r2dbc.postgresql.extension.Extension;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.LogLevel;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.ConnectionFactoryProvider;
import io.r2dbc.spi.Option;
import java.time.Duration;
import java.time.ZoneId;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import reactor.netty.resources.LoopResources;

public final class PostgresqlConnectionFactoryProvider
implements ConnectionFactoryProvider {
    public static final Option<String> APPLICATION_NAME = Option.valueOf((String)"applicationName");
    public static final Option<Boolean> AUTODETECT_EXTENSIONS = Option.valueOf((String)"autodetectExtensions");
    public static final Option<Boolean> COMPATIBILITY_MODE = Option.valueOf((String)"compatibilityMode");
    public static final Option<LogLevel> ERROR_RESPONSE_LOG_LEVEL = Option.valueOf((String)"errorResponseLogLevel");
    public static final Option<Collection<Extension>> EXTENSIONS = Option.valueOf((String)"extensions");
    public static final Option<Integer> FETCH_SIZE = Option.valueOf((String)"fetchSize");
    public static final Option<Boolean> FORCE_BINARY = Option.valueOf((String)"forceBinary");
    public static final Option<Duration> HOST_RECHECK_TIME = Option.valueOf((String)"hostRecheckTime");
    public static final Option<Boolean> LOAD_BALANCE_HOSTS = Option.valueOf((String)"loadBalanceHosts");
    public static final Option<Duration> LOCK_WAIT_TIMEOUT = ConnectionFactoryOptions.LOCK_WAIT_TIMEOUT;
    public static final Option<LoopResources> LOOP_RESOURCES = Option.valueOf((String)"loopResources");
    public static final Option<LogLevel> NOTICE_LOG_LEVEL = Option.valueOf((String)"noticeLogLevel");
    public static final Option<Map<String, String>> OPTIONS = Option.valueOf((String)"options");
    public static final String POSTGRESQL_DRIVER = "postgresql";
    public static final String LEGACY_POSTGRESQL_DRIVER = "postgres";
    public static final String FAILOVER_PROTOCOL = "failover";
    public static final Option<Boolean> PREFER_ATTACHED_BUFFERS = Option.valueOf((String)"preferAttachedBuffers");
    public static final Option<Integer> PREPARED_STATEMENT_CACHE_QUERIES = Option.valueOf((String)"preparedStatementCacheQueries");
    public static final Option<String> SCHEMA = Option.valueOf((String)"schema");
    public static final Option<String> CURRENT_SCHEMA = Option.valueOf((String)"currentSchema");
    public static final Option<String> SOCKET = Option.valueOf((String)"socket");
    public static final Option<Function<SslContextBuilder, SslContextBuilder>> SSL_CONTEXT_BUILDER_CUSTOMIZER = Option.valueOf((String)"sslContextBuilderCustomizer");
    public static final Option<String> SSL_CERT = Option.valueOf((String)"sslCert");
    public static final Option<HostnameVerifier> SSL_HOSTNAME_VERIFIER = Option.valueOf((String)"sslHostnameVerifier");
    public static final Option<String> SSL_KEY = Option.valueOf((String)"sslKey");
    public static final Option<SSLMode> SSL_MODE = Option.valueOf((String)"sslMode");
    public static final Option<SSLMode> SSL_MODE_ALIAS = Option.valueOf((String)"sslmode");
    public static final Option<String> SSL_PASSWORD = Option.valueOf((String)"sslPassword");
    public static final Option<String> SSL_ROOT_CERT = Option.valueOf((String)"sslRootCert");
    public static final Option<Duration> STATEMENT_TIMEOUT = ConnectionFactoryOptions.STATEMENT_TIMEOUT;
    public static final Option<MultiHostConnectionStrategy.TargetServerType> TARGET_SERVER_TYPE = Option.valueOf((String)"targetServerType");
    public static final Option<Boolean> TCP_KEEPALIVE = Option.valueOf((String)"tcpKeepAlive");
    public static final Option<Boolean> TCP_NODELAY = Option.valueOf((String)"tcpNoDelay");
    public static final Option<TimeZone> TIME_ZONE = Option.valueOf((String)"timeZone");

    public static PostgresqlConnectionConfiguration.Builder builder(ConnectionFactoryOptions connectionFactoryOptions) {
        return PostgresqlConnectionFactoryProvider.fromConnectionFactoryOptions(connectionFactoryOptions);
    }

    public PostgresqlConnectionFactory create(ConnectionFactoryOptions connectionFactoryOptions) {
        return new PostgresqlConnectionFactory(PostgresqlConnectionFactoryProvider.builder(connectionFactoryOptions).build());
    }

    public String getDriver() {
        return POSTGRESQL_DRIVER;
    }

    public boolean supports(ConnectionFactoryOptions connectionFactoryOptions) {
        Assert.requireNonNull(connectionFactoryOptions, "connectionFactoryOptions must not be null");
        String driver = "" + connectionFactoryOptions.getValue(ConnectionFactoryOptions.DRIVER);
        return driver != null && (driver.equals(POSTGRESQL_DRIVER) || driver.equals(LEGACY_POSTGRESQL_DRIVER));
    }

    private static PostgresqlConnectionConfiguration.Builder fromConnectionFactoryOptions(ConnectionFactoryOptions options) {
        Assert.requireNonNull(options, "connectionFactoryOptions must not be null");
        PostgresqlConnectionConfiguration.Builder builder = PostgresqlConnectionConfiguration.builder();
        OptionMapper mapper = OptionMapper.create(options);
        String protocol = (String)options.getValue(ConnectionFactoryOptions.PROTOCOL);
        if (FAILOVER_PROTOCOL.equals(protocol)) {
            mapper.from(HOST_RECHECK_TIME).map(OptionMapper::toDuration).to(builder::hostRecheckTime);
            mapper.from(LOAD_BALANCE_HOSTS).map(OptionMapper::toBoolean).to(builder::loadBalanceHosts);
            mapper.from(TARGET_SERVER_TYPE).map(value -> {
                if (value instanceof MultiHostConnectionStrategy.TargetServerType) {
                    return (MultiHostConnectionStrategy.TargetServerType)value;
                }
                return MultiHostConnectionStrategy.TargetServerType.fromValue(value.toString());
            }).to(builder::targetServerType);
            String hosts = "" + options.getRequiredValue(ConnectionFactoryOptions.HOST);
            for (String host : hosts.split(",")) {
                String[] hostParts = host.split(":");
                if (hostParts.length == 1) {
                    builder.addHost(host);
                    continue;
                }
                builder.addHost(hostParts[0], OptionMapper.toInteger(hostParts[1]));
            }
            PostgresqlConnectionFactoryProvider.setupSsl(builder, mapper);
        } else {
            mapper.fromTyped(SOCKET).to(builder::socket).otherwise(() -> {
                builder.host("" + options.getRequiredValue(ConnectionFactoryOptions.HOST));
                PostgresqlConnectionFactoryProvider.setupSsl(builder, mapper);
            });
        }
        mapper.fromTyped(APPLICATION_NAME).to(builder::applicationName);
        mapper.from(AUTODETECT_EXTENSIONS).map(OptionMapper::toBoolean).to(builder::autodetectExtensions);
        mapper.from(COMPATIBILITY_MODE).map(OptionMapper::toBoolean).to(builder::compatibilityMode);
        mapper.from(ConnectionFactoryOptions.CONNECT_TIMEOUT).map(OptionMapper::toDuration).to(builder::connectTimeout);
        mapper.fromTyped(CURRENT_SCHEMA).to(builder::schema).otherwise(() -> mapper.fromTyped(SCHEMA).to(builder::schema));
        mapper.fromTyped(ConnectionFactoryOptions.DATABASE).to(builder::database);
        mapper.from(ERROR_RESPONSE_LOG_LEVEL).map(it -> OptionMapper.toEnum(it, LogLevel.class)).to(builder::errorResponseLogLevel);
        mapper.fromTyped(EXTENSIONS).to(extensions -> extensions.forEach(builder::extendWith));
        mapper.from(FETCH_SIZE).map(OptionMapper::toInteger).to(builder::fetchSize);
        mapper.from(FORCE_BINARY).map(OptionMapper::toBoolean).to(builder::forceBinary);
        mapper.from(LOCK_WAIT_TIMEOUT).map(OptionMapper::toDuration).to(builder::lockWaitTimeout);
        mapper.fromTyped(LOOP_RESOURCES).to(builder::loopResources);
        mapper.from(NOTICE_LOG_LEVEL).map(it -> OptionMapper.toEnum(it, LogLevel.class)).to(builder::noticeLogLevel);
        mapper.from(OPTIONS).map(PostgresqlConnectionFactoryProvider::convertToMap).to(builder::options);
        mapper.fromTyped(ConnectionFactoryOptions.PASSWORD).to(builder::password);
        mapper.from(ConnectionFactoryOptions.PORT).map(OptionMapper::toInteger).to(builder::port);
        mapper.from(PREFER_ATTACHED_BUFFERS).map(OptionMapper::toBoolean).to(builder::preferAttachedBuffers);
        mapper.from(PREPARED_STATEMENT_CACHE_QUERIES).map(OptionMapper::toInteger).to(builder::preparedStatementCacheQueries);
        mapper.from(STATEMENT_TIMEOUT).map(OptionMapper::toDuration).to(builder::statementTimeout);
        mapper.from(TCP_KEEPALIVE).map(OptionMapper::toBoolean).to(builder::tcpKeepAlive);
        mapper.from(TCP_NODELAY).map(OptionMapper::toBoolean).to(builder::tcpNoDelay);
        mapper.from(TIME_ZONE).map(it -> {
            if (it instanceof TimeZone) {
                return (TimeZone)it;
            }
            if (it instanceof ZoneId) {
                return TimeZone.getTimeZone((ZoneId)it);
            }
            return TimeZone.getTimeZone(it.toString());
        }).to(builder::timeZone);
        builder.username("" + options.getRequiredValue(ConnectionFactoryOptions.USER));
        return builder;
    }

    private static void setupSsl(PostgresqlConnectionConfiguration.Builder builder, OptionMapper mapper) {
        mapper.from(ConnectionFactoryOptions.SSL).map(OptionMapper::toBoolean).to(enableSsl -> {
            if (enableSsl.booleanValue()) {
                builder.enableSsl();
            }
        });
        mapper.from(SSL_MODE).map(PostgresqlConnectionFactoryProvider::toSSLMode).to(builder::sslMode).otherwise(() -> mapper.from(SSL_MODE_ALIAS).map(PostgresqlConnectionFactoryProvider::toSSLMode).to(builder::sslMode));
        mapper.fromTyped(SSL_CERT).to(builder::sslCert);
        mapper.fromTyped(SSL_CONTEXT_BUILDER_CUSTOMIZER).to(builder::sslContextBuilderCustomizer);
        mapper.fromTyped(SSL_KEY).to(builder::sslKey);
        mapper.fromTyped(SSL_ROOT_CERT).to(builder::sslRootCert);
        mapper.fromTyped(SSL_PASSWORD).to(builder::sslPassword);
        mapper.from(SSL_HOSTNAME_VERIFIER).map(it -> {
            if (it instanceof String) {
                try {
                    Class<?> verifierClass = Class.forName((String)it);
                    Object verifier = verifierClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    return (HostnameVerifier)verifier;
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException("Cannot instantiate " + it, e);
                }
            }
            return (HostnameVerifier)it;
        }).to(builder::sslHostnameVerifier);
    }

    private static SSLMode toSSLMode(Object it) {
        if (it instanceof String) {
            return SSLMode.fromValue(it.toString());
        }
        return (SSLMode)((Object)it);
    }

    private static Map<String, String> convertToMap(Object options) {
        if (options instanceof Map) {
            return (Map)Map.class.cast(options);
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String pair : options.toString().split(";")) {
            String[] items = pair.split("=");
            if (items.length != 2) {
                throw new IllegalArgumentException(String.format("Provided options pair is not a valid name=value pair: %s", pair));
            }
            result.put(items[0], items[1]);
        }
        return result;
    }
}

