/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.r2dbc.postgresql.StatementCache;
import io.r2dbc.postgresql.client.Binding;
import io.r2dbc.postgresql.util.Assert;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

final class IndefiniteStatementCache
implements StatementCache {
    private final Map<String, Map<int[], String>> cache = new ConcurrentHashMap<String, Map<int[], String>>();
    private final AtomicInteger counter = new AtomicInteger();

    IndefiniteStatementCache() {
    }

    @Override
    public String getName(Binding binding, String sql) {
        Assert.requireNonNull(binding, "binding must not be null");
        Assert.requireNonNull(sql, "sql must not be null");
        Map<int[], String> typedMap = this.getTypeMap(sql);
        String name = typedMap.get(binding.getParameterTypes());
        if (name == null) {
            name = "S_" + this.counter.getAndIncrement();
        }
        return name;
    }

    @Override
    public boolean requiresPrepare(Binding binding, String sql) {
        Assert.requireNonNull(binding, "binding must not be null");
        Assert.requireNonNull(sql, "sql must not be null");
        Map<int[], String> typedMap = this.getTypeMap(sql);
        return !typedMap.containsKey(binding.getParameterTypes());
    }

    @Override
    public void put(Binding binding, String sql, String name) {
        Assert.requireNonNull(binding, "binding must not be null");
        Assert.requireNonNull(sql, "sql must not be null");
        Map<int[], String> typedMap = this.getTypeMap(sql);
        typedMap.put(binding.getParameterTypes(), name);
    }

    @Override
    public void evict(String sql) {
        this.cache.remove(sql);
    }

    private Map<int[], String> getTypeMap(String sql) {
        return this.cache.computeIfAbsent(sql, ignore -> new TreeMap((o1, o2) -> {
            if (Arrays.equals(o1, o2)) {
                return 0;
            }
            if (((int[])o1).length != ((int[])o2).length) {
                return ((int[])o1).length - ((int[])o2).length;
            }
            for (int i = 0; i < ((int[])o1).length; ++i) {
                int cmp = Integer.compare(o1[i], o2[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }));
    }

    public String toString() {
        return "IndefiniteStatementCache{cache=" + this.cache + ", counter=" + this.counter + '}';
    }
}

