/*
 * Decompiled with CFR 0.152.
 */
package play.twirl.parser;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.io.Codec;
import scala.io.Codec$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Properties$;

public final class TwirlIO$ {
    public static final TwirlIO$ MODULE$ = new TwirlIO$();
    private static final String defaultEncoding = Properties$.MODULE$.sourceEncoding();
    private static final Codec defaultCodec = Codec$.MODULE$.apply(MODULE$.defaultEncoding());

    public String defaultEncoding() {
        return defaultEncoding;
    }

    public Codec defaultCodec() {
        return defaultCodec;
    }

    public byte[] readStream(InputStream stream) {
        byte[] buffer = new byte[8192];
        int len = stream.read(buffer);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while (len != -1) {
            out.write(buffer, 0, len);
            len = stream.read(buffer);
        }
        return out.toByteArray();
    }

    public byte[] readFile(File file) {
        byte[] byArray;
        FileInputStream is = new FileInputStream(file);
        try {
            byArray = this.readStream(is);
        }
        finally {
            this.closeQuietly(is);
        }
        return byArray;
    }

    public String readStreamAsString(InputStream stream, Codec codec) {
        return new String(this.readStream(stream), codec.name());
    }

    public Codec readStreamAsString$default$2() {
        return this.defaultCodec();
    }

    public String readUrlAsString(URL url, Codec codec) {
        String string;
        InputStream is = url.openStream();
        try {
            string = this.readStreamAsString(is, codec);
        }
        finally {
            this.closeQuietly(is);
        }
        return string;
    }

    public Codec readUrlAsString$default$2() {
        return this.defaultCodec();
    }

    public String readFileAsString(File file, Codec codec) {
        String string;
        FileInputStream is = new FileInputStream(file);
        try {
            string = this.readStreamAsString(is, codec);
        }
        finally {
            this.closeQuietly(is);
        }
        return string;
    }

    public Codec readFileAsString$default$2() {
        return this.defaultCodec();
    }

    public void writeStringToFile(File file, String contents, Codec codec) {
        Object object = !file.getParentFile().exists() ? BoxesRunTime.boxToBoolean((boolean)file.getParentFile().mkdirs()) : BoxedUnit.UNIT;
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), codec.name());
        try {
            writer.write(contents);
        }
        finally {
            this.closeQuietly(writer);
        }
    }

    public Codec writeStringToFile$default$3() {
        return this.defaultCodec();
    }

    public void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void deleteRecursively(File dir2) {
        if (dir2.isDirectory()) {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])dir2.listFiles()), (Function1 & Serializable)dir -> {
                TwirlIO$.MODULE$.deleteRecursively(dir);
                return BoxedUnit.UNIT;
            });
        }
        dir2.delete();
    }

    private TwirlIO$() {
    }
}

