/*
 * Decompiled with CFR 0.152.
 */
package play.twirl.compiler;

import java.io.File;
import java.io.Serializable;
import play.twirl.compiler.GeneratedSource;
import play.twirl.compiler.GeneratedSourceVirtual;
import play.twirl.compiler.Hash$;
import play.twirl.compiler.Source;
import play.twirl.compiler.Source$;
import play.twirl.compiler.StringGrouper$;
import play.twirl.compiler.TemplateCompilationError;
import play.twirl.compiler.TwirlCompiler;
import play.twirl.compiler.TwirlCompiler$ScalaCompat$;
import play.twirl.compiler.TwirlCompiler$TemplateAsFunctionCompiler$;
import play.twirl.parser.TreeNodes;
import play.twirl.parser.TwirlIO$;
import play.twirl.parser.TwirlParser;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.io.Codec;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class TwirlCompiler$ {
    public static final TwirlCompiler$ MODULE$ = new TwirlCompiler$();
    private static final String tripleQuote = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\""), 3);
    private static final String escapedTripleQuote = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\\\""), 3);
    private static final String doubleEscapedTripleQuote = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\\\\\""), 3);
    private static final String tripleQuoteReplacement = new StringBuilder(10).append(MODULE$.escapedTripleQuote()).append(" + \\\"").append(MODULE$.doubleEscapedTripleQuote()).append("\\\" + ").append(MODULE$.escapedTripleQuote()).toString();

    public scala.collection.immutable.Seq<String> defaultImports(String scalaVersion) {
        .colon.colon implicits = scalaVersion.startsWith("3.") ? new .colon.colon((Object)"_root_.play.twirl.api.TwirlFeatureImports.*", (List)new .colon.colon((Object)"_root_.play.twirl.api.TwirlHelperImports.*", (List)new .colon.colon((Object)"scala.language.adhocExtensions", (List)Nil$.MODULE$))) : new .colon.colon((Object)"_root_.play.twirl.api.TwirlFeatureImports._", (List)new .colon.colon((Object)"_root_.play.twirl.api.TwirlHelperImports._", (List)Nil$.MODULE$));
        .colon.colon formats = new .colon.colon((Object)"_root_.play.twirl.api.Html", (List)new .colon.colon((Object)"_root_.play.twirl.api.JavaScript", (List)new .colon.colon((Object)"_root_.play.twirl.api.Txt", (List)new .colon.colon((Object)"_root_.play.twirl.api.Xml", (List)Nil$.MODULE$))));
        return (scala.collection.immutable.Seq)implicits.$plus$plus((IterableOnce)formats);
    }

    public Option<File> compile(File source, File sourceDirectory, File generatedDirectory, String formatterType, Seq<String> additionalImports, Seq<String> constructorAnnotations, Codec codec, boolean inclusiveDot) {
        return this.compile(source, sourceDirectory, generatedDirectory, formatterType, (Option<String>)None$.MODULE$, additionalImports, constructorAnnotations, codec, inclusiveDot);
    }

    public Option<File> compile(File source, File sourceDirectory, File generatedDirectory, String formatterType, Option<String> scalaVersion, Seq<String> additionalImports, Seq<String> constructorAnnotations, Codec codec, boolean inclusiveDot) {
        String resultType = new StringBuilder(11).append(formatterType).append(".Appendable").toString();
        Tuple2<String[], GeneratedSource> tuple2 = this.generatedFile(source, codec, sourceDirectory, generatedDirectory, inclusiveDot);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String[] templateName = (String[])tuple2._1();
        GeneratedSource generatedSource = (GeneratedSource)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)templateName, (Object)generatedSource);
        String[] templateName2 = (String[])tuple22._1();
        GeneratedSource generatedSource2 = (GeneratedSource)tuple22._2();
        if (generatedSource2.needRecompilation(additionalImports)) {
            String generated = this.parseAndGenerateCode(templateName2, TwirlIO$.MODULE$.readFile(source), codec, this.relativePath(source), resultType, formatterType, scalaVersion, additionalImports, constructorAnnotations, inclusiveDot);
            TwirlIO$.MODULE$.writeStringToFile(generatedSource2.file(), generated.toString(), codec);
            return new Some((Object)generatedSource2.file());
        }
        return None$.MODULE$;
    }

    public Seq<String> compile$default$5() {
        return Nil$.MODULE$;
    }

    public Seq<String> compile$default$6() {
        return Nil$.MODULE$;
    }

    public Codec compile$default$7() {
        return TwirlIO$.MODULE$.defaultCodec();
    }

    public boolean compile$default$8() {
        return false;
    }

    public GeneratedSourceVirtual compileVirtual(String content, File source, File sourceDirectory, String resultType, String formatterType, Seq<String> additionalImports, Seq<String> constructorAnnotations, Codec codec, boolean inclusiveDot) {
        return this.compileVirtual(content, source, sourceDirectory, resultType, formatterType, (Option<String>)None$.MODULE$, additionalImports, constructorAnnotations, codec, inclusiveDot);
    }

    public GeneratedSourceVirtual compileVirtual(String content, File source, File sourceDirectory, String resultType, String formatterType, Option<String> scalaVersion, Seq<String> additionalImports, Seq<String> constructorAnnotations, Codec codec, boolean inclusiveDot) {
        Tuple2<String[], GeneratedSourceVirtual> tuple2 = this.generatedFileVirtual(source, sourceDirectory, inclusiveDot);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String[] templateName = (String[])tuple2._1();
        GeneratedSourceVirtual generatedSource = (GeneratedSourceVirtual)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)templateName, (Object)generatedSource);
        String[] templateName2 = (String[])tuple22._1();
        GeneratedSourceVirtual generatedSource2 = (GeneratedSourceVirtual)tuple22._2();
        String generated = this.parseAndGenerateCode(templateName2, content.getBytes(codec.charSet()), codec, this.relativePath(source), resultType, formatterType, scalaVersion, additionalImports, constructorAnnotations, inclusiveDot);
        generatedSource2.setContent(generated);
        return generatedSource2;
    }

    public Seq<String> compileVirtual$default$6() {
        return Nil$.MODULE$;
    }

    public Seq<String> compileVirtual$default$7() {
        return Nil$.MODULE$;
    }

    public Codec compileVirtual$default$8() {
        return TwirlIO$.MODULE$.defaultCodec();
    }

    public boolean compileVirtual$default$9() {
        return false;
    }

    private String relativePath(File file) {
        return new File(".").toURI().relativize(file.toURI()).getPath();
    }

    public String parseAndGenerateCode(String[] templateName, byte[] content, Codec codec, String relativePath, String resultType, String formatterType, Seq<String> additionalImports, Seq<String> constructorAnnotations, boolean inclusiveDot) {
        return this.parseAndGenerateCode(templateName, content, codec, relativePath, resultType, formatterType, (Option<String>)None$.MODULE$, additionalImports, constructorAnnotations, inclusiveDot);
    }

    private String parseAndGenerateCode(String[] templateName, byte[] content, Codec codec, String relativePath, String resultType, String formatterType, Option<String> scalaVersion, Seq<String> additionalImports, Seq<String> constructorAnnotations, boolean inclusiveDot) {
        TwirlParser templateParser = new TwirlParser(inclusiveDot);
        boolean bl = false;
        TwirlParser.Success success = null;
        TwirlParser.ParseResult parseResult = templateParser.parse(new String(content, codec.charSet()));
        if (parseResult instanceof TwirlParser.Success) {
            bl = true;
            success = (TwirlParser.Success)parseResult;
            TreeNodes.Template parsed = success.template();
            TwirlParser.Input rest = success.input();
            if (parsed != null) {
                TreeNodes.Template template = parsed;
                if (rest.atEnd()) {
                    return this.generateFinalTemplate(relativePath, content, Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.dropRight$extension(Predef$.MODULE$.refArrayOps((Object[])templateName), 1)).mkString("."), Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.takeRight$extension(Predef$.MODULE$.refArrayOps((Object[])templateName), 1)).mkString(), template, resultType, formatterType, TwirlCompiler$ScalaCompat$.MODULE$.apply(scalaVersion), additionalImports, constructorAnnotations);
                }
            }
        }
        if (bl) {
            TwirlParser.Input rest = success.input();
            throw new TemplateCompilationError(new File(relativePath), "Not parsed?", rest.pos().line(), rest.pos().column());
        }
        if (parseResult instanceof TwirlParser.Error) {
            TwirlParser.Error error = (TwirlParser.Error)parseResult;
            List errors = error.errors();
            TreeNodes.PosString firstError = (TreeNodes.PosString)errors.head();
            throw new TemplateCompilationError(new File(relativePath), firstError.str(), firstError.pos().line(), firstError.pos().column());
        }
        throw new MatchError((Object)parseResult);
    }

    public Tuple2<String[], GeneratedSource> generatedFile(File template, Codec codec, File sourceDirectory, File generatedDirectory, boolean inclusiveDot) {
        String[] name = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(this.source2TemplateName(template, sourceDirectory, (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.takeRight$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(template.getName()), '.')), 1))), this.source2TemplateName$default$4(), this.source2TemplateName$default$5(), this.source2TemplateName$default$6())), '.');
        String[] templateName = inclusiveDot ? this.addInclusiveDotName(name) : name;
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)templateName), (Object)new GeneratedSource(new File(generatedDirectory, new StringBuilder(15).append(Predef$.MODULE$.wrapRefArray((Object[])templateName).mkString("/")).append(".template.scala").toString()), codec));
    }

    public Tuple2<String[], GeneratedSourceVirtual> generatedFileVirtual(File template, File sourceDirectory, boolean inclusiveDot) {
        String[] name = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(this.source2TemplateName(template, sourceDirectory, (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.takeRight$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(template.getName()), '.')), 1))), this.source2TemplateName$default$4(), this.source2TemplateName$default$5(), this.source2TemplateName$default$6())), '.');
        String[] templateName = inclusiveDot ? this.addInclusiveDotName(name) : name;
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)templateName), (Object)new GeneratedSourceVirtual(new StringBuilder(15).append(Predef$.MODULE$.wrapRefArray((Object[])templateName).mkString("/")).append(".template.scala").toString()));
    }

    public String[] addInclusiveDotName(String[] templateName) {
        if (!ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])templateName))) {
            return (String[])ArrayOps$.MODULE$.patch$extension(Predef$.MODULE$.refArrayOps((Object[])templateName), templateName.length - 1, (IterableOnce)new .colon.colon((Object)new StringBuilder(19).append((String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])templateName))).append("$$TwirlInclusiveDot").toString(), (List)Nil$.MODULE$), 1, ClassTag$.MODULE$.apply(String.class));
        }
        return templateName;
    }

    public String source2TemplateName(File f, File sourceDirectory, String ext, String suffix, String topDirectory, boolean setExt) {
        Tuple2 tuple2;
        while (true) {
            Regex Name = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([a-zA-Z0-9_]+)[.]scala[.]([a-z]+)"));
            tuple2 = new Tuple2((Object)f, (Object)f.getName());
            if (tuple2 != null) {
                File f2;
                File file = f2 = (File)tuple2._1();
                File file2 = sourceDirectory;
                if (!(file != null ? !((Object)file).equals(file2) : file2 != null)) {
                    if (setExt) {
                        String[] parts = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(suffix), '.');
                        return new StringBuilder(1).append((String)Option$.MODULE$.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.dropRight$extension(Predef$.MODULE$.refArrayOps((Object[])parts), 1)).mkString(".")).filterNot((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.isEmpty())).map((Function1 & Serializable)x$11 -> new StringBuilder(1).append((String)x$11).append(".").toString()).getOrElse((Function0 & Serializable)() -> "")).append(ext).append(".").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.takeRight$extension(Predef$.MODULE$.refArrayOps((Object[])parts), 1)).mkString()).toString();
                    }
                    return suffix;
                }
            }
            if (tuple2 != null) {
                String name;
                File f3 = (File)tuple2._1();
                String string = name = (String)tuple2._2();
                String string2 = topDirectory;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    setExt = false;
                    suffix = new StringBuilder(2).append(name).append(".").append(ext).append(".").append(suffix).toString();
                    f = f3.getParentFile();
                    continue;
                }
            }
            if (tuple2 != null) {
                Option option;
                File f4 = (File)tuple2._1();
                String string = (String)tuple2._2();
                if (string != null && !(option = Name.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
                    String name = (String)((LinearSeqOps)option.get()).apply(0);
                    if (f4.isFile()) {
                        suffix = name;
                        f = f4.getParentFile();
                        continue;
                    }
                }
            }
            if (tuple2 == null) break;
            File f5 = (File)tuple2._1();
            String name = (String)tuple2._2();
            if (f5.isFile()) break;
            suffix = new StringBuilder(1).append(name).append(".").append(suffix).toString();
            f = f5.getParentFile();
        }
        if (tuple2 != null) {
            File f6 = (File)tuple2._1();
            String name = (String)tuple2._2();
            throw new TemplateCompilationError(f6, new StringBuilder(108).append("Invalid template name [").append(name).append("], filenames must only consist of alphanumeric characters and underscores or periods.").toString(), 0, 0);
        }
        throw new MatchError((Object)tuple2);
    }

    public String source2TemplateName$default$4() {
        return "";
    }

    public String source2TemplateName$default$5() {
        return "views";
    }

    public boolean source2TemplateName$default$6() {
        return true;
    }

    public Seq<Object> displayVisitedChildren(Seq<Object> children) {
        int n = children.size();
        switch (n) {
            case 0: {
                return Nil$.MODULE$;
            }
            case 1: {
                return (Seq)((SeqOps)((SeqOps)Nil$.MODULE$.$colon$plus((Object)"_display_(")).$colon$plus(children)).$colon$plus((Object)")");
            }
        }
        return (Seq)((SeqOps)((SeqOps)Nil$.MODULE$.$colon$plus((Object)"_display_(Seq[Any](")).$colon$plus(children)).$colon$plus((Object)"))");
    }

    private String tripleQuote() {
        return tripleQuote;
    }

    private String escapedTripleQuote() {
        return escapedTripleQuote;
    }

    private String doubleEscapedTripleQuote() {
        return doubleEscapedTripleQuote;
    }

    private String tripleQuoteReplacement() {
        return tripleQuoteReplacement;
    }

    private Seq<String> quoteAndEscape(String text) {
        return new .colon.colon((Object)this.tripleQuote(), (List)new .colon.colon((Object)text.replaceAll(this.tripleQuote(), this.tripleQuoteReplacement()), (List)new .colon.colon((Object)this.tripleQuote(), (List)Nil$.MODULE$)));
    }

    public Seq<Object> visit(Seq<TreeNodes.TemplateTree> elem, Seq<Object> previous) {
        List list;
        while ((list = elem.toList()) instanceof .colon.colon) {
            Seq seq;
            .colon.colon colon2 = (.colon.colon)list;
            TreeNodes.TemplateTree head = (TreeNodes.TemplateTree)colon2.head();
            List tail = colon2.next$access$1();
            TreeNodes.TemplateTree templateTree = head;
            if (templateTree instanceof TreeNodes.Plain) {
                TreeNodes.Plain plain = (TreeNodes.Plain)templateTree;
                String text = plain.text();
                List<String> grouped = StringGrouper$.MODULE$.apply(text, 20000);
                seq = (Seq)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)(previous.isEmpty() ? Nil$.MODULE$ : previous.$colon$plus((Object)","))).$colon$plus((Object)"format.raw")).$colon$plus((Object)new Source("(", plain.pos()))).$colon$plus(this.quoteAndEscape((String)grouped.head()))).$colon$plus((Object)")")).$colon$plus((Object)((List)grouped.tail()).flatMap((Function1 & Serializable)t -> new .colon.colon((Object)",\nformat.raw(", (List)new .colon.colon(MODULE$.quoteAndEscape((String)t), (List)new .colon.colon((Object)")", (List)Nil$.MODULE$)))));
            } else if (templateTree instanceof TreeNodes.Comment) {
                seq = previous;
            } else if (templateTree instanceof TreeNodes.Display) {
                TreeNodes.Display display = (TreeNodes.Display)templateTree;
                TreeNodes.ScalaExp exp = display.exp();
                seq = (Seq)((SeqOps)(previous.isEmpty() ? Nil$.MODULE$ : previous.$colon$plus((Object)","))).$colon$plus(this.displayVisitedChildren(this.visit((Seq<TreeNodes.TemplateTree>)new .colon.colon((Object)exp, (List)Nil$.MODULE$), (Seq<Object>)Nil$.MODULE$)));
            } else if (templateTree instanceof TreeNodes.ScalaExp) {
                TreeNodes.ScalaExp scalaExp = (TreeNodes.ScalaExp)templateTree;
                Seq parts = scalaExp.parts();
                seq = (Seq)previous.$colon$plus(parts.map((Function1 & Serializable)x0$1 -> {
                    boolean bl = false;
                    TreeNodes.Block block = null;
                    TreeNodes.ScalaExpPart scalaExpPart = x0$1;
                    if (scalaExpPart instanceof TreeNodes.Simple) {
                        TreeNodes.Simple simple = (TreeNodes.Simple)scalaExpPart;
                        String code = simple.code();
                        return new Source(code, simple.pos());
                    }
                    if (scalaExpPart instanceof TreeNodes.Block) {
                        bl = true;
                        block = (TreeNodes.Block)scalaExpPart;
                        String whitespace = block.whitespace();
                        Option args = block.args();
                        Seq content = block.content();
                        if (content.forall((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TwirlCompiler$.$anonfun$visit$3(x$12)))) {
                            return ((SeqOps)((SeqOps)Nil$.MODULE$.$colon$plus((Object)new Source(new StringBuilder(1).append(whitespace).append("{").append(args.getOrElse((Function0 & Serializable)() -> "")).toString(), block.pos()))).$colon$plus(MODULE$.visit((Seq<TreeNodes.TemplateTree>)content, (Seq<Object>)Nil$.MODULE$))).$colon$plus((Object)"}");
                        }
                    }
                    if (bl) {
                        String whitespace = block.whitespace();
                        Option args = block.args();
                        Seq content = block.content();
                        return ((SeqOps)((SeqOps)Nil$.MODULE$.$colon$plus((Object)new Source(new StringBuilder(1).append(whitespace).append("{").append(args.getOrElse((Function0 & Serializable)() -> "")).toString(), block.pos()))).$colon$plus(MODULE$.displayVisitedChildren(MODULE$.visit((Seq<TreeNodes.TemplateTree>)content, (Seq<Object>)Nil$.MODULE$)))).$colon$plus((Object)"}");
                    }
                    throw new MatchError((Object)scalaExpPart);
                }));
            } else {
                throw new MatchError((Object)templateTree);
            }
            previous = seq;
            elem = tail;
        }
        if (Nil$.MODULE$.equals(list)) {
            return previous;
        }
        throw new MatchError((Object)list);
    }

    public Seq<Object> templateCode(TreeNodes.Template template, String resultType) {
        Seq defs = (Seq)((IterableOps)template.sub().$plus$plus((IterableOnce)template.defs())).map((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            TreeNodes.Template template = null;
            Product product = x0$1;
            if (product instanceof TreeNodes.Template) {
                bl = true;
                template = (TreeNodes.Template)product;
                String string = template.name().toString();
                String string2 = "";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return MODULE$.templateCode(template, resultType);
                }
            }
            if (bl) {
                return (Seq)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)Nil$.MODULE$.$colon$plus((Object)(template.name().str().startsWith("implicit") ? "implicit def " : "def "))).$colon$plus((Object)new Source(template.name().str(), template.name().pos()))).$colon$plus((Object)new Source(template.params().str(), template.params().pos()))).$colon$plus((Object)":")).$colon$plus((Object)resultType)).$colon$plus((Object)" = {_display_(")).$colon$plus(MODULE$.templateCode(template, resultType))).$colon$plus((Object)")};");
            }
            if (product instanceof TreeNodes.Def) {
                TreeNodes.Def def = (TreeNodes.Def)product;
                TreeNodes.PosString name = def.name();
                TreeNodes.PosString params = def.params();
                Option resultType = def.resultType();
                TreeNodes.Simple block = def.code();
                return (Seq)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)Nil$.MODULE$.$colon$plus((Object)(name.str().startsWith("implicit") ? "implicit def " : "def "))).$colon$plus((Object)new Source(name.str(), name.pos()))).$colon$plus((Object)new Source(params.str(), params.pos()))).$colon$plus(resultType.map((Function1 & Serializable)x$13 -> new StringBuilder(1).append(":").append(x$13.str()).toString()).getOrElse((Function0 & Serializable)() -> ""))).$colon$plus((Object)" = {")).$colon$plus((Object)block.code())).$colon$plus((Object)"};");
            }
            throw new MatchError((Object)product);
        });
        Seq<Object> imports = this.formatImports((Seq<TreeNodes.Simple>)template.imports());
        return (Seq)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)Nil$.MODULE$.$colon$plus(imports)).$colon$plus((Object)"\n")).$colon$plus((Object)defs)).$colon$plus((Object)"\n")).$colon$plus((Object)"Seq[Any](")).$colon$plus(this.visit((Seq<TreeNodes.TemplateTree>)template.content(), (Seq<Object>)Nil$.MODULE$))).$colon$plus((Object)")");
    }

    public Seq<Object> generateCode(String packageName, String name, TreeNodes.Template root, String resultType, String formatterType, Seq<String> additionalImports, Seq<String> constructorAnnotations) {
        return this.generateCode(packageName, name, root, resultType, formatterType, TwirlCompiler$ScalaCompat$.MODULE$.apply((Option<String>)None$.MODULE$), additionalImports, constructorAnnotations);
    }

    private Seq<Object> generateCode(String packageName, String name, TreeNodes.Template root, String resultType, String formatterType, TwirlCompiler.ScalaCompat scalaCompat, Seq<String> additionalImports, Seq<String> constructorAnnotations) {
        Tuple3<String, String, String> tuple3 = TwirlCompiler$TemplateAsFunctionCompiler$.MODULE$.getFunctionMapping(root.params().str(), resultType, scalaCompat);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String renderCall = (String)tuple3._1();
        String f = (String)tuple3._2();
        String templateType = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)renderCall, (Object)f, (Object)templateType);
        String renderCall2 = (String)tuple32._1();
        String f2 = (String)tuple32._2();
        String templateType2 = (String)tuple32._3();
        .colon.colon imports = new .colon.colon((Object)((Seq)additionalImports.map((Function1 & Serializable)i -> new .colon.colon((Object)"import ", (List)new .colon.colon(i, (List)new .colon.colon((Object)"\n", (List)Nil$.MODULE$))))), (List)new .colon.colon(this.formatImports((Seq<TreeNodes.Simple>)root.topImports()), (List)Nil$.MODULE$));
        scala.collection.immutable.Seq classDeclaration = (scala.collection.immutable.Seq)root.constructor().fold((Function0 & Serializable)() -> new .colon.colon((Object)"object ", (List)new .colon.colon((Object)name, (List)Nil$.MODULE$)), (Function1 & Serializable)constructor -> (Vector)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)package$.MODULE$.Vector().empty().$colon$plus((Object)"/*")).$colon$plus(constructor.comment().fold((Function0 & Serializable)() -> "", (Function1 & Serializable)x$15 -> x$15.msg()))).$colon$plus((Object)"*/\nclass ")).$colon$plus((Object)name)).$colon$plus((Object)" ")).$colon$plus((Object)constructorAnnotations)).$colon$plus((Object)" ")).$colon$plus((Object)new Source(constructor.params().str(), constructor.params().pos())));
        Vector generated = (Vector)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)package$.MODULE$.Vector().empty().$colon$plus((Object)"\npackage ")).$colon$plus((Object)packageName)).$colon$plus((Object)"\n\n")).$colon$plus((Object)imports)).$colon$plus((Object)"\n")).$colon$plus((Object)classDeclaration)).$colon$plus((Object)" extends _root_.play.twirl.api.BaseScalaTemplate[")).$colon$plus((Object)resultType)).$colon$plus((Object)",_root_.play.twirl.api.Format[")).$colon$plus((Object)resultType)).$colon$plus((Object)"]](")).$colon$plus((Object)formatterType)).$colon$plus((Object)")")).$colon$plus((Object)(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(templateType2)) ? new StringBuilder(6).append(" with ").append(templateType2).toString() : ""))).$colon$plus((Object)" {\n\n  /*")).$colon$plus(root.comment().map((Function1 & Serializable)x$16 -> x$16.msg()).getOrElse((Function0 & Serializable)() -> ""))).$colon$plus((Object)"*/\n  def apply")).$colon$plus((Object)new Source(root.params().str(), root.params().pos()))).$colon$plus((Object)":")).$colon$plus((Object)resultType)).$colon$plus((Object)" = {\n    _display_ {\n      {\n")).$colon$plus(this.templateCode(root, resultType))).$colon$plus((Object)"\n      }\n    }\n  }\n\n  ")).$colon$plus((Object)renderCall2)).$colon$plus((Object)"\n\n  ")).$colon$plus((Object)f2)).$colon$plus((Object)"\n\n  def ref: this.type = this\n\n}\n\n");
        return generated;
    }

    public Seq<Object> formatImports(Seq<TreeNodes.Simple> imports) {
        return (Seq)imports.map((Function1 & Serializable)i -> new .colon.colon((Object)new Source(i.code(), i.pos()), (List)new .colon.colon((Object)"\n", (List)Nil$.MODULE$)));
    }

    public scala.collection.immutable.Seq<String> formatImports(scala.collection.immutable.Seq<String> templateImports, String extension) {
        return (scala.collection.immutable.Seq)templateImports.map((Function1 & Serializable)x$17 -> x$17.replace("%format%", extension));
    }

    public String generateFinalTemplate(String relativePath, byte[] contents, String packageName, String name, TreeNodes.Template root, String resultType, String formatterType, Seq<String> additionalImports, Seq<String> constructorAnnotations) {
        return this.generateFinalTemplate(relativePath, contents, packageName, name, root, resultType, formatterType, TwirlCompiler$ScalaCompat$.MODULE$.apply((Option<String>)None$.MODULE$), additionalImports, constructorAnnotations);
    }

    private String generateFinalTemplate(String relativePath, byte[] contents, String packageName, String name, TreeNodes.Template root, String resultType, String formatterType, TwirlCompiler.ScalaCompat scalaCompat, Seq<String> additionalImports, Seq<String> constructorAnnotations) {
        Seq<Object> generated = this.generateCode(packageName, name, root, resultType, formatterType, scalaCompat, additionalImports, constructorAnnotations);
        return Source$.MODULE$.finalSource(relativePath, contents, generated, Hash$.MODULE$.apply(contents, additionalImports));
    }

    public static final /* synthetic */ boolean $anonfun$visit$3(TreeNodes.TemplateTree x$12) {
        return x$12 instanceof TreeNodes.ScalaExp;
    }

    private TwirlCompiler$() {
    }
}

