/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven.report;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.FileUtils;
import org.pitest.aggregate.AggregationResult;
import org.pitest.aggregate.ReportAggregator;
import org.pitest.functional.FCollection;
import org.pitest.maven.DependencyFilter;
import org.pitest.maven.report.PitReportMojo;
import org.pitest.maven.report.ReportSourceLocator;
import org.pitest.mutationtest.config.DirectoryResultOutputStrategy;
import org.pitest.mutationtest.config.PluginServices;
import org.pitest.mutationtest.config.ReportDirCreationStrategy;
import org.pitest.mutationtest.config.UndatedReportDirCreationStrategy;
import org.pitest.util.ResultOutputStrategy;

abstract class AbstractPitAggregationReportMojo
extends PitReportMojo {
    private static final String REPORT_DIR_RELATIVE_TO_PROJECT = "target/pit-reports";
    private static final String MUTATION_RESULT_FILTER = "mutations.xml";
    private static final String LINECOVERAGE_FILTER = "linecoverage.xml";
    @Parameter(property="reactorProjects", readonly=true)
    List<MavenProject> reactorProjects;
    @Parameter(defaultValue="0", property="aggregatedMutationThreshold")
    private int aggregatedMutationThreshold;
    @Parameter(defaultValue="0", property="aggregatedTestStrengthThreshold")
    private int aggregatedTestStrengthThreshold;
    @Parameter(defaultValue="-1", property="aggregatedMaxSurviving")
    private int aggregatedMaxSurviving = -1;
    private final ReportSourceLocator reportSourceLocator = new ReportSourceLocator();

    AbstractPitAggregationReportMojo() {
    }

    abstract Collection<MavenProject> findDependencies();

    @Override
    protected void executeReport(Locale locale) throws MavenReportException {
        if (!this.canGenerateReport()) {
            this.getLog().info((CharSequence)"Skipping");
            return;
        }
        try {
            Collection<MavenProject> allProjects = this.findDependencies();
            ReportAggregator.Builder reportAggregationBuilder = ReportAggregator.builder();
            for (MavenProject proj : allProjects) {
                this.addProjectFiles(reportAggregationBuilder, proj);
            }
            ReportAggregator reportAggregator = reportAggregationBuilder.inputCharSet(Charset.forName(this.getInputEncoding())).outputCharset(Charset.forName(this.getOutputEncoding())).resultOutputStrategy((ResultOutputStrategy)new DirectoryResultOutputStrategy(this.getReportsDirectory().getAbsolutePath(), (ReportDirCreationStrategy)new UndatedReportDirCreationStrategy())).build();
            AggregationResult result = reportAggregator.aggregateReport();
            this.throwErrorIfTestStrengthBelowThreshold(result.getTestStrength());
            this.throwErrorIfScoreBelowThreshold(result.getMutationCoverage());
            this.throwErrorIfMoreThanMaximumSurvivors(result.getMutationsSurvived());
        }
        catch (Exception e) {
            throw new MavenReportException(e.getMessage(), e);
        }
    }

    private void addProjectFiles(ReportAggregator.Builder reportAggregationBuilder, MavenProject proj) throws Exception {
        File projectBaseDir = proj.getBasedir();
        for (File file : this.getProjectFilesByFilter(projectBaseDir, MUTATION_RESULT_FILTER)) {
            reportAggregationBuilder.addMutationResultsFile(file);
        }
        for (File file : this.getProjectFilesByFilter(projectBaseDir, LINECOVERAGE_FILTER)) {
            reportAggregationBuilder.addLineCoverageFile(file);
        }
        for (File file : this.convertToRootDirs(proj.getCompileSourceRoots(), proj.getTestCompileSourceRoots())) {
            reportAggregationBuilder.addSourceCodeDirectory(file);
        }
        reportAggregationBuilder.addSourceCodeDirectory(proj.getBasedir().toPath().resolve("src").resolve("main").resolve("kotlin").toFile());
        for (File file : this.getCompiledDirs(proj)) {
            reportAggregationBuilder.addCompiledCodeDirectory(file);
        }
    }

    private List<File> convertToRootDirs(List ... directoryLists) {
        ArrayList roots = new ArrayList();
        for (List directoryList : directoryLists) {
            roots.addAll(directoryList);
        }
        return FCollection.map(roots, File::new);
    }

    private List<File> getProjectFilesByFilter(File projectBaseDir, String filter) throws IOException {
        File reportsDir = projectBaseDir.toPath().resolve(REPORT_DIR_RELATIVE_TO_PROJECT).toFile();
        if (!reportsDir.exists()) {
            return new ArrayList<File>();
        }
        File latestReportDir = this.reportSourceLocator.locate(reportsDir, this.getLog());
        List files = FileUtils.getFiles((File)latestReportDir, (String)filter, (String)"");
        return files == null ? new ArrayList() : files;
    }

    private List<File> getCompiledDirs(MavenProject project) throws Exception {
        ArrayList<String> sourceRoots = new ArrayList<String>();
        for (Object artifactObj : FCollection.filter(project.getPluginArtifactMap().values(), (Predicate)new DependencyFilter(PluginServices.makeForLoader((ClassLoader)((Object)((Object)this)).getClass().getClassLoader())))) {
            Artifact artifact = (Artifact)artifactObj;
            sourceRoots.add(artifact.getFile().getAbsolutePath());
        }
        return this.convertToRootDirs(project.getTestCompileSourceRoots(), Arrays.asList(project.getBuild().getOutputDirectory(), project.getBuild().getTestOutputDirectory()), sourceRoots);
    }

    private void throwErrorIfScoreBelowThreshold(int mutationCoverage) throws MojoFailureException {
        if (this.aggregatedMutationThreshold != 0 && mutationCoverage < this.aggregatedMutationThreshold) {
            throw new MojoFailureException("Mutation score of " + mutationCoverage + " is below threshold of " + this.aggregatedMutationThreshold);
        }
    }

    private void throwErrorIfTestStrengthBelowThreshold(int testStrength) throws MojoFailureException {
        if (this.aggregatedTestStrengthThreshold != 0 && testStrength < this.aggregatedTestStrengthThreshold) {
            throw new MojoFailureException("Test strength score of " + testStrength + " is below threshold of " + this.aggregatedTestStrengthThreshold);
        }
    }

    private void throwErrorIfMoreThanMaximumSurvivors(long mutationsSurvived) throws MojoFailureException {
        if (this.aggregatedMaxSurviving >= 0 && mutationsSurvived > (long)this.aggregatedMaxSurviving) {
            throw new MojoFailureException("Had " + mutationsSurvived + " surviving mutants, but only " + this.aggregatedMaxSurviving + " survivors allowed");
        }
    }
}

