/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.DirectoryClassPathRoot;
import org.pitest.functional.FCollection;
import org.pitest.functional.Streams;
import org.pitest.maven.AbstractPitMojo;
import org.pitest.maven.SurefireConfigConverter;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.util.Glob;
import org.pitest.util.Verbosity;

public class MojoToReportOptionsConverter {
    private final AbstractPitMojo mojo;
    private final Predicate<org.apache.maven.artifact.Artifact> dependencyFilter;
    private final Log log;
    private final SurefireConfigConverter surefireConverter;

    public MojoToReportOptionsConverter(AbstractPitMojo mojo, SurefireConfigConverter surefireConverter, Predicate<org.apache.maven.artifact.Artifact> dependencyFilter) {
        this.mojo = mojo;
        this.dependencyFilter = dependencyFilter;
        this.log = mojo.getLog();
        this.surefireConverter = surefireConverter;
    }

    public ReportOptions convert() {
        ReportOptions effective;
        ArrayList<String> classPath = new ArrayList<String>();
        try {
            classPath.addAll(this.mojo.getProject().getTestClasspathElements());
        }
        catch (DependencyResolutionRequiredException e1) {
            this.log.info((Throwable)e1);
        }
        this.addOwnDependenciesToClassPath(classPath);
        classPath.addAll(this.mojo.getAdditionalClasspathElements());
        this.autoAddJUnitPlatform(classPath);
        this.removeExcludedDependencies(classPath);
        ReportOptions option = this.parseReportOptions(classPath);
        ReportOptions withSureFire = this.updateFromSurefire(option);
        ReportOptions reportOptions = effective = withSureFire != null ? withSureFire : option;
        if (effective.getArgLine() != null) {
            this.log.info((CharSequence)("Replacing properties in argLine " + effective.getArgLine()));
            effective.setArgLine(this.replacePropertyExpressions(effective.getArgLine()));
        }
        return effective;
    }

    private void autoAddJUnitPlatform(List<String> classPath) {
        List<org.apache.maven.artifact.Artifact> junitDependencies = this.mojo.getProject().getArtifacts().stream().filter(a -> a.getGroupId().equals("org.junit.platform")).collect(Collectors.toList());
        if (junitDependencies.stream().anyMatch(a -> a.getArtifactId().equals("junit-platform-launcher"))) {
            return;
        }
        Optional<org.apache.maven.artifact.Artifact> maybeJUnitPlatform = MojoToReportOptionsConverter.findJUnitArtifact(junitDependencies);
        if (!maybeJUnitPlatform.isPresent()) {
            this.log.debug((CharSequence)"JUnit 5 not on classpath");
            return;
        }
        org.apache.maven.artifact.Artifact toMatch = maybeJUnitPlatform.get();
        DefaultArtifact platformLauncher = new DefaultArtifact(toMatch.getGroupId(), "junit-platform-launcher", "jar", toMatch.getVersion());
        try {
            ArtifactRequest r = new ArtifactRequest();
            r.setArtifact((Artifact)platformLauncher);
            r.setRepositories(this.mojo.getProject().getRemotePluginRepositories());
            ArtifactResult resolved = this.mojo.repositorySystem().resolveArtifact(this.mojo.session().getRepositorySession(), r);
            this.log.info((CharSequence)("Auto adding " + resolved + " to classpath."));
            classPath.add(resolved.getArtifact().getFile().getAbsolutePath());
        }
        catch (ArtifactResolutionException e) {
            this.log.error((CharSequence)("Could not resolve " + platformLauncher));
            throw new RuntimeException(e);
        }
    }

    private static Optional<org.apache.maven.artifact.Artifact> findJUnitArtifact(List<org.apache.maven.artifact.Artifact> junitDependencies) {
        Optional<org.apache.maven.artifact.Artifact> maybeEngine = junitDependencies.stream().filter(a -> a.getArtifactId().equals("junit-platform-engine")).findAny();
        if (maybeEngine.isPresent()) {
            return maybeEngine;
        }
        return junitDependencies.stream().filter(a -> a.getArtifactId().equals("junit-platform-commons")).findAny();
    }

    private void removeExcludedDependencies(List<String> classPath) {
        for (Object artifact : this.mojo.getProject().getArtifacts()) {
            org.apache.maven.artifact.Artifact dependency = (org.apache.maven.artifact.Artifact)artifact;
            if (!this.mojo.getClasspathDependencyExcludes().contains(dependency.getGroupId() + ":" + dependency.getArtifactId())) continue;
            classPath.remove(dependency.getFile().getPath());
        }
    }

    private ReportOptions parseReportOptions(List<String> classPath) {
        ReportOptions data = new ReportOptions();
        if (this.mojo.getProject().getBuild() != null) {
            this.log.info((CharSequence)("Mutating from " + this.mojo.getProject().getBuild().getOutputDirectory()));
            data.setCodePaths(Collections.singleton(this.mojo.getProject().getBuild().getOutputDirectory()));
        }
        data.setUseClasspathJar(this.mojo.isUseClasspathJar());
        data.setClassPathElements(classPath);
        data.setFailWhenNoMutations(this.shouldFailWhenNoMutations());
        data.setTargetClasses(this.determineTargetClasses());
        data.setTargetTests(this.determineTargetTests());
        data.setExcludedMethods(this.mojo.getExcludedMethods());
        data.setExcludedClasses(this.mojo.getExcludedClasses());
        data.setExcludedTestClasses(this.globStringsToPredicates(this.mojo.getExcludedTestClasses()));
        data.setNumberOfThreads(this.mojo.getThreads());
        data.setExcludedRunners(this.mojo.getExcludedRunners());
        data.setReportDir(this.mojo.getReportsDirectory().getAbsolutePath());
        this.configureVerbosity(data);
        if (this.mojo.getJvmArgs() != null) {
            data.addChildJVMArgs(this.mojo.getJvmArgs());
        }
        if (this.mojo.getArgLine() != null) {
            data.setArgLine(this.mojo.getArgLine());
        }
        data.setMutators(this.determineMutators());
        data.setFeatures(this.determineFeatures());
        data.setTimeoutConstant(this.mojo.getTimeoutConstant());
        data.setTimeoutFactor(this.mojo.getTimeoutFactor());
        if (this.hasValue(this.mojo.getAvoidCallsTo())) {
            data.setLoggingClasses(this.mojo.getAvoidCallsTo());
        }
        ArrayList<String> sourceRoots = new ArrayList<String>();
        sourceRoots.addAll(this.mojo.getProject().getCompileSourceRoots());
        sourceRoots.addAll(this.mojo.getProject().getTestCompileSourceRoots());
        data.setSourceDirs(this.stringsToPaths(sourceRoots));
        data.addOutputFormats(this.determineOutputFormats());
        this.setTestGroups(data);
        data.setFullMutationMatrix(this.mojo.isFullMutationMatrix());
        data.setMutationUnitSize(this.mojo.getMutationUnitSize());
        data.setShouldCreateTimestampedReports(this.mojo.isTimestampedReports());
        data.setDetectInlinedCode(this.mojo.isDetectInlinedCode());
        this.determineHistory(data);
        data.setExportLineCoverage(this.mojo.isExportLineCoverage());
        data.setMutationEngine(this.mojo.getMutationEngine());
        data.setJavaExecutable(this.mojo.getJavaExecutable());
        data.setFreeFormProperties(this.createPluginProperties());
        data.setIncludedTestMethods(this.mojo.getIncludedTestMethods());
        data.setSkipFailingTests(this.mojo.skipFailingTests());
        data.setInputEncoding(this.mojo.getSourceEncoding());
        data.setOutputEncoding(this.mojo.getOutputEncoding());
        if (this.mojo.getProjectBase() != null) {
            data.setProjectBase(FileSystems.getDefault().getPath(this.mojo.getProjectBase(), new String[0]));
        }
        this.checkForObsoleteOptions(this.mojo);
        return data;
    }

    private void configureVerbosity(ReportOptions data) {
        if (this.mojo.isVerbose()) {
            data.setVerbosity(Verbosity.VERBOSE);
        } else {
            Verbosity v = Verbosity.fromString((String)this.mojo.getVerbosity());
            data.setVerbosity(v);
        }
    }

    private void checkForObsoleteOptions(AbstractPitMojo mojo) {
        if (mojo.getMaxMutationsPerClass() > 0) {
            throw new IllegalArgumentException("The max mutations per class argument is no longer supported, use features=+CLASSLIMIT(limit[" + mojo.getMaxMutationsPerClass() + "]) instead");
        }
    }

    private void determineHistory(ReportOptions data) {
        data.setHistoryInputLocation(this.mojo.getHistoryInputFile());
        data.setHistoryOutputLocation(this.mojo.getHistoryOutputFile());
        if (this.mojo.useHistory()) {
            this.useHistoryFileInTempDir(data);
        }
        if (data.getHistoryInputLocation() != null) {
            this.log.info((CharSequence)("Will read history at " + data.getHistoryInputLocation()));
        }
        if (data.getHistoryOutputLocation() != null) {
            this.log.info((CharSequence)("Will write history at " + data.getHistoryOutputLocation()));
        }
    }

    private void useHistoryFileInTempDir(ReportOptions data) {
        String tempDir = System.getProperty("java.io.tmpdir");
        MavenProject project = this.mojo.getProject();
        String name = project.getGroupId() + "." + project.getArtifactId() + "." + project.getVersion() + "_pitest_history.bin";
        File historyFile = new File(tempDir, name);
        if (this.mojo.getHistoryInputFile() != null || this.mojo.getHistoryOutputFile() != null) {
            this.log.info((CharSequence)"Using withHistory option. This overrides the explicitly set history file paths.");
        }
        data.setHistoryInputLocation(historyFile);
        data.setHistoryOutputLocation(historyFile);
    }

    private ReportOptions updateFromSurefire(ReportOptions option) {
        Collection<Plugin> plugins = this.lookupPlugin("org.apache.maven.plugins:maven-surefire-plugin");
        if (!this.mojo.isParseSurefireConfig()) {
            return option;
        }
        if (plugins.isEmpty()) {
            this.log.warn((CharSequence)"Could not find surefire configuration in pom");
            return option;
        }
        Plugin surefire = plugins.iterator().next();
        if (surefire != null) {
            return this.surefireConverter.update(option, (Xpp3Dom)surefire.getConfiguration());
        }
        return option;
    }

    private Collection<Plugin> lookupPlugin(String key) {
        List plugins = this.mojo.getProject().getBuildPlugins();
        return FCollection.filter((Iterable)plugins, MojoToReportOptionsConverter.hasKey(key));
    }

    private static Predicate<Plugin> hasKey(String key) {
        return a -> a.getKey().equals(key);
    }

    private boolean shouldFailWhenNoMutations() {
        return this.mojo.isFailWhenNoMutations();
    }

    private void setTestGroups(ReportOptions data) {
        TestGroupConfig conf = new TestGroupConfig(this.mojo.getExcludedGroups(), this.mojo.getIncludedGroups());
        data.setGroupConfig(conf);
    }

    private void addOwnDependenciesToClassPath(List<String> classPath) {
        for (org.apache.maven.artifact.Artifact dependency2 : this.filteredDependencies()) {
            this.log.info((CharSequence)("Adding " + dependency2.getGroupId() + ":" + dependency2.getArtifactId() + " to SUT classpath"));
            classPath.add(dependency2.getFile().getAbsolutePath());
        }
        this.mojo.getPluginArtifactMap().values().stream().filter(a -> a.getGroupId().equals("org.junit.platform")).forEach(dependency -> classPath.add(dependency.getFile().getAbsolutePath()));
    }

    private Collection<Predicate<String>> globStringsToPredicates(List<String> excludedMethods) {
        return Streams.asStream(excludedMethods).map(Glob.toGlobPredicate()).collect(Collectors.toList());
    }

    private Collection<Predicate<String>> determineTargetTests() {
        return this.useConfiguredTargetTestsOrFindOccupiedPackages(this.mojo.getTargetTests()).stream().map(Glob.toGlobPredicate()).collect(Collectors.toList());
    }

    private Collection<String> useConfiguredTargetTestsOrFindOccupiedPackages(Collection<String> filters) {
        if (!this.hasValue(filters)) {
            this.mojo.getLog().info((CharSequence)"Defaulting target tests to match packages in test build directory");
            return this.findOccupiedTestPackages();
        }
        return filters;
    }

    private Collection<String> findOccupiedTestPackages() {
        String outputDirName = this.mojo.getProject().getBuild().getTestOutputDirectory();
        if (outputDirName != null) {
            File outputDir = new File(outputDirName);
            return MojoToReportOptionsConverter.findOccupiedPackagesIn(outputDir);
        }
        return Collections.emptyList();
    }

    private Collection<org.apache.maven.artifact.Artifact> filteredDependencies() {
        return FCollection.filter(this.mojo.getPluginArtifactMap().values(), this.dependencyFilter);
    }

    private Collection<String> determineMutators() {
        if (this.mojo.getMutators() != null) {
            return this.mojo.getMutators();
        }
        return Collections.emptyList();
    }

    private Collection<String> determineFeatures() {
        if (this.mojo.getFeatures() != null) {
            return this.mojo.getFeatures();
        }
        return Collections.emptyList();
    }

    private Collection<String> determineTargetClasses() {
        return this.useConfiguredTargetClassesOrFindOccupiedPackages(this.mojo.getTargetClasses());
    }

    private Collection<String> useConfiguredTargetClassesOrFindOccupiedPackages(Collection<String> filters) {
        if (!this.hasValue(filters)) {
            this.mojo.getLog().info((CharSequence)"Defaulting target classes to match packages in build directory");
            return this.findOccupiedPackages();
        }
        return filters;
    }

    private Collection<String> findOccupiedPackages() {
        String outputDirName = this.mojo.getProject().getBuild().getOutputDirectory();
        File outputDir = new File(outputDirName);
        return MojoToReportOptionsConverter.findOccupiedPackagesIn(outputDir);
    }

    public static Collection<String> findOccupiedPackagesIn(File dir) {
        if (dir.exists()) {
            DirectoryClassPathRoot root = new DirectoryClassPathRoot(dir);
            HashSet<String> occupiedPackages = new HashSet<String>();
            FCollection.mapTo((Iterable)root.classNames(), MojoToReportOptionsConverter.classToPackageGlob(), occupiedPackages);
            return occupiedPackages;
        }
        return Collections.emptyList();
    }

    private static Function<String, String> classToPackageGlob() {
        return a -> ClassName.fromString((String)a).getPackage().asJavaName() + ".*";
    }

    private Collection<Path> stringsToPaths(List<String> sourceRoots) {
        return sourceRoots.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
    }

    private Collection<String> determineOutputFormats() {
        if (this.hasValue(this.mojo.getOutputFormats())) {
            return this.mojo.getOutputFormats();
        }
        return Arrays.asList("HTML");
    }

    private boolean hasValue(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    private Properties createPluginProperties() {
        Properties p = new Properties();
        if (this.mojo.getPluginProperties() != null) {
            p.putAll(this.mojo.getPluginProperties());
        }
        return p;
    }

    private String replacePropertyExpressions(String argLine) {
        Enumeration<?> e = this.mojo.getProject().getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            argLine = this.replaceFieldForSymbol('@', key, argLine);
            argLine = this.replaceFieldForSymbol('$', key, argLine);
        }
        return argLine;
    }

    private String replaceFieldForSymbol(char symbol, String key, String argLine) {
        String field = symbol + "{" + key + "}";
        if (argLine.contains(field)) {
            return argLine.replace(field, this.mojo.getProject().getProperties().getProperty(key, ""));
        }
        return argLine;
    }
}

