/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.util.Properties;
import java.util.stream.Collectors;
import org.pitest.classpath.CodeSource;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.coverage.TestInfo;
import org.pitest.mutationtest.build.TestFilter;
import org.pitest.mutationtest.build.TestPrioritiser;
import org.pitest.mutationtest.build.TestPrioritiserFactory;

public class FilteringPrioritiser
implements TestPrioritiserFactory {
    private final TestPrioritiserFactory delegate;
    private final TestFilter filter;

    public FilteringPrioritiser(TestPrioritiserFactory delegate, TestFilter filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public TestPrioritiser makeTestPrioritiser(Properties props, CodeSource code, CoverageDatabase coverage) {
        TestPrioritiser p = this.delegate.makeTestPrioritiser(props, code, coverage);
        return mutation -> p.assignTests(mutation).stream().filter(test -> this.filter.include((TestInfo)test, mutation)).collect(Collectors.toList());
    }

    public String description() {
        return "Internal prioritiser factory";
    }
}

