/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.sequence;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import org.pitest.sequence.Context;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotRead;
import org.pitest.sequence.SlotWrite;

final class MultiContext
implements Context {
    private final boolean debug;
    private final Map<Slot, Object> slots;

    MultiContext(Map<Slot, Object> slots, boolean debug) {
        this.slots = slots;
        this.debug = debug;
    }

    @Override
    public boolean debug() {
        return this.debug;
    }

    @Override
    public <S> Context store(SlotWrite<S> slot, S value) {
        IdentityHashMap<Slot, Object> mutatedSlots = new IdentityHashMap<Slot, Object>(this.slots);
        mutatedSlots.put(slot.slot(), value);
        return new MultiContext(mutatedSlots, this.debug);
    }

    @Override
    public <S> Optional<S> retrieve(SlotRead<S> slot) {
        return Optional.ofNullable(this.slots.get(slot.slot()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiContext)) {
            return false;
        }
        MultiContext context = (MultiContext)o;
        return this.slots.equals(context.slots);
    }

    public int hashCode() {
        return this.slots.hashCode();
    }
}

