/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.execute;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.MutationMetaData;
import org.pitest.mutationtest.MutationResultInterceptor;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.mutationtest.build.MutationAnalysisUnit;
import org.pitest.util.Log;
import org.pitest.util.Unchecked;

public class MutationAnalysisExecutor {
    private static final Logger LOG = Log.getLogger();
    private final List<MutationResultListener> listeners;
    private final ThreadPoolExecutor executor;
    private final MutationResultInterceptor resultInterceptor;

    public MutationAnalysisExecutor(int numberOfThreads, MutationResultInterceptor interceptor, List<MutationResultListener> listeners) {
        this.resultInterceptor = interceptor;
        this.listeners = listeners;
        this.executor = new ThreadPoolExecutor(numberOfThreads, numberOfThreads, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Executors.defaultThreadFactory());
    }

    public void run(List<MutationAnalysisUnit> testUnits) {
        LOG.fine("Running " + testUnits.size() + " units");
        this.signalRunStartToAllListeners();
        ArrayList<Future<MutationMetaData>> results = new ArrayList<Future<MutationMetaData>>(testUnits.size());
        for (MutationAnalysisUnit unit : testUnits) {
            results.add(this.executor.submit(unit));
        }
        this.executor.shutdown();
        try {
            this.processResult(results);
        }
        catch (InterruptedException | ExecutionException e) {
            throw Unchecked.translateCheckedException((Throwable)e);
        }
        this.signalRunEndToAllListeners();
    }

    private void processResult(List<Future<MutationMetaData>> results) throws InterruptedException, ExecutionException {
        for (Future<MutationMetaData> f : results) {
            MutationMetaData metaData = f.get();
            for (ClassMutationResults cr : this.resultInterceptor.modify(metaData.toClassResults())) {
                for (MutationResultListener listener : this.listeners) {
                    listener.handleMutationResult(cr);
                }
            }
        }
        for (ClassMutationResults each : this.resultInterceptor.remaining()) {
            for (MutationResultListener listener : this.listeners) {
                listener.handleMutationResult(each);
            }
        }
    }

    private void signalRunStartToAllListeners() {
        this.listeners.forEach(MutationResultListener::runStart);
    }

    private void signalRunEndToAllListeners() {
        this.listeners.forEach(MutationResultListener::runEnd);
    }
}

