/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.sequence;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.pitest.sequence.Consume;
import org.pitest.sequence.Context;
import org.pitest.sequence.EndMatch;
import org.pitest.sequence.Match;
import org.pitest.sequence.Result;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.Split;
import org.pitest.sequence.State;
import org.pitest.sequence.StateContext;

class NFASequenceMatcher<T>
implements SequenceMatcher<T> {
    private final boolean debug;
    private final Match<T> ignore;
    private final State<T> start;

    NFASequenceMatcher(Match<T> ignore, State<T> state, boolean debug) {
        this.ignore = ignore;
        this.start = state;
        this.debug = debug;
    }

    @Override
    public boolean matches(List<T> sequence) {
        return this.matches(sequence, Context.start(this.debug));
    }

    @Override
    public boolean matches(List<T> sequence, Context initialContext) {
        Set<StateContext<T>> currentState = this.run(sequence, initialContext);
        return currentState.stream().map(c -> c.state).anyMatch(s -> s != null && s == EndMatch.MATCH);
    }

    @Override
    public List<Context> contextMatches(List<T> sequence, Context initialContext) {
        Set<StateContext<T>> currentState = this.run(sequence, initialContext);
        return currentState.stream().filter(s -> s.state != null && s.state == EndMatch.MATCH).map(c -> c.context).collect(Collectors.toList());
    }

    private Set<StateContext<T>> run(List<T> sequence, Context initialContext) {
        Set<StateContext<T>> currentState = new HashSet<StateContext<T>>();
        NFASequenceMatcher.addState(currentState, new StateContext<T>(this.start, initialContext));
        for (T t : sequence) {
            if (this.ignore.test(initialContext, t).result()) continue;
            Set<StateContext<T>> nextStates = NFASequenceMatcher.step(currentState, t);
            currentState = nextStates;
        }
        return currentState;
    }

    private static <T> void addState(Set<StateContext<T>> set, StateContext<T> state) {
        if (state.state instanceof Split) {
            Split split = (Split)state.state;
            if (split.out1 != null) {
                NFASequenceMatcher.addState(set, new StateContext(split.out1, state.context));
            }
            if (split.out2 != null) {
                NFASequenceMatcher.addState(set, new StateContext(split.out2, state.context));
            }
        } else {
            set.add(state);
        }
    }

    private static <T> Set<StateContext<T>> step(Set<StateContext<T>> currentState, T c) {
        HashSet<StateContext<T>> nextStates = new HashSet<StateContext<T>>(currentState.size());
        for (StateContext<T> each : currentState) {
            if (!(each.state instanceof Consume)) continue;
            Consume consume = (Consume)each.state;
            Result result = consume.c.test(each.context, c);
            if (!result.result()) continue;
            NFASequenceMatcher.addState(nextStates, new StateContext(consume.out, result.context()));
        }
        return nextStates;
    }
}

