/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.process;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pitest.process.DefaultJavaExecutableLocator;
import org.pitest.process.JavaAgent;
import org.pitest.process.JavaExecutableLocator;

public class LaunchOptions {
    private final JavaAgent javaAgentFinder;
    private final List<String> childJVMArgs;
    private final JavaExecutableLocator javaExecutable;
    private final Map<String, String> environmentVariables;
    private final boolean usingClassPathJar;

    public LaunchOptions(JavaAgent javaAgentFinder) {
        this(javaAgentFinder, new DefaultJavaExecutableLocator(), Collections.emptyList(), new HashMap<String, String>());
    }

    public LaunchOptions(JavaAgent javaAgentFinder, JavaExecutableLocator javaExecutable, List<String> childJVMArgs, Map<String, String> environmentVariables) {
        this(javaAgentFinder, javaExecutable, childJVMArgs, environmentVariables, false);
    }

    public LaunchOptions(JavaAgent javaAgentFinder, JavaExecutableLocator javaExecutable, List<String> childJVMArgs, Map<String, String> environmentVariables, boolean usingClassPathJar) {
        this.javaAgentFinder = javaAgentFinder;
        this.childJVMArgs = childJVMArgs;
        this.javaExecutable = javaExecutable;
        this.environmentVariables = environmentVariables;
        this.usingClassPathJar = usingClassPathJar;
    }

    public JavaAgent getJavaAgentFinder() {
        return this.javaAgentFinder;
    }

    public List<String> getChildJVMArgs() {
        return this.childJVMArgs;
    }

    public String getJavaExecutable() {
        return this.javaExecutable.javaExecutable();
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public LaunchOptions usingClassPathJar(boolean useJar) {
        return new LaunchOptions(this.javaAgentFinder, this.javaExecutable, this.childJVMArgs, this.environmentVariables, useJar);
    }

    public boolean useClasspathJar() {
        return this.usingClassPathJar;
    }
}

