/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.staticinitializers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.pitest.mutationtest.build.InterceptorParameters;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.MutationInterceptorFactory;
import org.pitest.mutationtest.build.intercept.staticinitializers.StaticInitializerInterceptor;
import org.pitest.plugin.Feature;

public class StaticInitializerInterceptorFactory
implements MutationInterceptorFactory {
    public String description() {
        return "Static initializer code detector plugin";
    }

    @Override
    public MutationInterceptor createInterceptor(InterceptorParameters params) {
        return new StaticInitializerInterceptor(this.functionalInterfaces());
    }

    public Feature provides() {
        return Feature.named((String)"FSTATI").withOnByDefault(true).withDescription("Filters mutations in static initializers and code called only from them");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<String> functionalInterfaces() {
        HashSet<String> classes = new HashSet<String>();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/functional_interfaces.txt")));){
            String line = r.readLine();
            while (line != null) {
                classes.add(line);
                line = r.readLine();
            }
            HashSet<String> hashSet = classes;
            return hashSet;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read embedded list of functional interfaces!");
        }
    }
}

