/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.javafeatures;

import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.bytecode.analysis.OpcodeMatchers;
import org.pitest.mutationtest.build.intercept.Region;
import org.pitest.mutationtest.build.intercept.RegionInterceptor;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.Result;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotWrite;

public class EnumSwitchFilter
extends RegionInterceptor {
    static final Slot<AbstractInsnNode> START = Slot.create(AbstractInsnNode.class);
    static final Slot<AbstractInsnNode> END = Slot.create(AbstractInsnNode.class);
    static final SequenceMatcher<AbstractInsnNode> ENUM_SWITCH = QueryStart.any(AbstractInsnNode.class).then(EnumSwitchFilter.getStatic("$SwitchMap$").and(EnumSwitchFilter.store(START.write()))).then(OpcodeMatchers.ALOAD).then(InstructionMatchers.methodCallNamed("ordinal")).then(OpcodeMatchers.IALOAD.and(EnumSwitchFilter.store(END.write()))).then(OpcodeMatchers.LOOKUPSWITCH.or(OpcodeMatchers.TABLESWITCH)).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction()));

    private static Match<AbstractInsnNode> getStatic(String name) {
        return (c, n) -> {
            if (n instanceof FieldInsnNode) {
                return Result.result(((FieldInsnNode)n).name.contains(name), c);
            }
            return Result.result(false, c);
        };
    }

    @Override
    protected List<Region> computeRegions(MethodTree method) {
        Context context = Context.start();
        return ENUM_SWITCH.contextMatches(method.instructions(), context).stream().map(c -> new Region(c.retrieve(START.read()).get(), c.retrieve(END.read()).get())).collect(Collectors.toList());
    }

    private static Match<AbstractInsnNode> store(SlotWrite<AbstractInsnNode> slot) {
        return (c, n) -> Result.result(true, c.store(slot, n));
    }
}

