/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.util;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.model.CDefaultValue;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.FieldAccessor;
import com.sun.tools.xjc.outline.FieldOutline;
import org.jvnet.basicjaxb.util.FieldAccessorFactory;
import org.jvnet.basicjaxb.util.FieldUtils;
import org.jvnet.basicjaxb.xjc.outline.FieldAccessorEx;

public class PropertyFieldAccessorFactory
implements FieldAccessorFactory {
    public static FieldAccessorFactory INSTANCE = new PropertyFieldAccessorFactory();

    @Override
    public FieldAccessorEx createFieldAccessor(FieldOutline fieldOutline, JExpression targetObject) {
        return new PropertyFieldAccessor(fieldOutline, targetObject);
    }

    private static class PropertyFieldAccessor
    implements FieldAccessorEx {
        private static final JType[] ABSENT = new JType[0];
        private final FieldOutline fieldOutline;
        private final JExpression targetObject;
        private final JDefinedClass theClass;
        private final JMethod isSetter;
        private final JMethod unSetter;
        private final JMethod getter;
        private final JMethod setter;
        private final JFieldVar constantField;
        private final JFieldVar field;
        private FieldAccessor fieldAccessor;
        private final JType type;
        private final JType fieldType;

        public FieldOutline owner() {
            return this.fieldOutline;
        }

        @Override
        public JType getType() {
            return this.type;
        }

        public PropertyFieldAccessor(FieldOutline fieldOutline, JExpression targetObject) {
            this.fieldOutline = fieldOutline;
            this.targetObject = targetObject;
            this.fieldAccessor = fieldOutline.create(targetObject);
            String publicName = fieldOutline.getPropertyInfo().getName(true);
            String privateName = fieldOutline.getPropertyInfo().getName(false);
            this.theClass = fieldOutline.parent().implClass;
            String setterName = "set" + publicName;
            JMethod getGetter = this.theClass.getMethod("get" + publicName, ABSENT);
            JMethod isGetter = this.theClass.getMethod("is" + publicName, ABSENT);
            JFieldVar field = (JFieldVar)this.theClass.fields().get(privateName);
            Object object = this.field = FieldUtils.isPropertyField(field) ? field : null;
            this.getter = getGetter != null ? getGetter : (isGetter != null ? isGetter : null);
            this.type = this.getter != null ? this.getter.type() : fieldOutline.getRawType();
            this.fieldType = this.field != null ? this.field.type() : this.type;
            JFieldVar constantField = (JFieldVar)this.theClass.fields().get(publicName);
            this.constantField = FieldUtils.isConstantField(constantField) ? constantField : null;
            JType rawType = fieldOutline.getRawType();
            JMethod boxifiedSetter = this.theClass.getMethod(setterName, new JType[]{rawType.boxify()});
            JMethod unboxifiedSetter = this.theClass.getMethod(setterName, new JType[]{rawType.unboxify()});
            this.setter = boxifiedSetter != null ? boxifiedSetter : unboxifiedSetter;
            this.isSetter = this.theClass.getMethod("isSet" + publicName, ABSENT);
            this.unSetter = this.theClass.getMethod("unset" + publicName, ABSENT);
        }

        @Override
        public boolean isVirtual() {
            return this.constantField != null;
        }

        @Override
        public boolean isConstant() {
            return this.constantField != null;
        }

        public CPropertyInfo getPropertyInfo() {
            return this.fieldOutline.getPropertyInfo();
        }

        @Override
        public boolean isAlwaysSet() {
            if (this.constantField != null) {
                return true;
            }
            return JExpr.TRUE == this.fieldAccessor.hasSetValue();
        }

        public JExpression hasSetValue() {
            if (this.constantField != null) {
                return JExpr.TRUE;
            }
            if (this.isSetter != null) {
                return this.targetObject.invoke(this.isSetter);
            }
            return this.fieldAccessor.hasSetValue();
        }

        public void unsetValues(JBlock body) {
            if (this.constantField == null) {
                if (this.unSetter != null) {
                    body.invoke(this.targetObject, this.unSetter);
                } else {
                    this.fieldAccessor.unsetValues(body);
                }
            }
        }

        public void fromRawValue(JBlock block, String uniqueName, JExpression $var) {
            if (this.constantField == null) {
                if (this.setter != null) {
                    block.invoke(this.targetObject, this.setter).arg($var);
                } else {
                    this.unsetValues(block);
                    if (this.fieldOutline.getPropertyInfo().isCollection()) {
                        this.fieldAccessor.fromRawValue(block._if($var.ne(JExpr._null()))._then(), uniqueName, $var);
                    } else {
                        this.fieldAccessor.fromRawValue(block, uniqueName, $var);
                    }
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void toRawValue(JBlock block, JVar $var) {
            if (this.constantField != null) {
                block.assign((JAssignmentTarget)$var, (JExpression)this.theClass.staticRef((JVar)this.constantField));
                return;
            } else if (this.type.isPrimitive() || this.fieldOutline.getPropertyInfo().isCollection()) {
                JExpression defaultExpression;
                if (this.type.isPrimitive()) {
                    CDefaultValue defaultValue = this.fieldOutline.getPropertyInfo().defaultValue;
                    if (defaultValue != null) {
                        defaultExpression = defaultValue.compute(this.fieldOutline.parent().parent());
                    } else if (this.type.fullName().equals(this.type.owner().BOOLEAN.fullName())) {
                        defaultExpression = JExpr.FALSE;
                    } else if (this.type.fullName().equals(this.type.owner().BYTE.fullName())) {
                        boolean value = false;
                        defaultExpression = JExpr.lit((int)0);
                    } else if (this.type.fullName().equals(this.type.owner().CHAR.fullName())) {
                        boolean value = false;
                        defaultExpression = JExpr.lit((char)'\u0000');
                    } else if (this.type.fullName().equals(this.type.owner().DOUBLE.fullName())) {
                        double value = 0.0;
                        defaultExpression = JExpr.lit((double)0.0);
                    } else if (this.type.fullName().equals(this.type.owner().FLOAT.fullName())) {
                        float value = 0.0f;
                        defaultExpression = JExpr.lit((float)0.0f);
                    } else if (this.type.fullName().equals(this.type.owner().INT.fullName())) {
                        boolean value = false;
                        defaultExpression = JExpr.lit((int)0);
                    } else if (this.type.fullName().equals(this.type.owner().LONG.fullName())) {
                        long value = 0L;
                        defaultExpression = JExpr.lit((long)0L);
                    } else {
                        if (!this.type.fullName().equals(this.type.owner().SHORT.fullName())) throw new UnsupportedOperationException();
                        boolean value = false;
                        defaultExpression = JExpr.lit((int)0);
                    }
                } else {
                    if (!this.fieldOutline.getPropertyInfo().isCollection()) throw new UnsupportedOperationException();
                    defaultExpression = JExpr._null();
                }
                if (this.getter != null) {
                    if (this.isAlwaysSet()) {
                        block.assign((JAssignmentTarget)$var, (JExpression)this.targetObject.invoke(this.getter));
                        return;
                    } else {
                        block.assign((JAssignmentTarget)$var, JOp.cond((JExpression)this.hasSetValue(), (JExpression)this.targetObject.invoke(this.getter), (JExpression)defaultExpression));
                    }
                    return;
                } else {
                    JConditional _if = block._if(this.hasSetValue());
                    this.fieldAccessor.toRawValue(_if._then(), $var);
                    _if._else().assign((JAssignmentTarget)$var, defaultExpression);
                }
                return;
            } else if (this.getter != null) {
                block.assign((JAssignmentTarget)$var, (JExpression)this.targetObject.invoke(this.getter));
                return;
            } else {
                this.fieldAccessor.toRawValue(block, $var);
            }
        }
    }
}

