/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.xform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.organicdesign.fp.collections.MutableList;
import org.organicdesign.fp.collections.UnmodIterable;
import org.organicdesign.fp.collections.UnmodIterator;
import org.organicdesign.fp.function.Fn1;
import org.organicdesign.fp.function.Fn2;
import org.organicdesign.fp.oneOf.Or;

public abstract class Xform<A>
implements UnmodIterable<A> {
    private static final Object TERMINATE = new Object();
    public static final Xform EMPTY = new SourceProviderIterableDesc(Collections.emptyList());
    final Xform prevOp;

    private A terminate() {
        return (A)TERMINATE;
    }

    public static <T> Xform<T> empty() {
        return EMPTY;
    }

    public static <T> Xform<T> of(Iterable<? extends T> list) {
        if (list == null) {
            return Xform.empty();
        }
        return new SourceProviderIterableDesc<T>(list);
    }

    Xform(Xform pre) {
        this.prevOp = pre;
    }

    private static <H> H _fold(Iterable source, Operation[] ops, int opIdx, H ident, Fn2 reducer) {
        Object ret = ident;
        block0: for (Object o : source) {
            for (int j = opIdx; j < ops.length; ++j) {
                Operation op = ops[j];
                if (op.filter != null && !op.filter.apply(o).booleanValue()) continue block0;
                if (op.map != null) {
                    if ((o = op.map.apply(o)) != TERMINATE) continue;
                    return ret;
                }
                if (op.flatMap == null) continue;
                ret = Xform._fold(op.flatMap.apply(o), ops, j + 1, ret, reducer);
                continue block0;
            }
            ret = reducer.apply(ret, o);
        }
        return ret;
    }

    @Override
    public UnmodIterator<A> iterator() {
        return this.toMutableList().iterator();
    }

    @Override
    public Xform<A> concat(Iterable<? extends A> list) {
        if (list == null) {
            throw new IllegalArgumentException("Can't concat a null iterable");
        }
        return new AppendIterDesc<A>(this, new SourceProviderIterableDesc<A>(list));
    }

    @Override
    public Xform<A> precat(Iterable<? extends A> list) {
        if (list == null) {
            throw new IllegalArgumentException("Can't precat a null iterable");
        }
        return new AppendIterDesc<A>(Xform.of(list), this);
    }

    @Override
    public Xform<A> drop(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Can't drop less than zero items.");
        }
        return new DropDesc(this, n);
    }

    @Override
    public Xform<A> dropWhile(Fn1<? super A, Boolean> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("Can't dropWhile without a function.");
        }
        return new DropWhileDesc<A>(this, predicate);
    }

    @Override
    public <B> B fold(B ident, Fn2<? super B, ? super A, B> reducer) {
        if (reducer == null) {
            throw new IllegalArgumentException("Can't fold with a null reduction function.");
        }
        RunList runList = this.toRunList();
        return Xform._fold(runList, runList.opArray(), 0, ident, reducer);
    }

    @Override
    public <G, B> Or<G, B> foldUntil(G accum, Fn2<? super G, ? super A, B> terminator, Fn2<? super G, ? super A, G> reducer) {
        if (terminator == null) {
            return Or.good(this.fold((B)accum, (Fn2<? super B, ? super A, B>)reducer));
        }
        if (reducer == null) {
            throw new IllegalArgumentException("Can't fold with a null reduction function.");
        }
        MutableList as = this.toMutableList();
        for (Object a : as) {
            B term = terminator.apply(accum, (G)a);
            if (term != null) {
                return Or.bad(term);
            }
            accum = reducer.apply(accum, (G)a);
        }
        return Or.good(accum);
    }

    @Override
    public Xform<A> filter(Fn1<? super A, Boolean> f) {
        if (f == null) {
            throw new IllegalArgumentException("Can't filter with a null function.");
        }
        return new FilterDesc<A>(this, f);
    }

    @Override
    public <B> Xform<B> flatMap(Fn1<? super A, Iterable<B>> f) {
        if (f == null) {
            throw new IllegalArgumentException("Can't flatmap with a null function.");
        }
        return new FlatMapDesc<A, B>(this, f);
    }

    @Override
    public <B> Xform<B> map(Fn1<? super A, ? extends B> f) {
        if (f == null) {
            throw new IllegalArgumentException("Can't map with a null function.");
        }
        return new MapDesc<A, B>(this, f);
    }

    protected abstract RunList toRunList();

    @Override
    public Xform<A> take(long numItems) {
        if (numItems < 0L) {
            throw new IllegalArgumentException("Num items must be >= 0");
        }
        return new TakeDesc(this, numItems);
    }

    @Override
    public Xform<A> takeWhile(Fn1<? super A, Boolean> f) {
        if (f == null) {
            throw new IllegalArgumentException("Can't takeWhile with a null function.");
        }
        return new MapDesc<Object, Object>(this, a -> (Boolean)f.apply((A)a) != false ? a : this.terminate());
    }

    static class SourceProviderIterableDesc<T>
    extends Xform<T> {
        private final Iterable<? extends T> list;

        SourceProviderIterableDesc(Iterable<? extends T> l) {
            super(null);
            this.list = l;
        }

        @Override
        protected RunList toRunList() {
            return RunList.of(null, this.list);
        }

        public int hashCode() {
            return UnmodIterable.hash(this);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SourceProviderIterableDesc)) {
                return false;
            }
            return Objects.equals(this.list, ((SourceProviderIterableDesc)other).list);
        }
    }

    private static class TakeDesc<T>
    extends Xform<T> {
        private final long take;

        TakeDesc(Xform<T> prev, long t) {
            super(prev);
            this.take = t;
        }

        @Override
        protected RunList toRunList() {
            Operation op;
            OpStrategy earlierTs;
            RunList ret = this.prevOp.toRunList();
            for (int i = ret.list.size() - 1; i >= 0 && (earlierTs = (op = ret.list.get(i)).take(this.take)) != OpStrategy.CANNOT_HANDLE; --i) {
                if (earlierTs != OpStrategy.HANDLE_INTERNALLY) continue;
                return ret;
            }
            ret.list.add(new Operation.TakeOp(this.take));
            return ret;
        }
    }

    private static class FlatMapDesc<T, U>
    extends Xform<U> {
        final Fn1<? super T, Iterable<U>> f;

        FlatMapDesc(Xform<T> prev, Fn1<? super T, Iterable<U>> func) {
            super(prev);
            this.f = func;
        }

        @Override
        protected RunList toRunList() {
            RunList ret = this.prevOp.toRunList();
            ret.list.add(new Operation.FlatMapOp(this.f));
            return ret;
        }
    }

    private static class MapDesc<T, U>
    extends Xform<U> {
        final Fn1<? super T, ? extends U> f;

        MapDesc(Xform<T> prev, Fn1<? super T, ? extends U> func) {
            super(prev);
            this.f = func;
        }

        @Override
        protected RunList toRunList() {
            RunList ret = this.prevOp.toRunList();
            ret.list.add(new Operation.MapOp(this.f));
            return ret;
        }
    }

    private static class FilterDesc<T>
    extends Xform<T> {
        final Fn1<? super T, Boolean> f;

        FilterDesc(Xform<T> prev, Fn1<? super T, Boolean> func) {
            super(prev);
            this.f = func;
        }

        @Override
        protected RunList toRunList() {
            RunList ret = this.prevOp.toRunList();
            ret.list.add(new Operation.FilterOp(this.f));
            return ret;
        }
    }

    private static class DropWhileDesc<T>
    extends Xform<T> {
        final Fn1<? super T, Boolean> f;

        DropWhileDesc(Xform<T> prev, Fn1<? super T, Boolean> func) {
            super(prev);
            this.f = func;
        }

        @Override
        protected RunList toRunList() {
            RunList ret = this.prevOp.toRunList();
            ret.list.add(new Operation.FilterOp(new Fn1<Object, Boolean>(){
                private boolean active = true;

                @Override
                public Boolean applyEx(Object o) throws Exception {
                    boolean ret;
                    if (!this.active) {
                        return true;
                    }
                    boolean bl = ret = f.apply(o) == false;
                    if (ret) {
                        this.active = false;
                    }
                    return ret;
                }
            }));
            return ret;
        }
    }

    private static class DropDesc<T>
    extends Xform<T> {
        private final long dropAmt;

        DropDesc(Xform<T> prev, long d) {
            super(prev);
            this.dropAmt = d;
        }

        @Override
        protected RunList toRunList() {
            Operation op;
            Or<Long, OpStrategy> earlierDs;
            RunList ret = this.prevOp.toRunList();
            for (int i = ret.list.size() - 1; !(i < 0 || (earlierDs = (op = ret.list.get(i)).drop(this.dropAmt)).isBad() && earlierDs.bad() == OpStrategy.CANNOT_HANDLE); --i) {
                if (!earlierDs.isGood()) continue;
                return ret;
            }
            ret.list.add(new Operation.DropOp(this.dropAmt));
            return ret;
        }
    }

    private static class AppendIterDesc<T>
    extends Xform<T> {
        final Xform<T> src;

        AppendIterDesc(Xform<T> prev, Xform<T> s) {
            super(prev);
            this.src = s;
        }

        @Override
        protected RunList toRunList() {
            return new AppendOp(this.prevOp.toRunList(), this.src);
        }
    }

    private static class AppendOp
    extends RunList {
        private AppendOp(RunList prv, Iterable src) {
            super(prv, src);
        }

        @Override
        public Iterator iterator() {
            final ArrayList prevSrc = (ArrayList)Xform._fold(this.prev, this.prev.opArray(), 0, new ArrayList(), new Fn2<ArrayList, Object, ArrayList>(){

                @Override
                public ArrayList applyEx(ArrayList res, Object item) throws Exception {
                    res.add(item);
                    return res;
                }
            });
            return new Iterator(){
                Iterator innerIter;
                boolean usingPrevSrc;
                {
                    this.innerIter = prevSrc.iterator();
                    this.usingPrevSrc = true;
                }

                @Override
                public boolean hasNext() {
                    if (this.innerIter.hasNext()) {
                        return true;
                    }
                    if (this.usingPrevSrc) {
                        this.usingPrevSrc = false;
                        this.innerIter = source.iterator();
                    }
                    return this.innerIter.hasNext();
                }

                public Object next() {
                    return this.innerIter.next();
                }
            };
        }
    }

    protected static class RunList
    implements Iterable {
        Iterable source;
        List<Operation> list = new ArrayList<Operation>();
        RunList prev = null;

        private RunList(RunList prv, Iterable src) {
            this.prev = prv;
            this.source = src;
        }

        public static RunList of(RunList prv, Iterable src) {
            return new RunList(prv, src);
        }

        Operation[] opArray() {
            return this.list.toArray(new Operation[this.list.size()]);
        }

        public Iterator iterator() {
            return this.source.iterator();
        }
    }

    static abstract class Operation {
        Fn1<Object, Boolean> filter = null;
        Fn1 map = null;
        Fn1<Object, Iterable> flatMap = null;

        Operation() {
        }

        public Or<Long, OpStrategy> drop(long num) {
            return num < 1L ? Or.good(0L) : Or.bad(OpStrategy.CANNOT_HANDLE);
        }

        public OpStrategy take(long num) {
            return OpStrategy.CANNOT_HANDLE;
        }

        private static class TakeOp
        extends Operation {
            private long numToTake;

            TakeOp(long take) {
                this.numToTake = take;
                this.map = a -> {
                    if (this.numToTake > 0L) {
                        --this.numToTake;
                        return a;
                    }
                    return TERMINATE;
                };
            }

            @Override
            public OpStrategy take(long num) {
                if (num < this.numToTake) {
                    this.numToTake = num;
                }
                return OpStrategy.HANDLE_INTERNALLY;
            }
        }

        private static class FlatMapOp
        extends Operation {
            FlatMapOp(Fn1<Object, Iterable> func) {
                this.flatMap = func;
            }
        }

        private static class MapOp
        extends Operation {
            MapOp(Fn1 func) {
                this.map = func;
            }

            @Override
            public Or<Long, OpStrategy> drop(long num) {
                return Or.bad(OpStrategy.ASK_SUPPLIER);
            }

            @Override
            public OpStrategy take(long num) {
                return OpStrategy.ASK_SUPPLIER;
            }
        }

        private static class FilterOp
        extends Operation {
            FilterOp(Fn1<Object, Boolean> func) {
                this.filter = func;
            }
        }

        private static class DropOp
        extends Operation {
            private long leftToDrop;

            DropOp(long drop) {
                this.leftToDrop = drop;
                this.filter = o -> {
                    if (this.leftToDrop > 0L) {
                        --this.leftToDrop;
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                };
            }

            @Override
            public Or<Long, OpStrategy> drop(long num) {
                this.leftToDrop += num;
                return Or.good(num);
            }
        }
    }

    static enum OpStrategy {
        HANDLE_INTERNALLY,
        ASK_SUPPLIER,
        CANNOT_HANDLE;

    }
}

