/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.utility;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public final class ReadBufferManager {
    private int bufferSize;
    private ByteBuffer buffer;
    private FileChannel channel;
    private long windowStart;
    private long positionInFile;

    public ReadBufferManager(FileChannel channel) throws IOException {
        this(channel, 32768);
    }

    public ReadBufferManager(FileChannel channel, int bufferSize) throws IOException {
        this.channel = channel;
        this.buffer = ByteBuffer.allocate(0);
        this.windowStart = 0L;
        this.bufferSize = bufferSize;
        this.getWindowOffset(0L, bufferSize);
    }

    private int getWindowOffset(long bytePos, int length) throws IOException {
        long desiredMin = bytePos;
        long desiredMax = desiredMin + (long)length - 1L;
        if (desiredMin >= this.windowStart && desiredMax < this.windowStart + (long)this.buffer.capacity()) {
            long res = desiredMin - this.windowStart;
            if (res < Integer.MAX_VALUE) {
                return (int)res;
            }
            throw new IOException("this buffer is quite large...");
        }
        long bufferCapacity = Math.max(this.bufferSize, length);
        long size = this.channel.size();
        if ((bufferCapacity = Math.min(bufferCapacity, size - bytePos)) > Integer.MAX_VALUE) {
            throw new IOException("Woaw ! You want to have a REALLY LARGE buffer !");
        }
        this.windowStart = bytePos;
        this.channel.position(this.windowStart);
        if ((long)this.buffer.capacity() != bufferCapacity) {
            ByteOrder order = this.buffer.order();
            this.buffer = ByteBuffer.allocate((int)bufferCapacity);
            this.buffer.order(order);
        } else {
            this.buffer.clear();
        }
        this.channel.read(this.buffer);
        this.buffer.flip();
        return (int)(desiredMin - this.windowStart);
    }

    public byte getByte(long bytePos) throws IOException {
        int windowOffset = this.getWindowOffset(bytePos, 1);
        return this.buffer.get(windowOffset);
    }

    public long getLength() throws IOException {
        return this.channel.size();
    }

    public void order(ByteOrder order) {
        this.buffer.order(order);
    }

    public int getInt(long bytePos) throws IOException {
        int windowOffset = this.getWindowOffset(bytePos, 4);
        return this.buffer.getInt(windowOffset);
    }

    public long getLong(long bytePos) throws IOException {
        int windowOffset = this.getWindowOffset(bytePos, 8);
        return this.buffer.getLong(windowOffset);
    }

    public long getLong() throws IOException {
        long ret = this.getLong(this.positionInFile);
        this.positionInFile += 8L;
        return ret;
    }

    public byte get() throws IOException {
        byte ret = this.getByte(this.positionInFile);
        ++this.positionInFile;
        return ret;
    }

    public int getInt() throws IOException {
        int ret = this.getInt(this.positionInFile);
        this.positionInFile += 4L;
        return ret;
    }

    public void skip(int numBytes) throws IOException {
        this.positionInFile += (long)numBytes;
    }

    public ByteBuffer get(byte[] buffer) throws IOException {
        int windowOffset = this.getWindowOffset(this.positionInFile, buffer.length);
        this.buffer.position(windowOffset);
        this.positionInFile += (long)buffer.length;
        return this.buffer.get(buffer);
    }

    public ByteBuffer get(long pos, byte[] buffer) throws IOException {
        int windowOffset = this.getWindowOffset(pos, buffer.length);
        this.buffer.position(windowOffset);
        return this.buffer.get(buffer);
    }

    public void position(long position) {
        this.positionInFile = position;
    }

    public long getPosition() {
        return this.positionInFile;
    }

    public double getDouble() throws IOException {
        double ret = this.getDouble(this.positionInFile);
        this.positionInFile += 8L;
        return ret;
    }

    public double getDouble(long bytePos) throws IOException {
        int windowOffset = this.getWindowOffset(bytePos, 8);
        return this.buffer.getDouble(windowOffset);
    }

    public boolean isEOF() throws IOException {
        return this.buffer.remaining() == 0 && this.windowStart + (long)this.buffer.capacity() >= this.channel.size();
    }

    public long remaining() throws IOException {
        return this.channel.size() - this.windowStart - (long)this.buffer.position();
    }
}

