/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.tsv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.tools.Csv;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.utility.FileUtil;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;

public class TSVDriverFunction
implements DriverFunction {
    public static String DESCRIPTION = "TSV file (Tab Separated Values)";
    private static final int BATCH_MAX_SIZE = 100;

    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.COPY;
    }

    public String[] getImportFormats() {
        return new String[]{"tsv"};
    }

    public String[] getExportFormats() {
        return new String[]{"tsv"};
    }

    public String getFormatDescription(String format) {
        if (format.equalsIgnoreCase("tsv")) {
            return DESCRIPTION;
        }
        return "";
    }

    public boolean isSpatialFormat(String extension) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        if (FileUtil.isExtensionWellFormated(fileName, "tsv")) {
            boolean isH2 = JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData());
            TableLocation location = TableLocation.parse((String)tableReference, (Boolean)isH2);
            Statement st = null;
            try {
                st = connection.createStatement();
                Csv csv = new Csv();
                csv.setFieldDelimiter('\t');
                csv.setFieldSeparatorWrite("\t");
                csv.write(fileName.getPath(), st.executeQuery("SELECT * FROM " + location.toString()), null);
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
        } else {
            throw new SQLException("Only .tsv extension is supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        if (FileUtil.isFileImportable(fileName, "tsv")) {
            boolean isH2 = JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData());
            TableLocation requestedTable = TableLocation.parse((String)tableReference, (Boolean)isH2);
            String table = requestedTable.getTable();
            int AVERAGE_NODE_SIZE = 500;
            FileInputStream fis = new FileInputStream(fileName);
            FileChannel fc = fis.getChannel();
            long fileSize = fc.size();
            long readFileSizeEachNode = Math.max(1L, fileSize / (long)AVERAGE_NODE_SIZE / 100L);
            int average_row_size = 0;
            Csv csv = new Csv();
            csv.setFieldDelimiter('\t');
            csv.setFieldSeparatorRead('\t');
            ResultSet reader = csv.read((Reader)new BufferedReader(new InputStreamReader(fis)), null);
            ResultSetMetaData metadata = reader.getMetaData();
            int columnCount = metadata.getColumnCount();
            StringBuilder createTable = new StringBuilder("CREATE TABLE ");
            createTable.append(table).append("(");
            StringBuilder insertTable = new StringBuilder("INSERT INTO ");
            insertTable.append(table).append(" VALUES(");
            for (int i = 0; i < columnCount; ++i) {
                createTable.append(metadata.getColumnName(i + 1)).append(" VARCHAR,");
                insertTable.append("?,");
            }
            createTable.append(")");
            insertTable.append(")");
            Statement stmt = connection.createStatement();
            stmt.execute(createTable.toString());
            stmt.close();
            PreparedStatement pst = connection.prepareStatement(insertTable.toString());
            long batchSize = 0L;
            try {
                while (reader.next()) {
                    if (progress.isCanceled()) {
                        throw new SQLException("Canceled by user");
                    }
                    for (int i = 0; i < columnCount; ++i) {
                        pst.setString(i + 1, reader.getString(i + 1));
                    }
                    pst.addBatch();
                    if (++batchSize >= 100L) {
                        pst.executeBatch();
                        pst.clearBatch();
                        batchSize = 0L;
                    }
                    if ((long)average_row_size++ % readFileSizeEachNode != 0L) continue;
                    try {
                        progress.setStep((int)((double)fc.position() / (double)fileSize * 100.0));
                    }
                    catch (IOException iOException) {}
                }
                if (batchSize > 0L) {
                    pst.executeBatch();
                }
            }
            finally {
                pst.close();
            }
        }
    }
}

