/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.shp;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.h2.table.Column;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.dbf.DBFDriverFunction;
import org.h2gis.functions.io.dbf.internal.DbaseFileHeader;
import org.h2gis.functions.io.file_table.FileEngine;
import org.h2gis.functions.io.shp.internal.SHPDriver;
import org.h2gis.functions.io.shp.internal.ShapeType;
import org.h2gis.functions.io.shp.internal.ShapefileHeader;
import org.h2gis.functions.io.utility.FileUtil;
import org.h2gis.functions.io.utility.PRJUtil;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.SFSUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.jts_utils.GeometryMetaData;

public class SHPDriverFunction
implements DriverFunction {
    public static String DESCRIPTION = "ESRI shapefile";
    private static final int BATCH_MAX_SIZE = 100;

    public void exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        this.exportTable(connection, tableReference, fileName, progress, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress, String encoding) throws SQLException, IOException {
        boolean isH2 = JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData());
        if (!FileUtil.isExtensionWellFormated(fileName, "shp")) throw new SQLException("Only .shp extension is supported");
        TableLocation location = TableLocation.parse((String)tableReference, (Boolean)isH2);
        int recordCount = JDBCUtilities.getRowCount((Connection)connection, (String)tableReference);
        ProgressVisitor copyProgress = progress.subProcess(recordCount);
        List spatialFieldNames = SFSUtilities.getGeometryFields((Connection)connection, (TableLocation)TableLocation.parse((String)tableReference, (Boolean)isH2));
        if (spatialFieldNames.isEmpty()) {
            throw new SQLException(String.format("The table %s does not contain a geometry field", tableReference));
        }
        ShapeType shapeType = null;
        Statement st = connection.createStatement();
        try {
            ResultSet rs = st.executeQuery(String.format("select * from %s", location.toString()));
            try {
                ResultSetMetaData resultSetMetaData = rs.getMetaData();
                int geoFieldIndex = JDBCUtilities.getFieldIndex((ResultSetMetaData)resultSetMetaData, (String)((String)spatialFieldNames.get(0)));
                ArrayList<Integer> columnIndexes = new ArrayList<Integer>();
                DbaseFileHeader header = DBFDriverFunction.dBaseHeaderFromMetaData(resultSetMetaData, columnIndexes);
                columnIndexes.add(0, geoFieldIndex);
                if (encoding != null) {
                    header.setEncoding(encoding);
                }
                header.setNumRecords(recordCount);
                SHPDriver shpDriver = null;
                Object[] row = new Object[header.getNumFields() + 1];
                while (rs.next()) {
                    int i = 0;
                    for (Integer index : columnIndexes) {
                        row[i++] = rs.getObject(index);
                    }
                    if (shpDriver == null) {
                        byte[] wkb = rs.getBytes(geoFieldIndex);
                        if (wkb != null) {
                            shapeType = SHPDriverFunction.getShapeTypeFromGeometryMetaData(GeometryMetaData.getMetaDataFromWKB((byte[])wkb));
                        }
                        if (shapeType == null) throw new SQLException("Unsupported geometry type.");
                        shpDriver = new SHPDriver();
                        shpDriver.setGeometryFieldIndex(0);
                        shpDriver.initDriver(fileName, shapeType, header);
                    }
                    if (shpDriver != null) {
                        shpDriver.insertRow(row);
                    }
                    copyProgress.endStep();
                }
                if (shpDriver != null) {
                    shpDriver.close();
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            st.close();
        }
        String path = fileName.getAbsolutePath();
        String nameWithoutExt = path.substring(0, path.lastIndexOf(46));
        PRJUtil.writePRJ(connection, location, (String)spatialFieldNames.get(0), new File(nameWithoutExt + ".prj"));
        copyProgress.endOfProgress();
    }

    public String getFormatDescription(String format) {
        if (format.equalsIgnoreCase("shp")) {
            return DESCRIPTION;
        }
        return "";
    }

    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.COPY;
    }

    public String[] getImportFormats() {
        return new String[]{"shp"};
    }

    public String[] getExportFormats() {
        return new String[]{"shp"};
    }

    public boolean isSpatialFormat(String extension) {
        return extension.equalsIgnoreCase("shp");
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        this.importFile(connection, tableReference, fileName, progress, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress, String forceEncoding) throws SQLException, IOException {
        boolean isH2 = JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData());
        SHPDriver shpDriver = new SHPDriver();
        shpDriver.initDriverFromFile(fileName, forceEncoding);
        ProgressVisitor copyProgress = progress.subProcess((int)(shpDriver.getRowCount() / 100L));
        String lastSql = "";
        try {
            DbaseFileHeader dbfHeader = shpDriver.getDbaseFileHeader();
            ShapefileHeader shpHeader = shpDriver.getShapeFileHeader();
            Statement st = connection.createStatement();
            String types = DBFDriverFunction.getSQLColumnTypes(dbfHeader, isH2);
            if (!types.isEmpty()) {
                types = ", " + types;
            }
            TableLocation parse = TableLocation.parse((String)tableReference, (Boolean)isH2);
            ArrayList<Column> otherCols = new ArrayList<Column>(dbfHeader.getNumFields() + 1);
            otherCols.add(new Column("THE_GEOM", 0));
            for (int idColumn = 0; idColumn < dbfHeader.getNumFields(); ++idColumn) {
                otherCols.add(new Column(dbfHeader.getFieldName(idColumn), 0));
            }
            String pkColName = FileEngine.getUniqueColumnName("PK", otherCols);
            int srid = PRJUtil.getSRID(connection, shpDriver.prjFile);
            shpDriver.setSRID(srid);
            if (isH2) {
                st.execute(String.format("CREATE TABLE %s (" + pkColName + " SERIAL ,the_geom %s %s)", parse, SHPDriverFunction.getSFSGeometryType(shpHeader), types));
            } else {
                lastSql = String.format("CREATE TABLE %s (" + pkColName + " SERIAL PRIMARY KEY, the_geom GEOMETRY(%s, %d) %s)", parse, SHPDriverFunction.getPostGISSFSGeometryType(shpHeader), srid, types);
                st.execute(lastSql);
            }
            st.close();
            try {
                lastSql = String.format("INSERT INTO %s VALUES (DEFAULT, %s )", parse, DBFDriverFunction.getQuestionMark(dbfHeader.getNumFields() + 1));
                PreparedStatement preparedStatement = connection.prepareStatement(lastSql);
                try {
                    long batchSize = 0L;
                    int rowId = 0;
                    while ((long)rowId < shpDriver.getRowCount()) {
                        Object[] values = shpDriver.getRow(rowId);
                        for (int columnId = 0; columnId < values.length; ++columnId) {
                            preparedStatement.setObject(columnId + 1, values[columnId]);
                        }
                        preparedStatement.addBatch();
                        if (++batchSize >= 100L) {
                            preparedStatement.executeBatch();
                            preparedStatement.clearBatch();
                            batchSize = 0L;
                            copyProgress.endStep();
                        }
                        ++rowId;
                    }
                    if (batchSize > 0L) {
                        preparedStatement.executeBatch();
                    }
                }
                finally {
                    preparedStatement.close();
                }
                if (isH2) {
                    SFSUtilities.addTableSRIDConstraint((Connection)connection, (TableLocation)parse, (int)srid);
                }
            }
            catch (Exception ex) {
                connection.createStatement().execute("DROP TABLE IF EXISTS " + tableReference);
                throw new SQLException(ex.getLocalizedMessage(), ex);
            }
        }
        catch (SQLException ex) {
            throw new SQLException(lastSql + "\n" + ex.getLocalizedMessage(), ex);
        }
        finally {
            shpDriver.close();
            copyProgress.endOfProgress();
        }
    }

    private static ShapeType getShapeTypeFromGeometryMetaData(GeometryMetaData meta) throws SQLException {
        ShapeType shapeType;
        switch (meta.geometryType) {
            case 2: 
            case 5: 
            case 1002: 
            case 1005: 
            case 2002: 
            case 2005: {
                shapeType = meta.hasZ ? ShapeType.ARCZ : ShapeType.ARC;
                break;
            }
            case 1: {
                shapeType = meta.hasZ ? ShapeType.POINTZ : ShapeType.POINT;
                break;
            }
            case 4: {
                shapeType = meta.hasZ ? ShapeType.MULTIPOINTZ : ShapeType.MULTIPOINT;
                break;
            }
            case 3: 
            case 6: {
                shapeType = meta.hasZ ? ShapeType.POLYGONZ : ShapeType.POLYGON;
                break;
            }
            default: {
                return null;
            }
        }
        return shapeType;
    }

    private static String getSFSGeometryType(ShapefileHeader header) {
        switch (header.getShapeType().id) {
            case 1: 
            case 11: 
            case 21: {
                return "POINT";
            }
            case 3: 
            case 13: 
            case 23: {
                return "MULTILINESTRING";
            }
            case 5: 
            case 15: 
            case 25: {
                return "MULTIPOLYGON";
            }
            case 8: 
            case 18: 
            case 28: {
                return "MULTIPOINT";
            }
        }
        return "GEOMETRY";
    }

    private static String getPostGISSFSGeometryType(ShapefileHeader header) {
        switch (header.getShapeType().id) {
            case 1: {
                return "POINT";
            }
            case 11: 
            case 21: {
                return "POINTZ";
            }
            case 3: {
                return "MULTILINESTRING";
            }
            case 13: 
            case 23: {
                return "MULTILINESTRINGZ";
            }
            case 5: {
                return "MULTIPOLYGON";
            }
            case 15: 
            case 25: {
                return "MULTIPOLYGONZ";
            }
            case 8: {
                return "MULTIPOINT";
            }
            case 18: 
            case 28: {
                return "MULTIPOINTZ";
            }
        }
        return "GEOMETRY";
    }
}

