/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.osm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.h2gis.functions.io.gpx.model.GPXTags;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class OSMPreParser
extends DefaultHandler {
    private int totalNode = 0;
    private int totalWay = 0;
    private int totalRelation = 0;
    private String version = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read(File inputFile) throws SAXException, IOException {
        boolean success = false;
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(inputFile);
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setErrorHandler(this);
            parser.setContentHandler(this);
            parser.parse(new InputSource(fs));
            success = true;
        }
        finally {
            if (fs != null) {
                fs.close();
            }
        }
        return success;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.compareToIgnoreCase("osm") == 0) {
            this.version = attributes.getValue(GPXTags.VERSION);
        } else if (localName.compareToIgnoreCase("node") == 0) {
            ++this.totalNode;
        } else if (localName.compareToIgnoreCase("way") == 0) {
            ++this.totalWay;
        } else if (localName.compareToIgnoreCase("relation") == 0) {
            ++this.totalRelation;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public int getTotalNode() {
        return this.totalNode;
    }

    public int getTotalWay() {
        return this.totalWay;
    }

    public int getTotalRelation() {
        return this.totalRelation;
    }
}

