/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.gpx;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.io.gpx.GPXDriverFunction;
import org.h2gis.functions.io.utility.FileUtil;
import org.h2gis.utilities.URIUtilities;

public class GPXRead
extends AbstractFunction
implements ScalarFunction {
    public GPXRead() {
        this.addProperty("remarks", "Read a GPX file and copy the content in the specified tables.");
    }

    public String getJavaStaticMethod() {
        return "readGPX";
    }

    public static void readGPX(Connection connection, String fileName, String tableReference) throws IOException, SQLException {
        File file = URIUtilities.fileFromString((String)fileName);
        if (FileUtil.isFileImportable(file, "gpx")) {
            GPXDriverFunction gpxdf = new GPXDriverFunction();
            gpxdf.importFile(connection, tableReference, URIUtilities.fileFromString((String)fileName), (ProgressVisitor)new EmptyProgressVisitor());
        }
    }

    public static void readGPX(Connection connection, String fileName) throws IOException, SQLException {
        String name = URIUtilities.fileFromString((String)fileName).getName();
        GPXRead.readGPX(connection, fileName, name.substring(0, name.lastIndexOf(".")).toUpperCase());
    }
}

