/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.tracker;

import java.util.Iterator;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.lifecycle.AbstractLifecycle;
import org.ops4j.pax.swissbox.tracker.DefaultServiceCollectionListener;
import org.ops4j.pax.swissbox.tracker.ReplaceableServiceListener;
import org.ops4j.pax.swissbox.tracker.ServiceCollection;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceableService<T>
extends AbstractLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(ReplaceableService.class);
    private final BundleContext m_context;
    private final Class<T> m_serviceClass;
    private final ReplaceableServiceListener<T> m_serviceListener;
    private ServiceCollection<T> m_serviceCollection;
    private T m_service;

    public ReplaceableService(BundleContext context, Class<T> serviceClass) {
        this(context, serviceClass, null);
    }

    public ReplaceableService(BundleContext context, Class<T> serviceClass, ReplaceableServiceListener<T> listener) {
        LOG.debug("Creating replaceable service for [" + serviceClass + "]");
        NullArgumentException.validateNotNull((Object)context, (String)"Context");
        NullArgumentException.validateNotNull(serviceClass, (String)"Service class");
        this.m_context = context;
        this.m_serviceClass = serviceClass;
        this.m_serviceListener = listener;
    }

    public synchronized T getService() {
        return this.m_service;
    }

    private synchronized void setService(T newService) {
        if (this.m_service != newService) {
            LOG.debug("Service changed [" + this.m_service + "]  -> [" + newService + "]");
            T oldService = this.m_service;
            this.m_service = newService;
            if (this.m_serviceListener != null) {
                this.m_serviceListener.serviceChanged(oldService, this.m_service);
            }
        }
    }

    private synchronized void resolveService() {
        T newService = null;
        Iterator<T> it = this.m_serviceCollection.iterator();
        while (newService == null && it.hasNext()) {
            T candidateService = it.next();
            if (candidateService.equals(this.getService())) continue;
            newService = candidateService;
        }
        this.setService(newService);
    }

    protected void onStart() {
        this.m_serviceCollection = new ServiceCollection<T>(this.m_context, this.m_serviceClass, new CollectionListener());
        this.m_serviceCollection.start();
    }

    protected void onStop() {
        if (this.m_serviceCollection != null) {
            this.m_serviceCollection.stop();
            this.m_serviceCollection = null;
        }
        this.setService(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CollectionListener
    extends DefaultServiceCollectionListener<T> {
        private CollectionListener() {
        }

        @Override
        public boolean serviceAdded(ServiceReference serviceReference, T service) {
            if (ReplaceableService.this.getService() == null) {
                ReplaceableService.this.setService(service);
            }
            return true;
        }

        @Override
        public void serviceRemoved(ServiceReference serviceReference, T service) {
            if (service != null && service.equals(ReplaceableService.this.getService())) {
                ReplaceableService.this.resolveService();
            }
        }
    }
}

