/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import java.util.regex.Pattern;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.pattern.PatternTokenizer;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenizerFactory;

public class PatternTokenizerFactory
extends AbstractTokenizerFactory {
    private final Pattern pattern;
    private final int group;

    PatternTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, settings, name);
        String sPattern = settings.get("pattern", "\\W+");
        if (sPattern == null) {
            throw new IllegalArgumentException("pattern is missing for [" + name + "] tokenizer of type 'pattern'");
        }
        this.pattern = Regex.compile((String)sPattern, (String)settings.get("flags"));
        this.group = settings.getAsInt("group", Integer.valueOf(-1));
    }

    public Tokenizer create() {
        return new PatternTokenizer(this.pattern, this.group);
    }
}

