/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.analysis.common.DelimitedPayloadTokenFilterFactory;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;

public class LegacyDelimitedPayloadTokenFilterFactory
extends DelimitedPayloadTokenFilterFactory {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(LegacyDelimitedPayloadTokenFilterFactory.class);

    LegacyDelimitedPayloadTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, env, name, settings);
        if (indexSettings.getIndexVersionCreated().onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
            throw new IllegalArgumentException("[delimited_payload_filter] is not supported for new indices, use [delimited_payload] instead");
        }
        if (indexSettings.getIndexVersionCreated().onOrAfter((Version)LegacyESVersion.V_6_2_0)) {
            deprecationLogger.deprecate("analysis_legacy_delimited_payload_filter", "Deprecated [delimited_payload_filter] used, replaced by [delimited_payload]", new Object[0]);
        }
    }
}

