/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.FingerprintFilter;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.analysis.common.FingerprintAnalyzerProvider;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenFilterFactory;
import org.opensearch.index.analysis.TokenFilterFactory;

public class FingerprintTokenFilterFactory
extends AbstractTokenFilterFactory {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(FingerprintTokenFilterFactory.class);
    private final char separator;
    private final int maxOutputSize;

    FingerprintTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.separator = FingerprintAnalyzerProvider.parseSeparator(settings);
        this.maxOutputSize = settings.getAsInt(FingerprintAnalyzerProvider.MAX_OUTPUT_SIZE.getPreferredName(), Integer.valueOf(FingerprintAnalyzerProvider.DEFAULT_MAX_OUTPUT_SIZE));
    }

    public TokenStream create(TokenStream tokenStream) {
        TokenStream result = tokenStream;
        result = new FingerprintFilter(result, this.maxOutputSize, this.separator);
        return result;
    }

    public TokenFilterFactory getSynonymFilter() {
        if (this.indexSettings.getIndexVersionCreated().onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
            throw new IllegalArgumentException("Token filter [" + this.name() + "] cannot be used to parse synonyms");
        }
        DEPRECATION_LOGGER.deprecate(this.name() + "_synonym_tokenfilters", "Token filter [" + this.name() + "] will not be usable to parse synonyms after v7.0", new Object[0]);
        return this;
    }
}

