/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.tracing;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.telemetry.tracing.DefaultScopedSpan;
import org.opensearch.telemetry.tracing.DefaultSpanScope;
import org.opensearch.telemetry.tracing.ScopedSpan;
import org.opensearch.telemetry.tracing.Span;
import org.opensearch.telemetry.tracing.SpanContext;
import org.opensearch.telemetry.tracing.SpanCreationContext;
import org.opensearch.telemetry.tracing.SpanScope;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.telemetry.tracing.TracerContextStorage;
import org.opensearch.telemetry.tracing.TracingTelemetry;
import org.opensearch.telemetry.tracing.attributes.Attributes;

@InternalApi
class DefaultTracer
implements Tracer {
    static final String THREAD_NAME = "th_name";
    private final TracingTelemetry tracingTelemetry;
    private final TracerContextStorage<String, Span> tracerContextStorage;

    public DefaultTracer(TracingTelemetry tracingTelemetry, TracerContextStorage<String, Span> tracerContextStorage) {
        this.tracingTelemetry = tracingTelemetry;
        this.tracerContextStorage = tracerContextStorage;
    }

    @Override
    public Span startSpan(SpanCreationContext context) {
        return this.startSpan(context.getSpanName(), context.getAttributes());
    }

    @Override
    public Span startSpan(String spanName) {
        return this.startSpan(spanName, Attributes.EMPTY);
    }

    @Override
    public Span startSpan(String spanName, Attributes attributes) {
        return this.startSpan(spanName, (SpanContext)null, attributes);
    }

    @Override
    public Span startSpan(String spanName, SpanContext parentSpan, Attributes attributes) {
        Span span = null;
        span = parentSpan != null ? this.createSpan(spanName, parentSpan.getSpan(), attributes) : this.createSpan(spanName, this.getCurrentSpanInternal(), attributes);
        this.setCurrentSpanInContext(span);
        this.addDefaultAttributes(span);
        return span;
    }

    @Override
    public void close() throws IOException {
        this.tracingTelemetry.close();
    }

    private Span getCurrentSpanInternal() {
        return this.tracerContextStorage.get("current_span");
    }

    @Override
    public SpanContext getCurrentSpan() {
        Span currentSpan = this.tracerContextStorage.get("current_span");
        return currentSpan == null ? null : new SpanContext(currentSpan);
    }

    @Override
    public ScopedSpan startScopedSpan(SpanCreationContext spanCreationContext) {
        return this.startScopedSpan(spanCreationContext, null);
    }

    @Override
    public ScopedSpan startScopedSpan(SpanCreationContext spanCreationContext, SpanContext parentSpan) {
        Span span = this.startSpan(spanCreationContext.getSpanName(), parentSpan, spanCreationContext.getAttributes());
        SpanScope spanScope = this.withSpanInScope(span);
        return new DefaultScopedSpan(span, spanScope);
    }

    @Override
    public SpanScope withSpanInScope(Span span) {
        return DefaultSpanScope.create(span, this.tracerContextStorage).attach();
    }

    private Span createSpan(String spanName, Span parentSpan, Attributes attributes) {
        return this.tracingTelemetry.createSpan(spanName, parentSpan, attributes);
    }

    private void setCurrentSpanInContext(Span span) {
        this.tracerContextStorage.put("current_span", span);
    }

    protected void addDefaultAttributes(Span span) {
        span.addAttribute(THREAD_NAME, Thread.currentThread().getName());
    }

    @Override
    public Span startSpan(String spanName, Map<String, List<String>> headers, Attributes attributes) {
        Optional<Span> propagatedSpan = this.tracingTelemetry.getContextPropagator().extractFromHeaders(headers);
        return this.startSpan(spanName, (SpanContext)propagatedSpan.map(SpanContext::new).orElse(null), attributes);
    }
}

