/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common;

import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.opensearch.common.unit.TimeValue;

public class StopWatch {
    private final String id;
    private final List<TaskInfo> taskList = new LinkedList<TaskInfo>();
    private long startTimeNS;
    private boolean running;
    private String currentTaskName;
    private TaskInfo lastTaskInfo;
    private long totalTimeNS;

    public StopWatch() {
        this.id = "";
    }

    public StopWatch(String id) {
        this.id = id;
    }

    public StopWatch start() throws IllegalStateException {
        return this.start("");
    }

    public StopWatch start(String taskName) throws IllegalStateException {
        if (this.running) {
            throw new IllegalStateException("Can't start StopWatch: it's already running");
        }
        this.startTimeNS = System.nanoTime();
        this.running = true;
        this.currentTaskName = taskName;
        return this;
    }

    public StopWatch stop() throws IllegalStateException {
        if (!this.running) {
            throw new IllegalStateException("Can't stop StopWatch: it's not running");
        }
        long lastTimeNS = System.nanoTime() - this.startTimeNS;
        this.totalTimeNS += lastTimeNS;
        this.lastTaskInfo = new TaskInfo(this.currentTaskName, TimeValue.nsecToMSec(lastTimeNS));
        this.taskList.add(this.lastTaskInfo);
        this.running = false;
        this.currentTaskName = null;
        return this;
    }

    public TimingHandle timing(String taskName) {
        this.start(taskName);
        return this::stop;
    }

    public boolean isRunning() {
        return this.running;
    }

    public TimeValue lastTaskTime() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tests run: can't get last interval");
        }
        return this.lastTaskInfo.getTime();
    }

    public TimeValue totalTime() {
        return new TimeValue(this.totalTimeNS, TimeUnit.NANOSECONDS);
    }

    public TaskInfo[] taskInfo() {
        return this.taskList.toArray(new TaskInfo[0]);
    }

    public String shortSummary() {
        return "StopWatch '" + this.id + "': running time  = " + this.totalTime();
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder(this.shortSummary());
        sb.append('\n');
        sb.append("-----------------------------------------\n");
        sb.append("ms     %     Task name\n");
        sb.append("-----------------------------------------\n");
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ROOT);
        nf.setMinimumIntegerDigits(5);
        nf.setGroupingUsed(false);
        NumberFormat pf = NumberFormat.getPercentInstance(Locale.ROOT);
        pf.setMinimumIntegerDigits(3);
        pf.setGroupingUsed(false);
        for (TaskInfo task : this.taskInfo()) {
            sb.append(nf.format(task.getTime().millis())).append("  ");
            sb.append(pf.format(task.getTime().secondsFrac() / this.totalTime().secondsFrac())).append("  ");
            sb.append(task.getTaskName()).append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.shortSummary());
        for (TaskInfo task : this.taskInfo()) {
            sb.append("; [").append(task.getTaskName()).append("] took ").append(task.getTime());
            long percent = Math.round(100.0f * (float)task.getTime().millis() / (float)this.totalTime().millis());
            sb.append(" = ").append(percent).append("%");
        }
        return sb.toString();
    }

    public static class TaskInfo {
        private final String taskName;
        private final TimeValue timeValue;

        private TaskInfo(String taskName, long timeMillis) {
            this.taskName = taskName;
            this.timeValue = new TimeValue(timeMillis, TimeUnit.MILLISECONDS);
        }

        public String getTaskName() {
            return this.taskName;
        }

        public TimeValue getTime() {
            return this.timeValue;
        }
    }

    public static interface TimingHandle
    extends AutoCloseable {
        @Override
        public void close();
    }
}

