/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.spark.sql.streaming;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.internal.SQLConf$;
import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.util.unit.TimeValue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class SparkSqlStreamingConfigs$ {
    public static final SparkSqlStreamingConfigs$ MODULE$ = new SparkSqlStreamingConfigs$();
    private static final String OPENSEARCH_SINK_LOG_ENABLE = "opensearch.spark.sql.streaming.sink.log.enabled";
    private static final boolean OPENSEARCH_SINK_LOG_ENABLE_DEFAULT = true;
    private static final String OPENSEARCH_SINK_LOG_PATH = "opensearch.spark.sql.streaming.sink.log.path";
    private static final String OPENSEARCH_INTERNAL_APP_NAME = "opensearch.internal.spark.sql.streaming.appName";
    private static final String OPENSEARCH_INTERNAL_APP_ID = "opensearch.internal.spark.sql.streaming.appID";
    private static final String OPENSEARCH_INTERNAL_QUERY_NAME = "opensearch.internal.spark.sql.streaming.queryName";
    private static final String OPENSEARCH_INTERNAL_USER_CHECKPOINT_LOCATION = "opensearch.internal.spark.sql.streaming.userCheckpointLocation";
    private static final String OPENSEARCH_INTERNAL_SESSION_CHECKPOINT_LOCATION = "opensearch.internal.spark.sql.streaming.sessionCheckpointLocation";
    private static final String OPENSEARCH_SINK_LOG_CLEANUP_DELAY = "opensearch.spark.sql.streaming.sink.log.cleanupDelay";
    private static final long OPENSEARCH_SINK_LOG_CLEANUP_DELAY_DEFAULT = TimeUnit.MINUTES.toMillis(10L);
    private static final String OPENSEARCH_SINK_LOG_DELETION = "opensearch.spark.sql.streaming.sink.log.deletion";
    private static final boolean OPENSEARCH_SINK_LOG_DELETION_DEFAULT = true;
    private static final String OPENSEARCH_SINK_LOG_COMPACT_INTERVAL = "opensearch.spark.sql.streaming.sink.log.compactInterval";
    private static final int OPENSEARCH_SINK_LOG_COMPACT_INTERVAL_DEFAULT = 10;

    public String OPENSEARCH_SINK_LOG_ENABLE() {
        return OPENSEARCH_SINK_LOG_ENABLE;
    }

    public boolean OPENSEARCH_SINK_LOG_ENABLE_DEFAULT() {
        return OPENSEARCH_SINK_LOG_ENABLE_DEFAULT;
    }

    public String OPENSEARCH_SINK_LOG_PATH() {
        return OPENSEARCH_SINK_LOG_PATH;
    }

    public String OPENSEARCH_INTERNAL_APP_NAME() {
        return OPENSEARCH_INTERNAL_APP_NAME;
    }

    public String OPENSEARCH_INTERNAL_APP_ID() {
        return OPENSEARCH_INTERNAL_APP_ID;
    }

    public String OPENSEARCH_INTERNAL_QUERY_NAME() {
        return OPENSEARCH_INTERNAL_QUERY_NAME;
    }

    public String OPENSEARCH_INTERNAL_USER_CHECKPOINT_LOCATION() {
        return OPENSEARCH_INTERNAL_USER_CHECKPOINT_LOCATION;
    }

    public String OPENSEARCH_INTERNAL_SESSION_CHECKPOINT_LOCATION() {
        return OPENSEARCH_INTERNAL_SESSION_CHECKPOINT_LOCATION;
    }

    public String OPENSEARCH_SINK_LOG_CLEANUP_DELAY() {
        return OPENSEARCH_SINK_LOG_CLEANUP_DELAY;
    }

    public long OPENSEARCH_SINK_LOG_CLEANUP_DELAY_DEFAULT() {
        return OPENSEARCH_SINK_LOG_CLEANUP_DELAY_DEFAULT;
    }

    public String OPENSEARCH_SINK_LOG_DELETION() {
        return OPENSEARCH_SINK_LOG_DELETION;
    }

    public boolean OPENSEARCH_SINK_LOG_DELETION_DEFAULT() {
        return OPENSEARCH_SINK_LOG_DELETION_DEFAULT;
    }

    public String OPENSEARCH_SINK_LOG_COMPACT_INTERVAL() {
        return OPENSEARCH_SINK_LOG_COMPACT_INTERVAL;
    }

    public int OPENSEARCH_SINK_LOG_COMPACT_INTERVAL_DEFAULT() {
        return OPENSEARCH_SINK_LOG_COMPACT_INTERVAL_DEFAULT;
    }

    public boolean getSinkLogEnabled(Settings settings) {
        return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)settings.getProperty(this.OPENSEARCH_SINK_LOG_ENABLE())).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$1)))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> MODULE$.OPENSEARCH_SINK_LOG_ENABLE_DEFAULT()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String constructCommitLogPath(Settings settings) {
        Option option;
        Option<String> queryName;
        Option<String> sessionCheckpointLocation;
        Option<String> userCheckpointLocation;
        Option<String> logPath = this.getLogPath(settings);
        Tuple4 tuple4 = new Tuple4(logPath, userCheckpointLocation = this.getUserSpecifiedCheckpointLocation(settings), sessionCheckpointLocation = this.getSessionCheckpointLocation(settings), queryName = this.getQueryName(settings));
        if (tuple4 != null && (option = (Option)tuple4._1()) instanceof Some) {
            Some some = (Some)option;
            String explicitPath = (String)some.value();
            return explicitPath;
        }
        if (tuple4 != null) {
            Option option2 = (Option)tuple4._1();
            Option option3 = (Option)tuple4._2();
            if (None$.MODULE$.equals(option2) && option3 instanceof Some) {
                Some some = (Some)option3;
                String userCheckpoint = (String)some.value();
                return new StringBuilder(17).append(userCheckpoint).append("/sinks/opensearch").toString();
            }
        }
        if (tuple4 != null) {
            Option option4 = (Option)tuple4._1();
            Option option5 = (Option)tuple4._2();
            Option option6 = (Option)tuple4._3();
            Option option7 = (Option)tuple4._4();
            if (None$.MODULE$.equals(option4) && None$.MODULE$.equals(option5) && option6 instanceof Some) {
                Some some = (Some)option6;
                String sessionCheckpoint = (String)some.value();
                if (None$.MODULE$.equals(option7)) {
                    return new StringBuilder(18).append(sessionCheckpoint).append("/").append(UUID.randomUUID().toString()).append("/sinks/opensearch").toString();
                }
            }
        }
        if (tuple4 != null) {
            Option option8 = (Option)tuple4._1();
            Option option9 = (Option)tuple4._2();
            Option option10 = (Option)tuple4._3();
            Option option11 = (Option)tuple4._4();
            if (None$.MODULE$.equals(option8) && None$.MODULE$.equals(option9) && option10 instanceof Some) {
                Some some = (Some)option10;
                String sessionCheckpoint = (String)some.value();
                if (option11 instanceof Some) {
                    Some some2 = (Some)option11;
                    String query = (String)some2.value();
                    return new StringBuilder(18).append(sessionCheckpoint).append("/").append(query).append("/sinks/opensearch").toString();
                }
            }
        }
        if (tuple4 == null) throw new MatchError((Object)tuple4);
        Option option12 = (Option)tuple4._1();
        Option option13 = (Option)tuple4._2();
        Option option14 = (Option)tuple4._3();
        if (!None$.MODULE$.equals(option12)) throw new MatchError((Object)tuple4);
        if (!None$.MODULE$.equals(option13)) throw new MatchError((Object)tuple4);
        if (!None$.MODULE$.equals(option14)) throw new MatchError((Object)tuple4);
        throw new OpenSearchHadoopIllegalArgumentException(new StringBuilder(308).append("Could not determine path for the OpenSearch commit log. Specify the commit log location by setting the [checkpointLocation] option on your DataStreamWriter. If you do not want to persist the OpenSearch commit log in the regular checkpoint location for your streaming query then you can specify a location to ").append(new StringBuilder(72).append("store the log with [").append(this.OPENSEARCH_SINK_LOG_PATH()).append("], or disable the commit log by setting [").append(this.OPENSEARCH_SINK_LOG_ENABLE()).append("] to false.").toString()).toString());
    }

    public Option<String> getLogPath(Settings settings) {
        return Option$.MODULE$.apply((Object)settings.getProperty(this.OPENSEARCH_SINK_LOG_PATH()));
    }

    public Option<String> getAppName(Settings settings) {
        return Option$.MODULE$.apply((Object)settings.getProperty(this.OPENSEARCH_INTERNAL_APP_NAME()));
    }

    public Option<String> getAppId(Settings settings) {
        return Option$.MODULE$.apply((Object)settings.getProperty(this.OPENSEARCH_INTERNAL_APP_ID()));
    }

    public Option<String> getQueryName(Settings settings) {
        return Option$.MODULE$.apply((Object)settings.getProperty(this.OPENSEARCH_INTERNAL_QUERY_NAME()));
    }

    public Option<String> getUserSpecifiedCheckpointLocation(Settings settings) {
        return Option$.MODULE$.apply((Object)settings.getProperty(this.OPENSEARCH_INTERNAL_USER_CHECKPOINT_LOCATION()));
    }

    public Option<String> getSessionCheckpointLocation(Settings settings) {
        return Option$.MODULE$.apply((Object)settings.getProperty(this.OPENSEARCH_INTERNAL_SESSION_CHECKPOINT_LOCATION()));
    }

    public long getFileCleanupDelayMs(Settings settings) {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)settings.getProperty(this.OPENSEARCH_SINK_LOG_CLEANUP_DELAY())).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)SparkSqlStreamingConfigs$.$anonfun$getFileCleanupDelayMs$1(x$2))).orElse((Function0 & Serializable)() -> SQLConf$.MODULE$.FILE_SINK_LOG_CLEANUP_DELAY().defaultValue()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> MODULE$.OPENSEARCH_SINK_LOG_CLEANUP_DELAY_DEFAULT()));
    }

    public boolean getIsDeletingExpiredLog(Settings settings) {
        return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)settings.getProperty(this.OPENSEARCH_SINK_LOG_DELETION())).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$3)))).orElse((Function0 & Serializable)() -> SQLConf$.MODULE$.FILE_SINK_LOG_DELETION().defaultValue()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> MODULE$.OPENSEARCH_SINK_LOG_DELETION_DEFAULT()));
    }

    public int getDefaultCompactInterval(Settings settings) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)settings.getProperty(this.OPENSEARCH_SINK_LOG_COMPACT_INTERVAL())).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4)))).orElse((Function0 & Serializable)() -> SQLConf$.MODULE$.FILE_SINK_LOG_COMPACT_INTERVAL().defaultValue()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.OPENSEARCH_SINK_LOG_COMPACT_INTERVAL_DEFAULT()));
    }

    public static final /* synthetic */ long $anonfun$getFileCleanupDelayMs$1(String x$2) {
        return TimeValue.parseTimeValue(x$2).getMillis();
    }

    private SparkSqlStreamingConfigs$() {
    }
}

