/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.spark.sql;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.cfg.PropertiesSettings;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.mr.security.HadoopUserProvider;
import org.opensearch.hadoop.rest.InitializationUtils;
import org.opensearch.hadoop.util.ObjectUtils;
import org.opensearch.spark.cfg.SparkSettings;
import org.opensearch.spark.cfg.SparkSettingsManager;
import org.opensearch.spark.sql.OpenSearchDataFrameWriter;
import scala.;
import scala.$less$colon$less$;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Growable;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class OpenSearchSparkSQL$ {
    public static final OpenSearchSparkSQL$ MODULE$ = new OpenSearchSparkSQL$();
    private static final Class<?> init = ObjectUtils.loadClass("org.opensearch.spark.rdd.CompatUtils", ObjectUtils.class.getClassLoader());
    private static final transient Log LOG = LogFactory.getLog(MODULE$.getClass());

    private Class<?> init() {
        return init;
    }

    public Dataset<Row> openSearchDF(SQLContext sc) {
        return this.openSearchDF(sc, (Map<String, String>)((Map)Map$.MODULE$.empty()));
    }

    public Dataset<Row> openSearchDF(SQLContext sc, String resource) {
        return this.openSearchDF(sc, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.read"), (Object)resource)}))));
    }

    public Dataset<Row> openSearchDF(SQLContext sc, String resource, String query) {
        return this.openSearchDF(sc, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.read"), (Object)resource), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.query"), (Object)query)}))));
    }

    public Dataset<Row> openSearchDF(SQLContext sc, Map<String, String> cfg) {
        Settings openSearchConf = new SparkSettingsManager().load(sc.sparkContext().getConf()).copy();
        openSearchConf.merge((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(cfg).asJava());
        return sc.read().format("org.opensearch.spark.sql").options((Map)((IterableOnceOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(openSearchConf.asProperties()).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).load();
    }

    public Dataset<Row> openSearchDF(SQLContext sc, String resource, String query, Map<String, String> cfg) {
        return this.openSearchDF(sc, (Map<String, String>)((Map)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.read"), (Object)resource), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.query"), (Object)query), (Seq)Nil$.MODULE$)));
    }

    public Dataset<Row> openSearchDF(SQLContext sc, String resource, Map<String, String> cfg) {
        return this.openSearchDF(sc, (Map<String, String>)((Map)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.read"), (Object)resource))));
    }

    public Dataset<Row> openSearchDF(SparkSession ss) {
        return this.openSearchDF(ss.sqlContext(), (Map<String, String>)((Map)Map$.MODULE$.empty()));
    }

    public Dataset<Row> openSearchDF(SparkSession ss, String resource) {
        return this.openSearchDF(ss.sqlContext(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.read"), (Object)resource)}))));
    }

    public Dataset<Row> openSearchDF(SparkSession ss, String resource, String query) {
        return this.openSearchDF(ss.sqlContext(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.read"), (Object)resource), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.query"), (Object)query)}))));
    }

    public Dataset<Row> openSearchDF(SparkSession ss, Map<String, String> cfg) {
        return this.openSearchDF(ss.sqlContext(), cfg);
    }

    public Dataset<Row> openSearchDF(SparkSession ss, String resource, String query, Map<String, String> cfg) {
        return this.openSearchDF(ss.sqlContext(), resource, query, cfg);
    }

    public Dataset<Row> openSearchDF(SparkSession ss, String resource, Map<String, String> cfg) {
        return this.openSearchDF(ss.sqlContext(), resource, cfg);
    }

    public void saveToOpenSearch(Dataset<?> srdd, String resource) {
        this.saveToOpenSearch(srdd, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.write"), (Object)resource)}))));
    }

    public void saveToOpenSearch(Dataset<?> srdd, String resource, Map<String, String> cfg) {
        this.saveToOpenSearch(srdd, (Map<String, String>)((Map)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.write"), (Object)resource))));
    }

    public void saveToOpenSearch(Dataset<?> srdd, Map<String, String> cfg) {
        block1: {
            if (srdd == null) break block1;
            if (srdd.isStreaming()) {
                throw new OpenSearchHadoopIllegalArgumentException("Streaming Datasets should not be saved with 'saveToOpenSearch()'. Instead, use the 'writeStream().format(\"opensearch\").save()' methods.");
            }
            SparkContext sparkCtx = srdd.sqlContext().sparkContext();
            SparkSettings sparkCfg = new SparkSettingsManager().load(sparkCtx.getConf());
            Settings openSearchCfg = new PropertiesSettings().load(sparkCfg.save());
            openSearchCfg.merge((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(cfg).asJava());
            InitializationUtils.setUserProviderIfNotSet(openSearchCfg, HadoopUserProvider.class, LOG);
            InitializationUtils.discoverClusterInfo(openSearchCfg, LOG);
            InitializationUtils.checkIdForOperation(openSearchCfg);
            InitializationUtils.checkIndexExistence(openSearchCfg);
            OpenSearchDataFrameWriter openSearchDataFrameWriter = new OpenSearchDataFrameWriter(srdd.schema(), openSearchCfg.save());
            sparkCtx.runJob(srdd.toDF().rdd(), (Function2 & Serializable)(taskContext, data) -> {
                openSearchDataFrameWriter.write(taskContext, data);
                return BoxedUnit.UNIT;
            }, (ClassTag)ClassTag$.MODULE$.Unit());
        }
    }

    private OpenSearchSparkSQL$() {
    }
}

