/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.spark.sql;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.mr.security.HadoopUserProvider;
import org.opensearch.hadoop.rest.InitializationUtils;
import org.opensearch.hadoop.rest.RestRepository;
import org.opensearch.hadoop.serialization.Generator;
import org.opensearch.hadoop.serialization.builder.JdkValueWriter;
import org.opensearch.hadoop.serialization.field.ConstantFieldExtractor;
import org.opensearch.hadoop.serialization.json.JacksonJsonGenerator;
import org.opensearch.hadoop.util.FastByteArrayOutputStream;
import org.opensearch.hadoop.util.IOUtils;
import org.opensearch.hadoop.util.StringUtils;
import org.opensearch.spark.cfg.SparkSettingsManager;
import org.opensearch.spark.serialization.ScalaValueWriter;
import org.opensearch.spark.sql.OpenSearchRelation$;
import org.opensearch.spark.sql.OpenSearchSparkSQL$;
import org.opensearch.spark.sql.ScalaOpenSearchRowRDD;
import org.opensearch.spark.sql.SchemaUtils;
import org.opensearch.spark.sql.SchemaUtils$;
import org.opensearch.spark.sql.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.math.BigDecimal;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tUg!B\u00181\u0001BB\u0004\u0002\u0003/\u0001\u0005+\u0007I\u0011A/\t\u0011%\u0004!\u0011#Q\u0001\nyC\u0001B\u001b\u0001\u0003\u0016\u0004%\ta\u001b\u0005\ta\u0002\u0011\t\u0012)A\u0005Y\"AQ\u000f\u0001BK\u0002\u0013\u0005a\u000fC\u0005\u0002\u0002\u0001\u0011\t\u0012)A\u0005o\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001BCA\t\u0001!\u0015\r\u0011\"\u0001\u0002\u0014!Q\u0011Q\u0005\u0001\t\u0006\u0004%\t!a\n\t\u0015\u0005e\u0002\u0001#b\u0001\n\u0003\tY\u0004C\u0004\u0002L\u0001!\t%!\u0014\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!9\u0011q\n\u0001\u0005\u0002\u0005\u0015\u0004bBA(\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003\u000f\u0003A\u0011IAE\u0011\u001d\ti\t\u0001C\u0005\u0003\u001fCq!!(\u0001\t\u0013\ty\nC\u0004\u0002(\u0002!I!!+\t\u000f\u0005e\u0006\u0001\"\u0003\u0002<\"9\u0011\u0011\u0019\u0001\u0005\n\u0005\r\u0007bBAd\u0001\u0011%\u0011\u0011\u001a\u0005\b\u0003s\u0003A\u0011BAk\u0011\u001d\t\t\u000f\u0001C\u0001\u0003GDqAa\u0004\u0001\t\u0003\u0011\t\u0002C\u0005\u0003\u0014\u0001\t\t\u0011\"\u0001\u0003\u0016!I!Q\u0004\u0001\u0012\u0002\u0013\u0005!q\u0004\u0005\n\u0005k\u0001\u0011\u0013!C\u0001\u0005oA\u0011Ba\u000f\u0001#\u0003%\tA!\u0010\t\u0013\t\u0005\u0003!!A\u0005B\t\r\u0003\"\u0003B*\u0001\u0005\u0005I\u0011\u0001B+\u0011%\u0011i\u0006AA\u0001\n\u0003\u0011y\u0006C\u0005\u0003f\u0001\t\t\u0011\"\u0011\u0003h!I!Q\u000f\u0001\u0002\u0002\u0013\u0005!q\u000f\u0005\n\u0005w\u0002\u0011\u0011!C!\u0005{B\u0011B!!\u0001\u0003\u0003%\tEa!\t\u0013\t\u0015\u0005!!A\u0005B\t\u001d\u0005\"\u0003BE\u0001\u0005\u0005I\u0011\tBF\u000f)\u0011y\tMA\u0001\u0012\u0003\u0001$\u0011\u0013\u0004\n_A\n\t\u0011#\u00011\u0005'Cq!a\u0001(\t\u0003\u0011Y\u000bC\u0005\u0003\u0006\u001e\n\t\u0011\"\u0012\u0003\b\"I!QV\u0014\u0002\u0002\u0013\u0005%q\u0016\u0005\n\u0005o;\u0013\u0013!C\u0001\u0005{A\u0011B!/(\u0003\u0003%\tIa/\t\u0013\t%w%%A\u0005\u0002\tu\u0002\"\u0003BfO\u0005\u0005I\u0011\u0002Bg\u0005Iy\u0005/\u001a8TK\u0006\u00148\r\u001b*fY\u0006$\u0018n\u001c8\u000b\u0005E\u0012\u0014aA:rY*\u00111\u0007N\u0001\u0006gB\f'o\u001b\u0006\u0003kY\n!b\u001c9f]N,\u0017M]2i\u0015\u00059\u0014aA8sON1\u0001!O\"G\u0013>\u0003\"AO!\u000e\u0003mR!\u0001P\u001f\u0002\u000fM|WO]2fg*\u0011\u0011G\u0010\u0006\u0003g}R!\u0001\u0011\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\u00115H\u0001\u0007CCN,'+\u001a7bi&|g\u000e\u0005\u0002;\t&\u0011Qi\u000f\u0002\u0013!J,h.\u001a3GS2$XM]3e'\u000e\fg\u000e\u0005\u0002;\u000f&\u0011\u0001j\u000f\u0002\u0013\u0013:\u001cXM\u001d;bE2,'+\u001a7bi&|g\u000e\u0005\u0002K\u001b6\t1JC\u0001M\u0003\u0015\u00198-\u00197b\u0013\tq5JA\u0004Qe>$Wo\u0019;\u0011\u0005AKfBA)X\u001d\t\u0011f+D\u0001T\u0015\t!V+\u0001\u0004=e>|GOP\u0002\u0001\u0013\u0005a\u0015B\u0001-L\u0003\u001d\u0001\u0018mY6bO\u0016L!AW.\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005a[\u0015A\u00039be\u0006lW\r^3sgV\ta\f\u0005\u0003`G\u001a4gB\u00011b!\t\u00116*\u0003\u0002c\u0017\u00061\u0001K]3eK\u001aL!\u0001Z3\u0003\u00075\u000b\u0007O\u0003\u0002c\u0017B\u0011qlZ\u0005\u0003Q\u0016\u0014aa\u0015;sS:<\u0017a\u00039be\u0006lW\r^3sg\u0002\n!b]9m\u0007>tG/\u001a=u+\u0005a\u0007CA7o\u001b\u0005i\u0014BA8>\u0005)\u0019\u0016\u000bT\"p]R,\u0007\u0010^\u0001\fgFd7i\u001c8uKb$\b\u0005\u000b\u0002\u0005eB\u0011!j]\u0005\u0003i.\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0015U\u001cXM]*dQ\u0016l\u0017-F\u0001x!\rQ\u0005P_\u0005\u0003s.\u0013aa\u00149uS>t\u0007CA>\u007f\u001b\u0005a(BA?>\u0003\u0015!\u0018\u0010]3t\u0013\tyHP\u0001\u0006TiJ,8\r\u001e+za\u0016\f1\"^:feN\u001b\u0007.Z7bA\u00051A(\u001b8jiz\"\u0002\"a\u0002\u0002\f\u00055\u0011q\u0002\t\u0004\u0003\u0013\u0001Q\"\u0001\u0019\t\u000bq;\u0001\u0019\u00010\t\u000b)<\u0001\u0019\u00017\t\u000fU<\u0001\u0013!a\u0001o\u0006\u00191MZ4\u0016\u0005\u0005U\u0001\u0003BA\f\u0003?i!!!\u0007\u000b\t\u0005E\u00111\u0004\u0006\u0004\u0003;!\u0014A\u00025bI>|\u0007/\u0003\u0003\u0002\"\u0005e!\u0001C*fiRLgnZ:)\u0005!\u0011\u0018A\u00037buf\u001c6\r[3nCV\u0011\u0011\u0011\u0006\t\u0005\u0003W\t\tD\u0004\u0003\u0002\n\u00055\u0012bAA\u0018a\u0005Y1k\u00195f[\u0006,F/\u001b7t\u0013\u0011\t\u0019$!\u000e\u0003\rM\u001b\u0007.Z7b\u0015\r\ty\u0003\r\u0015\u0003\u0013I\f1B^1mk\u0016<&/\u001b;feV\u0011\u0011Q\b\t\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)\u0019\u00111\t\u001a\u0002\u001bM,'/[1mSj\fG/[8o\u0013\u0011\t9%!\u0011\u0003!M\u001b\u0017\r\\1WC2,Xm\u0016:ji\u0016\u0014\bF\u0001\u0006s\u0003\u0019\u00198\r[3nCV\t!0A\u0005ck&dGmU2b]R\u0011\u00111\u000b\t\u0007\u0003+\nY&a\u0018\u000e\u0005\u0005]#bAA-}\u0005\u0019!\u000f\u001a3\n\t\u0005u\u0013q\u000b\u0002\u0004%\u0012#\u0005cA7\u0002b%\u0019\u00111M\u001f\u0003\u0007I{w\u000f\u0006\u0003\u0002T\u0005\u001d\u0004bBA5\u001b\u0001\u0007\u00111N\u0001\u0010e\u0016\fX/\u001b:fI\u000e{G.^7ogB!!*!\u001cg\u0013\r\tyg\u0013\u0002\u0006\u0003J\u0014\u0018-\u001f\u000b\u0007\u0003g\nI(a\u001f\u0011\t\u0005%\u0011QO\u0005\u0004\u0003o\u0002$!F*dC2\fw\n]3o'\u0016\f'o\u00195S_^\u0014F\t\u0012\u0005\b\u0003Sr\u0001\u0019AA6\u0011\u001d\tiH\u0004a\u0001\u0003\u007f\nqAZ5mi\u0016\u00148\u000fE\u0003K\u0003[\n\t\tE\u0002;\u0003\u0007K1!!\"<\u0005\u00191\u0015\u000e\u001c;fe\u0006\u0001RO\u001c5b]\u0012dW\r\u001a$jYR,'o\u001d\u000b\u0005\u0003\u007f\nY\tC\u0004\u0002~=\u0001\r!a \u0002)\r\u0014X-\u0019;f\tNceI]8n\r&dG/\u001a:t)\u0019\tY'!%\u0002\u0014\"9\u0011Q\u0010\tA\u0002\u0005}\u0004bBAK!\u0001\u0007\u0011qS\u0001\u000fgR\u0014\u0018n\u0019;QkNDGi\\<o!\rQ\u0015\u0011T\u0005\u0004\u00037[%a\u0002\"p_2,\u0017M\\\u0001\u0010iJ\fgn\u001d7bi\u00164\u0015\u000e\u001c;feR)a-!)\u0002&\"9\u00111U\tA\u0002\u0005\u0005\u0015A\u00024jYR,'\u000fC\u0004\u0002\u0016F\u0001\r!a&\u0002\u000f%\u001c8\t\\1tgR1\u0011qSAV\u0003kCq!!,\u0013\u0001\u0004\ty+A\u0002pE*\u00042ASAY\u0013\r\t\u0019l\u0013\u0002\u0004\u0003:L\bBBA\\%\u0001\u0007a-A\u0005dY\u0006\u001c8OT1nK\u00069Q\r\u001f;sC\u000e$Hc\u00014\u0002>\"9\u0011qX\nA\u0002\u0005=\u0016!\u0002<bYV,\u0017AE3yiJ\f7\r^!t\u0015N|g.\u0011:sCf$2AZAc\u0011\u001d\ty\f\u0006a\u0001\u0003_\u000b\u0011#\u001a=ue\u0006\u001cG/T1uG\"\f%O]1z)\u00151\u00171ZAh\u0011\u0019\ti-\u0006a\u0001M\u0006I\u0011\r\u001e;sS\n,H/\u001a\u0005\b\u0003#,\u0002\u0019AAj\u0003\t\t'\u000fE\u0003K\u0003[\ny\u000bF\u0004g\u0003/\fI.!8\t\u000f\u0005}f\u00031\u0001\u00020\"9\u00111\u001c\fA\u0002\u0005]\u0015\u0001D5o\u0015N|gNR8s[\u0006$\bbBAp-\u0001\u0007\u0011qS\u0001\fCNT5o\u001c8BeJ\f\u00170\u0001\u0004j]N,'\u000f\u001e\u000b\u0007\u0003K\fYOa\u0003\u0011\u0007)\u000b9/C\u0002\u0002j.\u0013A!\u00168ji\"9\u0011Q^\fA\u0002\u0005=\u0018\u0001\u00023bi\u0006\u0004B!!=\u0003\u00069!\u00111\u001fB\u0002\u001d\u0011\t)P!\u0001\u000f\t\u0005]\u0018q \b\u0005\u0003s\fiPD\u0002S\u0003wL\u0011aN\u0005\u0003\u0001ZJ!aM \n\u0005Er\u0014B\u0001->\u0013\u0011\u00119A!\u0003\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u0001->\u0011\u001d\u0011ia\u0006a\u0001\u0003/\u000b\u0011b\u001c<fe^\u0014\u0018\u000e^3\u0002\u000f%\u001cX)\u001c9usR\u0011\u0011qS\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0002\b\t]!\u0011\u0004B\u000e\u0011\u001da\u0016\u0004%AA\u0002yCqA[\r\u0011\u0002\u0003\u0007A\u000eC\u0004v3A\u0005\t\u0019A<\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u0005\u0016\u0004=\n\r2F\u0001B\u0013!\u0011\u00119C!\r\u000e\u0005\t%\"\u0002\u0002B\u0016\u0005[\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t=2*\u0001\u0006b]:|G/\u0019;j_:LAAa\r\u0003*\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\b\u0016\u0004Y\n\r\u0012AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005\u007fQ3a\u001eB\u0012\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\t\t\u0005\u0005\u000f\u0012\t&\u0004\u0002\u0003J)!!1\nB'\u0003\u0011a\u0017M\\4\u000b\u0005\t=\u0013\u0001\u00026bm\u0006L1\u0001\u001bB%\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u00119\u0006E\u0002K\u00053J1Aa\u0017L\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tyK!\u0019\t\u0013\t\rt$!AA\u0002\t]\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003jA1!1\u000eB9\u0003_k!A!\u001c\u000b\u0007\t=4*\u0001\u0006d_2dWm\u0019;j_:LAAa\u001d\u0003n\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t9J!\u001f\t\u0013\t\r\u0014%!AA\u0002\u0005=\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BA!\u0012\u0003\u0000!I!1\r\u0012\u0002\u0002\u0003\u0007!qK\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!qK\u0001\ti>\u001cFO]5oOR\u0011!QI\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005]%Q\u0012\u0005\n\u0005G*\u0013\u0011!a\u0001\u0003_\u000b!c\u00149f]N+\u0017M]2i%\u0016d\u0017\r^5p]B\u0019\u0011\u0011B\u0014\u0014\u000b\u001d\u0012)J!)\u0011\u0013\t]%Q\u00140mo\u0006\u001dQB\u0001BM\u0015\r\u0011YjS\u0001\beVtG/[7f\u0013\u0011\u0011yJ!'\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0003$\n%VB\u0001BS\u0015\u0011\u00119K!\u0014\u0002\u0005%|\u0017b\u0001.\u0003&R\u0011!\u0011S\u0001\u0006CB\u0004H.\u001f\u000b\t\u0003\u000f\u0011\tLa-\u00036\")AL\u000ba\u0001=\")!N\u000ba\u0001Y\"9QO\u000bI\u0001\u0002\u00049\u0018aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0018Bc!\u0011Q\u0005Pa0\u0011\r)\u0013\tM\u00187x\u0013\r\u0011\u0019m\u0013\u0002\u0007)V\u0004H.Z\u001a\t\u0013\t\u001dG&!AA\u0002\u0005\u001d\u0011a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa4\u0011\t\t\u001d#\u0011[\u0005\u0005\u0005'\u0014IE\u0001\u0004PE*,7\r\u001e")
public class OpenSearchRelation
extends BaseRelation
implements PrunedFilteredScan,
InsertableRelation,
Product,
Serializable {
    private transient Settings cfg;
    private transient SchemaUtils.Schema lazySchema;
    private transient ScalaValueWriter valueWriter;
    private final scala.collection.immutable.Map<String, String> parameters;
    private final transient SQLContext sqlContext;
    private final Option<StructType> userSchema;
    private volatile transient byte bitmap$trans$0;

    public static Option<StructType> $lessinit$greater$default$3() {
        return OpenSearchRelation$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<scala.collection.immutable.Map<String, String>, SQLContext, Option<StructType>>> unapply(OpenSearchRelation x$0) {
        return OpenSearchRelation$.MODULE$.unapply(x$0);
    }

    public static Option<StructType> apply$default$3() {
        return OpenSearchRelation$.MODULE$.apply$default$3();
    }

    public static OpenSearchRelation apply(scala.collection.immutable.Map<String, String> parameters, SQLContext sqlContext, Option<StructType> userSchema) {
        return OpenSearchRelation$.MODULE$.apply(parameters, sqlContext, userSchema);
    }

    public static Function1<Tuple3<scala.collection.immutable.Map<String, String>, SQLContext, Option<StructType>>, OpenSearchRelation> tupled() {
        return OpenSearchRelation$.MODULE$.tupled();
    }

    public static Function1<scala.collection.immutable.Map<String, String>, Function1<SQLContext, Function1<Option<StructType>, OpenSearchRelation>>> curried() {
        return OpenSearchRelation$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public scala.collection.immutable.Map<String, String> parameters() {
        return this.parameters;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public Option<StructType> userSchema() {
        return this.userSchema;
    }

    /*
     * WARNING - void declaration
     */
    private Settings cfg$lzycompute() {
        OpenSearchRelation openSearchRelation = this;
        synchronized (openSearchRelation) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                void var2_2;
                Settings conf = new SparkSettingsManager().load(this.sqlContext().sparkContext().getConf()).merge((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.parameters()).asJava());
                InitializationUtils.setUserProviderIfNotSet(conf, HadoopUserProvider.class, LogFactory.getLog(OpenSearchRelation.class));
                InitializationUtils.discoverClusterInfo(conf, LogFactory.getLog(OpenSearchRelation.class));
                this.cfg = var2_2;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.cfg;
    }

    public Settings cfg() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.cfg$lzycompute() : this.cfg;
    }

    private SchemaUtils.Schema lazySchema$lzycompute() {
        OpenSearchRelation openSearchRelation = this;
        synchronized (openSearchRelation) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.lazySchema = SchemaUtils$.MODULE$.discoverMapping(this.cfg());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.lazySchema;
    }

    public SchemaUtils.Schema lazySchema() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.lazySchema$lzycompute() : this.lazySchema;
    }

    private ScalaValueWriter valueWriter$lzycompute() {
        OpenSearchRelation openSearchRelation = this;
        synchronized (openSearchRelation) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.valueWriter = new ScalaValueWriter();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.valueWriter;
    }

    public ScalaValueWriter valueWriter() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.valueWriter$lzycompute() : this.valueWriter;
    }

    public StructType schema() {
        return (StructType)this.userSchema().getOrElse((Function0 & Serializable)() -> this.lazySchema().struct());
    }

    public RDD<Row> buildScan() {
        return this.buildScan((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
    }

    public RDD<Row> buildScan(String[] requiredColumns) {
        return this.buildScan(requiredColumns, (Filter[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Filter.class)));
    }

    public ScalaOpenSearchRowRDD buildScan(String[] requiredColumns, Filter[] filters) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        LinkedHashMap paramWithScan = (LinkedHashMap)((MapOps)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus(this.parameters());
        String[] filteredColumns = requiredColumns;
        if (this.cfg().getReadMetadata()) {
            String metadata = this.cfg().getReadMetadataField();
            if (!ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])requiredColumns), (Object)metadata)) {
                boxedUnit2 = paramWithScan.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.read.metadata"), (Object)Boolean.toString(false)));
            } else {
                filteredColumns = (String[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])requiredColumns), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)OpenSearchRelation.$anonfun$buildScan$1(metadata, x$1)));
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        String sourceCSV = StringUtils.concatenate(filteredColumns, ",");
        paramWithScan.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.internal.mr.target.fields"), (Object)sourceCSV));
        String requiredCSV = StringUtils.concatenate(requiredColumns, ",");
        paramWithScan.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.internal.spark.sql.required.columns"), (Object)requiredCSV));
        String string = requiredCSV;
        String string2 = this.cfg().getReadMetadataField();
        Object object = !(string != null ? !string.equals(string2) : string2 != null) ? paramWithScan.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.internal.exclude.source"), (Object)"true")) : BoxedUnit.UNIT;
        if (filters != null && ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])filters)) > 0) {
            if (Utils.isPushDown(this.cfg())) {
                if (Utils.LOGGER.isDebugEnabled()) {
                    Utils.LOGGER.debug((Object)new StringBuilder(21).append("Pushing down filters ").append(Predef$.MODULE$.wrapRefArray((Object[])filters).mkString("[", ",", "]")).toString());
                }
                String[] filterString = this.createDSLFromFilters(filters, Utils.isPushDownStrict(this.cfg()));
                if (Utils.LOGGER.isTraceEnabled()) {
                    Utils.LOGGER.trace((Object)new StringBuilder(29).append("Transformed filters into DSL ").append(Predef$.MODULE$.wrapRefArray((Object[])filterString).mkString("[", ",", "]")).toString());
                }
                boxedUnit = paramWithScan.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.internal.query.filters"), (Object)IOUtils.serializeToBase64((Serializable)filterString)));
            } else {
                if (Utils.LOGGER.isTraceEnabled()) {
                    Utils.LOGGER.trace((Object)"Push-down is disabled; ignoring Spark filters...");
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new ScalaOpenSearchRowRDD(this.sqlContext().sparkContext(), (Map<String, String>)paramWithScan, this.lazySchema());
    }

    /*
     * WARNING - void declaration
     */
    public Filter[] unhandledFilters(Filter[] filters) {
        Filter[] filterArray;
        if (Utils.isKeepHandledFilters(this.cfg()) || filters == null || ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])filters)) == 0) {
            filterArray = filters;
        } else {
            void var2_2;
            Filter[] filtered = (Filter[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])filters), (Function1 & Serializable)filter -> BoxesRunTime.boxToBoolean((boolean)this.unhandled$1(filter)));
            if (Utils.LOGGER.isTraceEnabled()) {
                Utils.LOGGER.trace((Object)new StringBuilder(27).append("Unhandled filters from ").append(Predef$.MODULE$.wrapRefArray((Object[])filters).mkString("[", ",", "]")).append(" to ").append(Predef$.MODULE$.wrapRefArray((Object[])filtered).mkString("[", ",", "]")).toString());
            }
            filterArray = var2_2;
        }
        return filterArray;
    }

    private String[] createDSLFromFilters(Filter[] filters, boolean strictPushDown) {
        return (String[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])filters), (Function1 & Serializable)filter -> this.translateFilter((Filter)filter, strictPushDown), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)query -> BoxesRunTime.boxToBoolean((boolean)OpenSearchRelation.$anonfun$createDSLFromFilters$2(query)));
    }

    /*
     * Unable to fully structure code
     */
    private String translateFilter(Filter filter, boolean strictPushDown) {
        block13: {
            block23: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    block12: {
                                                        var6_3 = false;
                                                        var7_4 = null;
                                                        var8_5 = filter;
                                                        if (!(var8_5 instanceof EqualTo)) break block12;
                                                        var9_6 = (EqualTo)var8_5;
                                                        attribute = var9_6.attribute();
                                                        value = var9_6.value();
                                                        if (value == null) ** GOTO lbl-1000
                                                        v0 = value;
                                                        var12_9 = None$.MODULE$;
                                                        if (!(v0 == null ? var12_9 != null : v0.equals(var12_9) == false)) ** GOTO lbl-1000
                                                        v1 = value;
                                                        var13_10 = BoxedUnit.UNIT;
                                                        if (!(v1 != null ? v1.equals(var13_10) == false : var13_10 != null)) lbl-1000:
                                                        // 3 sources

                                                        {
                                                            v2 = new StringBuilder(45).append("{\"bool\":{\"must_not\":{\"exists\":{\"field\":\"").append(attribute).append("\"}}}}").toString();
                                                        } else {
                                                            v2 = BoxedUnit.UNIT;
                                                        }
                                                        var3_11 = strictPushDown != false ? new StringBuilder(14).append("{\"term\":{\"").append(attribute).append("\":").append(this.extract(value)).append("}}").toString() : new StringBuilder(15).append("{\"match\":{\"").append(attribute).append("\":").append(this.extract(value)).append("}}").toString();
                                                        break block13;
                                                    }
                                                    if (!(var8_5 instanceof GreaterThan)) break block14;
                                                    var14_12 = (GreaterThan)var8_5;
                                                    attribute = var14_12.attribute();
                                                    value = var14_12.value();
                                                    var3_11 = new StringBuilder(23).append("{\"range\":{\"").append(attribute).append("\":{\"gt\" :").append(this.extract(value)).append("}}}").toString();
                                                    break block13;
                                                }
                                                if (!(var8_5 instanceof GreaterThanOrEqual)) break block15;
                                                var17_15 = (GreaterThanOrEqual)var8_5;
                                                attribute = var17_15.attribute();
                                                value = var17_15.value();
                                                var3_11 = new StringBuilder(23).append("{\"range\":{\"").append(attribute).append("\":{\"gte\":").append(this.extract(value)).append("}}}").toString();
                                                break block13;
                                            }
                                            if (!(var8_5 instanceof LessThan)) break block16;
                                            var20_18 = (LessThan)var8_5;
                                            attribute = var20_18.attribute();
                                            value = var20_18.value();
                                            var3_11 = new StringBuilder(23).append("{\"range\":{\"").append(attribute).append("\":{\"lt\" :").append(this.extract(value)).append("}}}").toString();
                                            break block13;
                                        }
                                        if (!(var8_5 instanceof LessThanOrEqual)) break block17;
                                        var23_21 = (LessThanOrEqual)var8_5;
                                        attribute = var23_21.attribute();
                                        value = var23_21.value();
                                        var3_11 = new StringBuilder(23).append("{\"range\":{\"").append(attribute).append("\":{\"lte\":").append(this.extract(value)).append("}}}").toString();
                                        break block13;
                                    }
                                    if (!(var8_5 instanceof In)) break block18;
                                    var26_24 = (In)var8_5;
                                    attribute = var26_24.attribute();
                                    values = var26_24.values();
                                    filtered = (Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.genericArrayOps((Object)values), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$translateFilter$1$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)());
                                    if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.genericArrayOps((Object)filtered))) {
                                        return "";
                                    }
                                    attrType = this.lazySchema().struct().apply(attribute).dataType();
                                    var32_29 = attrType;
                                    var5_30 = DateType$.MODULE$.equals(var32_29) != false ? true : TimestampType$.MODULE$.equals(var32_29) != false;
                                    var4_31 = var5_30 != false;
                                    isStrictType = var4_31;
                                    if (!strictPushDown && isStrictType && Utils.LOGGER.isDebugEnabled()) {
                                        Utils.LOGGER.debug((Object)new StringBuilder(75).append("Attribute ").append(attribute).append(" type ").append(attrType).append(" not suitable for match query; using terms (strict) instead").toString());
                                    }
                                    var3_11 = strictPushDown != false || isStrictType != false ? new StringBuilder(15).append("{\"terms\":{\"").append(attribute).append("\":").append(this.extractAsJsonArray(filtered)).append("}}").toString() : new StringBuilder(22).append("{\"bool\":{\"should\":[").append(this.extractMatchArray(attribute, filtered)).append("]}}").toString();
                                    break block13;
                                }
                                if (!(var8_5 instanceof IsNull)) break block19;
                                var33_33 = (IsNull)var8_5;
                                attribute = var33_33.attribute();
                                var3_11 = new StringBuilder(45).append("{\"bool\":{\"must_not\":{\"exists\":{\"field\":\"").append(attribute).append("\"}}}}").toString();
                                break block13;
                            }
                            if (!(var8_5 instanceof IsNotNull)) break block20;
                            var35_35 = (IsNotNull)var8_5;
                            attribute = var35_35.attribute();
                            var3_11 = new StringBuilder(23).append("{\"exists\":{\"field\":\"").append(attribute).append("\"}}").toString();
                            break block13;
                        }
                        if (!(var8_5 instanceof And)) break block21;
                        var37_37 = (And)var8_5;
                        left = var37_37.left();
                        right = var37_37.right();
                        var3_11 = new StringBuilder(24).append("{\"bool\":{\"filter\":[").append(this.translateFilter(left, strictPushDown)).append(", ").append(this.translateFilter(right, strictPushDown)).append("]}}").toString();
                        break block13;
                    }
                    if (!(var8_5 instanceof Or)) break block22;
                    var40_40 = (Or)var8_5;
                    left = var40_40.left();
                    right = var40_40.right();
                    var3_11 = new StringBuilder(64).append("{\"bool\":{\"should\":[{\"bool\":{\"filter\":").append(this.translateFilter(left, strictPushDown)).append("}}, {\"bool\":{\"filter\":").append(this.translateFilter(right, strictPushDown)).append("}}]}}").toString();
                    break block13;
                }
                if (!(var8_5 instanceof Not)) break block23;
                var43_43 = (Not)var8_5;
                filterToNeg = var43_43.child();
                var3_11 = new StringBuilder(22).append("{\"bool\":{\"must_not\":").append(this.translateFilter(filterToNeg, strictPushDown)).append("}}").toString();
                break block13;
            }
            if (!(var8_5 instanceof Product)) ** GOTO lbl-1000
            var6_3 = true;
            var7_4 = var8_5;
            if (this.isClass(var7_4, "org.apache.spark.sql.sources.StringStartsWith")) {
                x = ((Product)var7_4).productElement(1).toString();
                arg = strictPushDown == false ? x.toLowerCase(Locale.ROOT) : x;
                var3_11 = new StringBuilder(21).append("{\"wildcard\":{\"").append(((Product)var7_4).productElement(0)).append("\":\"").append(arg).append("*\"}}").toString();
            } else if (var6_3 && this.isClass(var7_4, "org.apache.spark.sql.sources.StringEndsWith")) {
                x = ((Product)var7_4).productElement(1).toString();
                arg = strictPushDown == false ? x.toLowerCase(Locale.ROOT) : x;
                var3_11 = new StringBuilder(21).append("{\"wildcard\":{\"").append(((Product)var7_4).productElement(0)).append("\":\"*").append(arg).append("\"}}").toString();
            } else if (var6_3 && this.isClass(var7_4, "org.apache.spark.sql.sources.StringContains")) {
                x = ((Product)var7_4).productElement(1).toString();
                arg = strictPushDown == false ? x.toLowerCase(Locale.ROOT) : x;
                var3_11 = new StringBuilder(22).append("{\"wildcard\":{\"").append(((Product)var7_4).productElement(0)).append("\":\"*").append(arg).append("*\"}}").toString();
            } else if (var6_3 && this.isClass(var7_4, "org.apache.spark.sql.sources.EqualNullSafe")) {
                arg = this.extract(((Product)var7_4).productElement(1));
                var3_11 = strictPushDown != false ? new StringBuilder(14).append("{\"term\":{\"").append(((Product)var7_4).productElement(0)).append("\":").append(arg).append("}}").toString() : new StringBuilder(15).append("{\"match\":{\"").append(((Product)var7_4).productElement(0)).append("\":").append(arg).append("}}").toString();
            } else {
                var3_11 = "";
            }
        }
        return var3_11;
    }

    private boolean isClass(Object obj, String className) {
        return className.equals(obj.getClass().getName());
    }

    private String extract(Object value) {
        return this.extract(value, true, false);
    }

    private String extractAsJsonArray(Object value) {
        return this.extract(value, true, true);
    }

    private String extractMatchArray(String attribute, Object[] ar) {
        String string;
        LinkedHashSet numbers = LinkedHashSet$.MODULE$.empty();
        LinkedHashSet strings = LinkedHashSet$.MODULE$.empty();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps((Object)ar), (Function1 & Serializable)i -> {
            Object object = i;
            Object object2 = object == null ? BoxedUnit.UNIT : (object instanceof Number ? numbers.$plus$eq((Object)this.extract(i, false, false)) : strings.$plus$eq((Object)this.extract(i, false, false)));
            return object2;
        });
        if (numbers.isEmpty()) {
            string = strings.isEmpty() ? "" : new StringBuilder(15).append("{\"match\":{\"").append(attribute).append("\":").append(strings.mkString("\"", " ", "\"")).append("}}").toString();
        } else {
            String str = new StringBuilder(15).append("{\"terms\":{\"").append(attribute).append("\":").append(numbers.mkString("[", ",", "]")).append("}}").toString();
            string = strings.isEmpty() ? str : new StringBuilder(0).append(str).append(new StringBuilder(16).append(",{\"match\":{\"").append(attribute).append("\":").append(strings.mkString("\"", " ", "\"")).append("}}").toString()).toString();
        }
        return string;
    }

    private String extract(Object value, boolean inJsonFormat, boolean asJsonArray) {
        String string;
        Object object = value;
        if (object == null) {
            string = "null";
        } else if (object instanceof BoxedUnit) {
            string = "null";
        } else if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            string = Boolean.toString(bl);
        } else if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            string = Byte.toString(by);
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            string = Short.toString(s);
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            string = Integer.toString(n);
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            string = Long.toString(l);
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            string = Float.toString(f);
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            string = Double.toString(d);
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            string = bigDecimal.toString();
        } else {
            boolean bl = object instanceof Character ? true : (object instanceof String ? true : object instanceof byte[]);
            if (bl) {
                string = inJsonFormat ? StringUtils.toJsonString(value.toString()) : value.toString();
            } else if (object instanceof Date) {
                Date date = (Date)object;
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                String str = DatatypeConverter.printDateTime((Calendar)cal);
                string = inJsonFormat ? StringUtils.toJsonString(str) : str;
            } else if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                string = asJsonArray ? Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)objectArray), (Function1 & Serializable)i -> this.extract(i, true, false), ClassTag$.MODULE$.apply(String.class))))).mkString("[", ",", "]") : Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)objectArray), (Function1 & Serializable)i -> this.extract(i, false, false), ClassTag$.MODULE$.apply(String.class))))).mkString("\"", " ", "\"");
            } else if (this.isClass(object, "org.apache.spark.sql.types.UTF8String") || this.isClass(object, "org.apache.spark.unsafe.types.UTF8String")) {
                string = inJsonFormat ? StringUtils.toJsonString(object.toString()) : object.toString();
            } else if (object instanceof Object) {
                Object object2 = object;
                FastByteArrayOutputStream storage = new FastByteArrayOutputStream();
                JacksonJsonGenerator generator = new JacksonJsonGenerator(storage);
                this.valueWriter().write(object2, (Generator)generator);
                generator.flush();
                generator.close();
                string = storage.toString();
            } else {
                throw new MatchError(object);
            }
        }
        return string;
    }

    public void insert(Dataset<Row> data, boolean overwrite) {
        if (overwrite) {
            Utils.LOGGER.info((Object)new StringBuilder(21).append("Overwriting data for ").append(this.cfg().getResourceWrite()).toString());
            Settings cfgCopy = this.cfg().copy();
            InitializationUtils.setUserProviderIfNotSet(cfgCopy, HadoopUserProvider.class, null);
            InitializationUtils.discoverClusterInfo(cfgCopy, Utils.LOGGER);
            InitializationUtils.setValueWriterIfNotSet(cfgCopy, JdkValueWriter.class, null);
            InitializationUtils.setFieldExtractorIfNotSet(cfgCopy, ConstantFieldExtractor.class, null);
            cfgCopy.setProperty("opensearch.batch.flush.manual", "false");
            cfgCopy.setProperty("opensearch.batch.size.entries", "1000");
            cfgCopy.setProperty("opensearch.batch.size.bytes", "1mb");
            RestRepository rr = new RestRepository(cfgCopy);
            if (rr.resourceExists(false)) {
                rr.delete();
            }
            rr.close();
        }
        OpenSearchSparkSQL$.MODULE$.saveToOpenSearch((Dataset<?>)data, (Map<String, String>)this.parameters());
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEmpty() {
        void var2_2;
        RestRepository rr = new RestRepository(this.cfg());
        boolean empty = rr.isEmpty(true);
        rr.close();
        return (boolean)var2_2;
    }

    public OpenSearchRelation copy(scala.collection.immutable.Map<String, String> parameters, SQLContext sqlContext, Option<StructType> userSchema) {
        return new OpenSearchRelation(parameters, sqlContext, userSchema);
    }

    public scala.collection.immutable.Map<String, String> copy$default$1() {
        return this.parameters();
    }

    public SQLContext copy$default$2() {
        return this.sqlContext();
    }

    public Option<StructType> copy$default$3() {
        return this.userSchema();
    }

    public String productPrefix() {
        return "OpenSearchRelation";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.parameters();
                break;
            }
            case 1: {
                object = this.sqlContext();
                break;
            }
            case 2: {
                object = this.userSchema();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof OpenSearchRelation;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "parameters";
                break;
            }
            case 1: {
                string = "sqlContext";
                break;
            }
            case 2: {
                string = "userSchema";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof OpenSearchRelation)) return false;
        boolean bl = true;
        if (!bl) return false;
        OpenSearchRelation openSearchRelation = (OpenSearchRelation)x$1;
        scala.collection.immutable.Map<String, String> map = this.parameters();
        scala.collection.immutable.Map<String, String> map2 = openSearchRelation.parameters();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        SQLContext sQLContext = this.sqlContext();
        SQLContext sQLContext2 = openSearchRelation.sqlContext();
        if (sQLContext == null) {
            if (sQLContext2 != null) {
                return false;
            }
        } else if (!sQLContext.equals(sQLContext2)) return false;
        Option<StructType> option = this.userSchema();
        Option<StructType> option2 = openSearchRelation.userSchema();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!openSearchRelation.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$buildScan$1(String metadata$1, String x$1) {
        String string = x$1;
        String string2 = metadata$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean unhandled$1(Filter filter) {
        Filter filter2;
        Filter filter3;
        boolean bl;
        while (true) {
            Filter pred;
            bl = false;
            filter3 = null;
            filter2 = filter;
            if (filter2 instanceof EqualTo) {
                return false;
            }
            if (filter2 instanceof GreaterThan) {
                return false;
            }
            if (filter2 instanceof GreaterThanOrEqual) {
                return false;
            }
            if (filter2 instanceof LessThan) {
                return false;
            }
            if (filter2 instanceof LessThanOrEqual) {
                return false;
            }
            if (filter2 instanceof In) {
                return true;
            }
            if (filter2 instanceof IsNull) {
                return false;
            }
            if (filter2 instanceof IsNotNull) {
                return false;
            }
            if (filter2 instanceof And) {
                And and = (And)filter2;
                Filter left = and.left();
                Filter right = and.right();
                if (this.unhandled$1(left)) return true;
                filter = right;
                continue;
            }
            if (filter2 instanceof Or) {
                Or or = (Or)filter2;
                Filter left = or.left();
                Filter right = or.right();
                if (this.unhandled$1(left)) return true;
                filter = right;
                continue;
            }
            if (!(filter2 instanceof Not)) break;
            Not not = (Not)filter2;
            filter = pred = not.child();
        }
        if (filter2 instanceof Product) {
            bl = true;
            filter3 = filter2;
            if (this.isClass(filter3, "org.apache.spark.sql.sources.StringStartsWith")) {
                return false;
            }
        }
        if (bl && this.isClass(filter3, "org.apache.spark.sql.sources.StringEndsWith")) {
            return false;
        }
        if (bl && this.isClass(filter3, "org.apache.spark.sql.sources.StringContains")) {
            return false;
        }
        if (!bl) return true;
        if (!this.isClass(filter3, "org.apache.spark.sql.sources.EqualNullSafe")) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$createDSLFromFilters$2(String query) {
        return StringUtils.hasText(query);
    }

    public static final /* synthetic */ boolean $anonfun$translateFilter$1(Object x$2) {
        return x$2 != null;
    }

    public OpenSearchRelation(scala.collection.immutable.Map<String, String> parameters, SQLContext sqlContext, Option<StructType> userSchema) {
        this.parameters = parameters;
        this.sqlContext = sqlContext;
        this.userSchema = userSchema;
        Product.$init$((Product)this);
    }

    public static final /* synthetic */ Object $anonfun$translateFilter$1$adapted(Object x$2) {
        return BoxesRunTime.boxToBoolean((boolean)OpenSearchRelation.$anonfun$translateFilter$1(x$2));
    }
}

