/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.spark.sql;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.sources.StreamSinkProvider;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.OpenSearchHadoopIllegalStateException;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.mr.security.HadoopUserProvider;
import org.opensearch.hadoop.rest.InitializationUtils;
import org.opensearch.hadoop.util.Version;
import org.opensearch.spark.cfg.SparkSettingsManager;
import org.opensearch.spark.sql.OpenSearchRelation;
import org.opensearch.spark.sql.OpenSearchRelation$;
import org.opensearch.spark.sql.streaming.OpenSearchSparkSqlStreamingSink;
import org.opensearch.spark.sql.streaming.SparkSqlStreamingConfigs$;
import org.opensearch.spark.sql.streaming.StructuredStreamingVersionLock$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005]c!\u0002\u0005\n\u0001%\t\u0002\"B\u0016\u0001\t\u0003i\u0003\"\u0002\u0019\u0001\t\u0003\n\u0004\"\u0002\u0019\u0001\t\u0003z\u0005\"\u0002\u0019\u0001\t\u0003Z\u0006\"B;\u0001\t\u00032\b\u0002CA\u0013\u0001\u0011\u0005\u0011\"a\n\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J\tiA)\u001a4bk2$8k\\;sG\u0016T!AC\u0006\u0002\u0007M\fHN\u0003\u0002\r\u001b\u0005)1\u000f]1sW*\u0011abD\u0001\u000b_B,gn]3be\u000eD'\"\u0001\t\u0002\u0007=\u0014xm\u0005\u0004\u0001%a\u0011S\u0005\u000b\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005e\u0001S\"\u0001\u000e\u000b\u0005ma\u0012aB:pkJ\u001cWm\u001d\u0006\u0003\u0015uQ!\u0001\u0004\u0010\u000b\u0005}y\u0011AB1qC\u000eDW-\u0003\u0002\"5\t\u0001\"+\u001a7bi&|g\u000e\u0015:pm&$WM\u001d\t\u00033\rJ!\u0001\n\u000e\u0003-M\u001b\u0007.Z7b%\u0016d\u0017\r^5p]B\u0013xN^5eKJ\u0004\"!\u0007\u0014\n\u0005\u001dR\"!G\"sK\u0006$\u0018M\u00197f%\u0016d\u0017\r^5p]B\u0013xN^5eKJ\u0004\"!G\u0015\n\u0005)R\"AE*ue\u0016\fWnU5oWB\u0013xN^5eKJ\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002]A\u0011q\u0006A\u0007\u0002\u0013\u0005q1M]3bi\u0016\u0014V\r\\1uS>tGc\u0001\u001a6\u007fA\u0011\u0011dM\u0005\u0003ii\u0011ABQ1tKJ+G.\u0019;j_:DQA\u000e\u0002A\u0002]\n!b]9m\u0007>tG/\u001a=u!\tA\u0014(D\u0001\u001d\u0013\tQDD\u0001\u0006T#2\u001buN\u001c;fqRD#!\u000e\u001f\u0011\u0005Mi\u0014B\u0001 \u0015\u0005%!(/\u00198tS\u0016tG\u000fC\u0003A\u0005\u0001\u0007\u0011)\u0001\u0006qCJ\fW.\u001a;feN\u0004BAQ%M\u0019:\u00111i\u0012\t\u0003\tRi\u0011!\u0012\u0006\u0003\r2\na\u0001\u0010:p_Rt\u0014B\u0001%\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011!j\u0013\u0002\u0004\u001b\u0006\u0004(B\u0001%\u0015!\t\u0011U*\u0003\u0002O\u0017\n11\u000b\u001e:j]\u001e$BA\r)S'\")ag\u0001a\u0001o!\u0012\u0001\u000b\u0010\u0005\u0006\u0001\u000e\u0001\r!\u0011\u0005\u0006)\u000e\u0001\r!V\u0001\u0007g\u000eDW-\\1\u0011\u0005YKV\"A,\u000b\u0005ac\u0012!\u0002;za\u0016\u001c\u0018B\u0001.X\u0005)\u0019FO];diRK\b/\u001a\u000b\u0006eqs6\r\u001a\u0005\u0006m\u0011\u0001\ra\u000e\u0015\u00039rBQa\u0018\u0003A\u0002\u0001\fA!\\8eKB\u0011\u0001(Y\u0005\u0003Er\u0011\u0001bU1wK6{G-\u001a\u0005\u0006\u0001\u0012\u0001\r!\u0011\u0005\u0006K\u0012\u0001\rAZ\u0001\u0005I\u0006$\u0018\r\u0005\u0002he:\u0011\u0001\u000e\u001d\b\u0003S>t!A\u001b8\u000f\u0005-lgB\u0001#m\u0013\u0005\u0001\u0012BA\u0010\u0010\u0013\taa$\u0003\u0002\u000b;%\u0011\u0011\u000fH\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019HOA\u0005ECR\fgI]1nK*\u0011\u0011\u000fH\u0001\u000bGJ,\u0017\r^3TS:\\G\u0003C<\u0000\u0003\u0003\t\u0019!a\u0006\u0011\u0005alX\"A=\u000b\u0005i\\\u0018!C:ue\u0016\fW.\u001b8h\u0015\taH$A\u0005fq\u0016\u001cW\u000f^5p]&\u0011a0\u001f\u0002\u0005'&t7\u000eC\u00037\u000b\u0001\u0007q\u0007C\u0003A\u000b\u0001\u0007\u0011\tC\u0004\u0002\u0006\u0015\u0001\r!a\u0002\u0002!A\f'\u000f^5uS>t7i\u001c7v[:\u001c\b#BA\u0005\u0003#ae\u0002BA\u0006\u0003\u001fq1\u0001RA\u0007\u0013\u0005)\u0012BA9\u0015\u0013\u0011\t\u0019\"!\u0006\u0003\u0007M+\u0017O\u0003\u0002r)!9\u0011\u0011D\u0003A\u0002\u0005m\u0011AC8viB,H/T8eKB!\u0011QDA\u0011\u001b\t\tyB\u0003\u0002{9%!\u00111EA\u0010\u0005)yU\u000f\u001e9vi6{G-Z\u0001\u0007a\u0006\u0014\u0018-\\:\u0015\t\u0005%\u0012Q\t\t\b\u0003W\t)$a\u000eM\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012!C5n[V$\u0018M\u00197f\u0015\r\t\u0019\u0004F\u0001\u000bG>dG.Z2uS>t\u0017b\u0001&\u0002.A!\u0011\u0011HA\"\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012\u0001\u00027b]\u001eT!!!\u0011\u0002\t)\fg/Y\u0005\u0004\u001d\u0006m\u0002\"\u0002!\u0007\u0001\u0004\t\u0015\u0001D:ue\u0016\fW\u000eU1sC6\u001cHCBA\u0015\u0003\u0017\ni\u0005C\u0003A\u000f\u0001\u0007\u0011\tC\u0004\u0002P\u001d\u0001\r!!\u0015\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0007a\n\u0019&C\u0002\u0002Vq\u0011Ab\u00159be.\u001cVm]:j_:\u0004")
public class DefaultSource
implements RelationProvider,
SchemaRelationProvider,
CreatableRelationProvider,
StreamSinkProvider {
    public BaseRelation createRelation(SQLContext sqlContext, scala.collection.immutable.Map<String, String> parameters) {
        return new OpenSearchRelation(this.params(parameters), sqlContext, OpenSearchRelation$.MODULE$.apply$default$3());
    }

    public BaseRelation createRelation(SQLContext sqlContext, scala.collection.immutable.Map<String, String> parameters, StructType schema) {
        return new OpenSearchRelation(this.params(parameters), sqlContext, (Option<StructType>)new Some((Object)schema));
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> parameters, Dataset<Row> data) {
        OpenSearchRelation relation = new OpenSearchRelation(this.params(parameters), sqlContext, (Option<StructType>)new Some((Object)data.schema()));
        SaveMode saveMode = mode;
        if (SaveMode.Append.equals(saveMode)) {
            relation.insert(data, false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SaveMode.Overwrite.equals(saveMode)) {
            relation.insert(data, true);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SaveMode.ErrorIfExists.equals(saveMode)) {
            if (!relation.isEmpty()) {
                throw new OpenSearchHadoopIllegalStateException(new StringBuilder(0).append("SaveMode is set to ErrorIfExists and ").append(new StringBuilder(63).append("index ").append(relation.cfg().getResourceWrite()).append(" exists and contains data. Consider changing the SaveMode").toString()).toString());
            }
            relation.insert(data, false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SaveMode.Ignore.equals(saveMode)) {
            BoxedUnit boxedUnit;
            if (relation.isEmpty()) {
                relation.insert(data, false);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError((Object)saveMode);
        }
        return relation;
    }

    public Sink createSink(SQLContext sqlContext, scala.collection.immutable.Map<String, String> parameters, Seq<String> partitionColumns, OutputMode outputMode) {
        SparkSession sparkSession = sqlContext.sparkSession();
        StructuredStreamingVersionLock$.MODULE$.checkCompatibility(sparkSession);
        Seq<String> seq = partitionColumns;
        Nil$ nil$ = package$.MODULE$.Nil();
        if (seq == null ? nil$ != null : !seq.equals((Object)nil$)) {
            throw new OpenSearchHadoopIllegalArgumentException("Partition columns are not supported for OpenSearch. If you need to partition your data by column values on OpenSearch, please use an index pattern instead.");
        }
        scala.collection.mutable.Map mapConfig = (scala.collection.mutable.Map)((Growable)Map$.MODULE$.apply(parameters.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.internal.transport.pooling.key"), (Object)UUID.randomUUID().toString()));
        Settings jobSettings = new SparkSettingsManager().load(sqlContext.sparkContext().getConf()).merge((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.streamParams((scala.collection.immutable.Map<String, String>)mapConfig.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), sparkSession)).asJava());
        OutputMode outputMode2 = outputMode;
        OutputMode outputMode3 = OutputMode.Update();
        if (!(outputMode2 != null ? !outputMode2.equals(outputMode3) : outputMode3 != null)) {
            String writeOperation = jobSettings.getProperty("opensearch.write.operation");
            if (writeOperation == null) {
                jobSettings.setProperty("opensearch.write.operation", "upsert");
            } else {
                String string = writeOperation;
                String string2 = "upsert";
                if (string == null ? string2 != null : !string.equals(string2)) {
                    throw new OpenSearchHadoopIllegalArgumentException("Output mode update is only supported if opensearch.write.operation is unset or set to upsert");
                }
            }
        } else {
            OutputMode outputMode4 = outputMode;
            OutputMode outputMode5 = OutputMode.Append();
            if (outputMode4 == null ? outputMode5 != null : !outputMode4.equals(outputMode5)) {
                throw new OpenSearchHadoopIllegalArgumentException(new StringBuilder(69).append("Append and update are the only supported OutputModes for OpenSearch. ").append(new StringBuilder(24).append("Cannot continue with [").append(outputMode).append("].").toString()).toString());
            }
        }
        InitializationUtils.setUserProviderIfNotSet(jobSettings, HadoopUserProvider.class, LogFactory.getLog(DefaultSource.class));
        InitializationUtils.discoverClusterInfo(jobSettings, LogFactory.getLog(DefaultSource.class));
        InitializationUtils.checkIdForOperation(jobSettings);
        InitializationUtils.checkIndexExistence(jobSettings);
        return new OpenSearchSparkSqlStreamingSink(sparkSession, jobSettings);
    }

    public scala.collection.immutable.Map<String, String> params(scala.collection.immutable.Map<String, String> parameters) {
        scala.collection.immutable.Map map;
        scala.collection.immutable.Map dottedParams = (scala.collection.immutable.Map)parameters.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k.replace('_', '.'), (Object)v);
            return tuple22;
        });
        Option preferredResource = dottedParams.get((Object)"opensearch.resource").orElse((Function0 & Serializable)() -> dottedParams.get((Object)"resource")).orElse((Function0 & Serializable)() -> dottedParams.get((Object)"path"));
        scala.collection.immutable.Map processedParams = (scala.collection.immutable.Map)dottedParams.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$2;
            if (tuple22 != null) {
                String k = (String)tuple22._1();
                String v = (String)tuple22._2();
                if (k.startsWith("opensearch.")) {
                    tuple2 = new Tuple2((Object)k, (Object)v);
                } else {
                    String string = k;
                    String string2 = "path";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        tuple2 = new Tuple2((Object)"opensearch.resource", (Object)v);
                    } else {
                        String string3 = k;
                        String string4 = "pushdown";
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                            tuple2 = new Tuple2((Object)"opensearch.internal.spark.sql.pushdown", (Object)v);
                        } else {
                            String string5 = k;
                            String string6 = "strict";
                            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                                tuple2 = new Tuple2((Object)"opensearch.internal.spark.sql.pushdown.strict", (Object)v);
                            } else {
                                String string7 = k;
                                String string8 = "double.filtering";
                                tuple2 = !(string7 != null ? !string7.equals(string8) : string8 != null) ? new Tuple2((Object)"opensearch.internal.spark.sql.pushdown.keep.handled.filters", (Object)v) : new Tuple2((Object)new StringBuilder(11).append("opensearch.").append(k).toString(), (Object)v);
                            }
                        }
                    }
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple23 = tuple2;
            return tuple23;
        });
        Option option = preferredResource;
        if (option instanceof Some) {
            Some some = (Some)option;
            String resource = (String)some.value();
            map = (scala.collection.immutable.Map)processedParams.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource"), (Object)resource));
        } else if (None$.MODULE$.equals(option)) {
            map = processedParams;
        } else {
            throw new MatchError((Object)option);
        }
        scala.collection.immutable.Map finalParams = map;
        finalParams.getOrElse((Object)"opensearch.resource.read", (Function0 & Serializable)() -> (String)finalParams.getOrElse((Object)"opensearch.resource", (Function0 & Serializable)() -> {
            throw new OpenSearchHadoopIllegalArgumentException("resource must be specified for OpenSearch resources.");
        }));
        return finalParams;
    }

    private scala.collection.immutable.Map<String, String> streamParams(scala.collection.immutable.Map<String, String> parameters, SparkSession sparkSession) {
        ObjectRef params = ObjectRef.create((Object)((scala.collection.immutable.Map)((MapOps)parameters.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k.replace('_', '.'), (Object)v);
            return tuple22;
        })).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$2;
            if (tuple22 != null) {
                String k = (String)tuple22._1();
                String v = (String)tuple22._2();
                if (k.startsWith("opensearch.")) {
                    tuple2 = new Tuple2((Object)k, (Object)v);
                } else {
                    String string = k;
                    String string2 = "path";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        tuple2 = new Tuple2((Object)"opensearch.resource", (Object)v);
                    } else {
                        String string3 = k;
                        String string4 = "queryname";
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                            tuple2 = new Tuple2((Object)SparkSqlStreamingConfigs$.MODULE$.OPENSEARCH_INTERNAL_QUERY_NAME(), (Object)v);
                        } else {
                            String string5 = k;
                            String string6 = "checkpointlocation";
                            tuple2 = !(string5 != null ? !string5.equals(string6) : string6 != null) ? new Tuple2((Object)SparkSqlStreamingConfigs$.MODULE$.OPENSEARCH_INTERNAL_USER_CHECKPOINT_LOCATION(), (Object)v) : new Tuple2((Object)new StringBuilder(11).append("opensearch.").append(k).toString(), (Object)v);
                        }
                    }
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple23 = tuple2;
            return tuple23;
        })));
        params.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)params.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SparkSqlStreamingConfigs$.MODULE$.OPENSEARCH_INTERNAL_APP_NAME()), (Object)sparkSession.sparkContext().appName()));
        params.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)params.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SparkSqlStreamingConfigs$.MODULE$.OPENSEARCH_INTERNAL_APP_ID()), (Object)sparkSession.sparkContext().applicationId()));
        sparkSession.conf().getOption(SQLConf$.MODULE$.CHECKPOINT_LOCATION().key()).foreach((Function1 & Serializable)loc -> {
            params.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)params.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SparkSqlStreamingConfigs$.MODULE$.OPENSEARCH_INTERNAL_SESSION_CHECKPOINT_LOCATION()), (Object)loc));
            return BoxedUnit.UNIT;
        });
        ((scala.collection.immutable.Map)params.elem).getOrElse((Object)"opensearch.resource.write", (Function0 & Serializable)() -> (String)((scala.collection.immutable.Map)params$1.elem).getOrElse((Object)"opensearch.resource", (Function0 & Serializable)() -> {
            throw new OpenSearchHadoopIllegalArgumentException("resource must be specified for OpenSearch resources.");
        }));
        return (scala.collection.immutable.Map)params.elem;
    }

    public DefaultSource() {
        Version.logVersion();
    }
}

