/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.util.encoding;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.thirdparty.apache.commons.httpclient.URIException;
import org.opensearch.hadoop.thirdparty.apache.commons.httpclient.util.URIUtil;
import org.opensearch.hadoop.util.StringUtils;

public final class HttpEncodingTools {
    private HttpEncodingTools() {
    }

    @Deprecated
    public static String encodeUri(String uri) {
        try {
            return URIUtil.encodePathQuery(uri);
        }
        catch (URIException ex) {
            throw new OpenSearchHadoopIllegalArgumentException("Cannot escape uri [" + uri + "]", ex);
        }
    }

    @Deprecated
    public static String encodePath(String path) {
        try {
            return URIUtil.encodePath(path, "UTF-8");
        }
        catch (URIException ex) {
            throw new OpenSearchHadoopIllegalArgumentException("Cannot encode path segment [" + path + "]", ex);
        }
    }

    public static String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OpenSearchHadoopIllegalArgumentException("Cannot encode string [" + value + "]", e);
        }
    }

    public static String decode(String encoded) {
        try {
            return URLDecoder.decode(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OpenSearchHadoopIllegalArgumentException("Cannot decode string [" + encoded + "]", e);
        }
    }

    public static String concatenateAndUriEncode(Collection<?> list, String delimiter) {
        ArrayList<String> escaped = new ArrayList<String>();
        if (list != null) {
            for (Object object : list) {
                escaped.add(HttpEncodingTools.encode(object.toString()));
            }
        }
        return StringUtils.concatenate(escaped, delimiter);
    }

    public static List<String> tokenizeAndUriDecode(String string, String delimiters) {
        List<String> tokenize = StringUtils.tokenize(string, delimiters, true, true);
        ArrayList<String> decoded = new ArrayList<String>(tokenize.size());
        for (String token : tokenize) {
            decoded.add(HttpEncodingTools.decode(token));
        }
        return decoded;
    }
}

