/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.util;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.OpenSearchHadoopIllegalStateException;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.serialization.dto.NodeInfo;
import org.opensearch.hadoop.serialization.field.FieldFilter;
import org.opensearch.hadoop.util.Assert;
import org.opensearch.hadoop.util.IOUtils;
import org.opensearch.hadoop.util.ObjectUtils;
import org.opensearch.hadoop.util.StringUtils;

public class SettingsUtils {
    private static List<String> qualifyNodes(String nodes, int defaultPort, boolean resolveHostNames) {
        List<String> list = StringUtils.tokenize(nodes);
        for (int i = 0; i < list.size(); ++i) {
            String nodeIp = resolveHostNames ? SettingsUtils.resolveHostToIpIfNecessary(list.get(i)) : list.get(i);
            list.set(i, SettingsUtils.qualifyNode(nodeIp, defaultPort));
        }
        return list;
    }

    private static String qualifyNode(String node, int defaultPort) {
        int index = node.lastIndexOf(58);
        if (index > 0 && index + 1 < node.length() && Character.isDigit(node.charAt(index + 1))) {
            return node;
        }
        return node + ':' + defaultPort;
    }

    private static String resolveHostToIpIfNecessary(String host) {
        String port;
        int index;
        String schemaDelimiter = "://";
        String schema = "";
        if (host.contains(schemaDelimiter)) {
            index = host.indexOf(schemaDelimiter);
            schema = host.substring(0, index);
            host = host.substring(index + schemaDelimiter.length());
        }
        String name = (index = host.lastIndexOf(58)) > 0 ? host.substring(0, index) : host;
        String string = port = index > 0 ? host.substring(index) : "";
        if (StringUtils.hasLetter(name)) {
            try {
                String hostAddress = InetAddress.getByName(name).getHostAddress() + port;
                return StringUtils.hasText(schema) ? schema + schemaDelimiter + hostAddress : hostAddress;
            }
            catch (UnknownHostException ex) {
                throw new OpenSearchHadoopIllegalArgumentException("Cannot resolve ip for hostname: " + name);
            }
        }
        return host;
    }

    public static void pinNode(Settings settings, String address) {
        settings.setProperty("opensearch.internal.pinned.node", address);
    }

    public static boolean hasPinnedNode(Settings settings) {
        return StringUtils.hasText(settings.getProperty("opensearch.internal.pinned.node"));
    }

    public static String getPinnedNode(Settings settings) {
        String node = settings.getProperty("opensearch.internal.pinned.node");
        Assert.hasText(node, "Task has not been pinned to a node...");
        return node;
    }

    public static void setJobTransportPoolingKey(Settings settings, String key) {
        settings.setProperty("opensearch.internal.transport.pooling.key", key);
    }

    public static void ensureJobTransportPoolingKey(Settings settings) {
        if (!SettingsUtils.hasJobTransportPoolingKey(settings)) {
            throw new OpenSearchHadoopIllegalStateException("Job has not been assigned a transport pooling key. Required `opensearch.internal.transport.pooling.key` to be set but it was not assigned.");
        }
    }

    public static boolean hasJobTransportPoolingKey(Settings settings) {
        return StringUtils.hasText(settings.getProperty("opensearch.internal.transport.pooling.key"));
    }

    public static String getJobTransportPoolingKey(Settings settings) {
        String jobKey = settings.getProperty("opensearch.internal.transport.pooling.key");
        Assert.hasText(jobKey, "Job has not been assigned a transport pooling key...");
        return jobKey;
    }

    public static void addDiscoveredNodes(Settings settings, List<NodeInfo> discoveredNodes) {
        LinkedHashSet<String> nodes = new LinkedHashSet<String>();
        nodes.addAll(SettingsUtils.declaredNodes(settings));
        for (NodeInfo node : discoveredNodes) {
            if (!node.hasHttp()) continue;
            nodes.add(node.getPublishAddress());
        }
        SettingsUtils.setDiscoveredNodes(settings, nodes);
    }

    public static void setDiscoveredNodes(Settings settings, Collection<String> nodes) {
        settings.setProperty("opensearch.internal.discovered.nodes", StringUtils.concatenate(nodes));
    }

    public static List<String> declaredNodes(Settings settings) {
        return SettingsUtils.qualifyNodes(settings.getNodes(), settings.getPort(), settings.getNodesResolveHostnames());
    }

    public static List<String> discoveredOrDeclaredNodes(Settings settings) {
        String discoveredNodes = settings.getProperty("opensearch.internal.discovered.nodes");
        return StringUtils.hasText(discoveredNodes) ? StringUtils.tokenize(discoveredNodes) : SettingsUtils.declaredNodes(settings);
    }

    public static Map<String, String> aliases(String definition, boolean caseInsensitive) {
        List<String> aliases = StringUtils.tokenize(definition);
        LinkedHashMap<String, String> aliasMap = new LinkedHashMap<String, String>();
        if (aliases != null) {
            for (String string : aliases) {
                int index = (string = string.trim()).indexOf(":");
                if (index <= 0) continue;
                String key = string.substring(0, index);
                aliasMap.put(key, string.substring(index + 1));
                aliasMap.put(caseInsensitive ? key.toLowerCase(Locale.ROOT) : key, string.substring(index + 1));
            }
        }
        return aliasMap;
    }

    public static void setFilters(Settings settings, String ... filters) {
        settings.setProperty("opensearch.internal.query.filters", "");
        if (ObjectUtils.isEmpty(filters)) {
            return;
        }
        settings.setProperty("opensearch.internal.query.filters", IOUtils.serializeToBase64((Serializable)filters));
    }

    public String[] getFilters(Settings settings) {
        String[] filters = IOUtils.deserializeFromBase64(settings.getProperty("opensearch.internal.query.filters"), String[].class);
        return filters;
    }

    public static String determineSourceFields(Settings settings) {
        String internalScrollFields = settings.getScrollFields();
        String userProvided = settings.getReadSourceFilter();
        if (StringUtils.hasText(userProvided) && StringUtils.hasText(internalScrollFields)) {
            throw new OpenSearchHadoopIllegalStateException("User specified source filters were found [" + userProvided + "], but the connector is executing in a state where it has provided its own source filtering [" + internalScrollFields + "]. Please clear the user specified source fields under the [" + "opensearch.read.source.filter" + "] property to continue. Bailing out...");
        }
        String sourceFields = null;
        if (StringUtils.hasText(userProvided)) {
            sourceFields = userProvided;
        }
        if (StringUtils.hasText(internalScrollFields)) {
            sourceFields = internalScrollFields;
        }
        return sourceFields;
    }

    public static List<FieldFilter.NumberedInclude> getFieldArrayFilterInclude(Settings settings) {
        String includeString = settings.getReadFieldAsArrayInclude();
        List<String> includes = StringUtils.tokenize(includeString);
        try {
            return FieldFilter.toNumberedFilter(includes);
        }
        catch (OpenSearchHadoopIllegalArgumentException iae) {
            throw new OpenSearchHadoopIllegalArgumentException("Failed to parse [opensearch.read.field.as.array.include] option with value of [" + includeString + "]", iae);
        }
    }

    public static String getFixedRouting(Settings settings) {
        String routing = settings.getMappingRouting();
        if (StringUtils.hasText(routing) && (routing = routing.trim()).startsWith("<") && routing.endsWith(">")) {
            return routing.substring(1, routing.length() - 1);
        }
        return null;
    }
}

