/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.util;

import java.io.Serializable;
import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;

public class OpenSearchMajorVersion
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final OpenSearchMajorVersion V_1_X = new OpenSearchMajorVersion(1, "1.x");
    public static final OpenSearchMajorVersion V_2_X = new OpenSearchMajorVersion(2, "2.x");
    public static final OpenSearchMajorVersion V_3_X = new OpenSearchMajorVersion(3, "3.x");
    public static final OpenSearchMajorVersion V_7_X = new OpenSearchMajorVersion(7, "7.x");
    public static final OpenSearchMajorVersion LATEST = V_3_X;
    public final byte major;
    private final String version;

    private OpenSearchMajorVersion(byte major, String version) {
        this.major = major;
        this.version = version;
    }

    public boolean after(OpenSearchMajorVersion version) {
        return version.major < this.major;
    }

    public boolean on(OpenSearchMajorVersion version) {
        return version.major == this.major;
    }

    public boolean notOn(OpenSearchMajorVersion version) {
        return !this.on(version);
    }

    public boolean onOrAfter(OpenSearchMajorVersion version) {
        return version.major <= this.major;
    }

    public boolean before(OpenSearchMajorVersion version) {
        return version.major > this.major;
    }

    public boolean onOrBefore(OpenSearchMajorVersion version) {
        return version.major >= this.major;
    }

    public static OpenSearchMajorVersion parse(String version) {
        if (version.startsWith("0.")) {
            return new OpenSearchMajorVersion(0, version);
        }
        if (version.startsWith("1.")) {
            return new OpenSearchMajorVersion(1, version);
        }
        if (version.startsWith("2.")) {
            return new OpenSearchMajorVersion(2, version);
        }
        if (version.startsWith("3.")) {
            return new OpenSearchMajorVersion(3, version);
        }
        if (version.startsWith("7.")) {
            return new OpenSearchMajorVersion(7, version);
        }
        throw new OpenSearchHadoopIllegalArgumentException("Unsupported/Unknown OpenSearch version [" + version + "].Highest supported version is [" + OpenSearchMajorVersion.LATEST.version + "]. You may need to upgrade OpenSearch-Hadoop.");
    }

    public int parseMinorVersion(String versionString) {
        String majorPrefix = "" + this.major + ".";
        if (!versionString.startsWith(majorPrefix)) {
            throw new OpenSearchHadoopIllegalArgumentException("Invalid version string for major version; Received [" + versionString + "] for major version [" + this.version + "]");
        }
        String minorRemainder = versionString.substring(majorPrefix.length());
        int dot = minorRemainder.indexOf(46);
        if (dot < 1) {
            throw new OpenSearchHadoopIllegalArgumentException("Could not parse OpenSearch minor version [" + versionString + "]. Invalid version format.");
        }
        String rawMinorVersion = minorRemainder.substring(0, dot);
        try {
            return Integer.parseInt(rawMinorVersion);
        }
        catch (NumberFormatException e) {
            throw new OpenSearchHadoopIllegalArgumentException("Could not parse OpenSearch minor version [" + versionString + "]. Non-numeric minor version [" + rawMinorVersion + "].", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenSearchMajorVersion version = (OpenSearchMajorVersion)o;
        return this.major == version.major && this.version.equals(version.version);
    }

    public int hashCode() {
        return this.major;
    }

    public String toString() {
        return this.version;
    }
}

