/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.hadoop.util.ByteSequence;
import org.opensearch.hadoop.util.BytesArray;

public class BytesArrayPool
implements ByteSequence {
    private final List<BytesArray> pool = new ArrayList<BytesArray>();
    private int inUse = 0;

    @Override
    public int length() {
        int size = 0;
        for (int i = 0; i < this.inUse; ++i) {
            size += this.pool.get(i).length();
        }
        return size;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream toInputStream() {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        for (BytesArray ba : this.pool) {
            ba.reset();
        }
        this.inUse = 0;
    }

    public BytesArray get() {
        if (this.inUse < this.pool.size() - 1) {
            return this.pool.get(this.inUse++);
        }
        BytesArray ba = new BytesArray(64);
        this.pool.add(ba);
        ++this.inUse;
        return ba;
    }

    public List<BytesArray> inUse() {
        return this.pool;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (BytesArray ba : this.pool) {
            sb.append(ba.toString());
            sb.append(";");
        }
        return sb.toString();
    }
}

