/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.serialization.handler.write.impl;

import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.handler.ErrorHandler;
import org.opensearch.hadoop.handler.impl.AbortOnFailure;
import org.opensearch.hadoop.handler.impl.AbstractHandlerLoader;
import org.opensearch.hadoop.handler.impl.DropAndLog;
import org.opensearch.hadoop.handler.impl.opensearch.OpenSearchHandler;
import org.opensearch.hadoop.serialization.handler.write.ISerializationErrorHandler;
import org.opensearch.hadoop.serialization.handler.write.impl.DelegatingErrorHandler;
import org.opensearch.hadoop.serialization.handler.write.impl.SerializationEventConverter;
import org.opensearch.hadoop.serialization.handler.write.impl.SerializationLogRenderer;

public class SerializationHandlerLoader
extends AbstractHandlerLoader<ISerializationErrorHandler> {
    public static final String OPENSEARCH_WRITE_DATA_ERROR_HANDLERS = "opensearch.write.data.error.handlers";
    public static final String OPENSEARCH_WRITE_DATA_ERROR_HANDLER = "opensearch.write.data.error.handler";

    public SerializationHandlerLoader() {
        super(ISerializationErrorHandler.class);
    }

    @Override
    protected String getHandlersPropertyName() {
        return OPENSEARCH_WRITE_DATA_ERROR_HANDLERS;
    }

    @Override
    protected String getHandlerPropertyName() {
        return OPENSEARCH_WRITE_DATA_ERROR_HANDLER;
    }

    @Override
    protected ISerializationErrorHandler loadBuiltInHandler(AbstractHandlerLoader.NamedHandlers handlerName) {
        ErrorHandler genericHandler;
        switch (handlerName) {
            case FAIL: {
                genericHandler = AbortOnFailure.create();
                break;
            }
            case LOG: {
                genericHandler = DropAndLog.create(new SerializationLogRenderer());
                break;
            }
            case OPENSEARCH: {
                genericHandler = OpenSearchHandler.create(this.getSettings(), new SerializationEventConverter());
                break;
            }
            default: {
                throw new OpenSearchHadoopIllegalArgumentException("Could not find default implementation for built in handler type [" + (Object)((Object)handlerName) + "]");
            }
        }
        return new DelegatingErrorHandler(genericHandler);
    }
}

