/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.serialization.field;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.opensearch.hadoop.serialization.field.IndexFormatter;
import org.opensearch.hadoop.util.Constants;
import org.opensearch.hadoop.util.DateUtils;
import org.opensearch.hadoop.util.StringUtils;

public class DateIndexFormatter
implements IndexFormatter {
    private String format;
    private SimpleDateFormat dateFormat;

    @Override
    public void configure(String format) {
        this.format = format;
        format = this.fixDateForJdk(format);
        this.dateFormat = new SimpleDateFormat(format);
    }

    private String fixDateForJdk(String format) {
        if (Constants.JRE_IS_MINIMUM_JAVA7) {
            return format;
        }
        if (format.contains("Y")) {
            format = format.replace("Y", "y");
        }
        format = format.replaceAll("((?<!y)(?:y|yyy)(?!y))", "yyyy");
        return format;
    }

    @Override
    public String format(String value) {
        if (!StringUtils.hasText(value)) {
            return null;
        }
        Calendar calendar = DateUtils.parseDate(value);
        this.dateFormat.setCalendar(calendar);
        return this.dateFormat.format(calendar.getTime());
    }
}

