/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.serialization.field;

import java.util.List;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.serialization.SettingsAware;
import org.opensearch.hadoop.serialization.field.ExtractorUtils;
import org.opensearch.hadoop.serialization.field.FieldExtractor;
import org.opensearch.hadoop.util.StringUtils;

public class ConstantFieldExtractor
implements FieldExtractor,
SettingsAware {
    public static final String PROPERTY = "org.opensearch.hadoop.serialization.ConstantFieldExtractor.property";
    private List<String> fieldNames;
    private Object value;
    private boolean autoQuote = true;

    @Override
    public final Object field(Object target) {
        return this.value != null ? this.value : (this.fieldNames == null || this.fieldNames.isEmpty() ? NOT_FOUND : this.extractField(target));
    }

    protected Object extractField(Object target) {
        return NOT_FOUND;
    }

    @Override
    public void setSettings(Settings settings) {
        this.autoQuote = settings.getMappingConstantAutoQuote();
        String fldName = this.property(settings);
        if (fldName.startsWith("<") && fldName.endsWith(">")) {
            this.value = this.initValue(fldName.substring(1, fldName.length() - 1));
        }
        if (this.value == null) {
            this.fieldNames = StringUtils.tokenize(fldName, ".");
            this.processField(settings, this.fieldNames);
        }
    }

    protected void processField(Settings settings, List<String> fieldNames) {
    }

    protected Object initValue(String value) {
        return ExtractorUtils.extractConstant(value, this.autoQuote);
    }

    protected String property(Settings settings) {
        String value = settings.getProperty(PROPERTY);
        return value == null ? "" : value.trim();
    }

    protected List<String> getFieldNames() {
        return this.fieldNames;
    }

    public String toString() {
        return String.format("%s for field [%s]", this.getClass().getSimpleName(), this.fieldNames);
    }
}

