/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.serialization.dto;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class IndicesAliases {
    private final Map<String, Map<String, Alias>> indices;

    private IndicesAliases(Map<String, Map<String, Alias>> indices) {
        this.indices = indices;
    }

    public Map<String, Alias> getAliases(String index) {
        return this.indices.get(index);
    }

    public Map<String, Map<String, Alias>> getAll() {
        return this.indices;
    }

    public static IndicesAliases parse(Map<String, Object> resp) {
        HashMap indices = new HashMap();
        for (Map.Entry<String, Object> index : resp.entrySet()) {
            Map metadata = (Map)index.getValue();
            Map aliases = (Map)metadata.get("aliases");
            HashMap<String, Alias> indexAliases = new HashMap<String, Alias>();
            indices.put(index.getKey(), indexAliases);
            for (Map.Entry entry : aliases.entrySet()) {
                String name = (String)entry.getKey();
                Map aliasMetadata = (Map)entry.getValue();
                String searchRouting = null;
                String indexRouting = null;
                Map filter = null;
                boolean isWriteIndex = false;
                if (aliasMetadata.containsKey("search_routing")) {
                    searchRouting = (String)aliasMetadata.get("search_routing");
                }
                if (aliasMetadata.containsKey("index_routing")) {
                    indexRouting = (String)aliasMetadata.get("index_routing");
                }
                if (aliasMetadata.containsKey("filter")) {
                    filter = (Map)aliasMetadata.get("filter");
                }
                if (aliasMetadata.containsKey("is_write_index")) {
                    isWriteIndex = (Boolean)aliasMetadata.get("is_write_index");
                }
                Alias alias = new Alias(name, searchRouting, indexRouting, filter, isWriteIndex);
                indexAliases.put(alias.name, alias);
            }
        }
        return new IndicesAliases(Collections.unmodifiableMap(indices));
    }

    public static class Alias {
        private final String name;
        private final String searchRouting;
        private final String indexRouting;
        private final Map<String, Object> filter;
        private final boolean isWriteIndex;

        Alias(String name, String searchRouting, String indexRouting, Map<String, Object> filter, boolean isWriteIndex) {
            this.name = name;
            this.searchRouting = searchRouting;
            this.indexRouting = indexRouting;
            this.filter = filter;
            this.isWriteIndex = isWriteIndex;
        }

        public String getName() {
            return this.name;
        }

        public String getSearchRouting() {
            return this.searchRouting;
        }

        public String getIndexRouting() {
            return this.indexRouting;
        }

        public Map<String, Object> getFilter() {
            return this.filter;
        }

        public boolean isWriteIndex() {
            return this.isWriteIndex;
        }

        public String toString() {
            return "Alias{name='" + this.name + '\'' + ", searchRouting='" + this.searchRouting + '\'' + ", indexRouting='" + this.indexRouting + '\'' + ", filter=" + this.filter + ", isWriteAlias=" + this.isWriteIndex + '}';
        }
    }
}

