/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.serialization.bulk;

import java.util.List;
import org.opensearch.hadoop.OpenSearchHadoopIllegalStateException;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.serialization.bulk.AbstractBulkFactory;
import org.opensearch.hadoop.serialization.bulk.MetadataExtractor;
import org.opensearch.hadoop.serialization.field.FieldExtractor;
import org.opensearch.hadoop.util.Assert;
import org.opensearch.hadoop.util.OpenSearchMajorVersion;
import org.opensearch.hadoop.util.StringUtils;

class UpdateBulkFactory
extends AbstractBulkFactory {
    private final int RETRY_ON_FAILURE;
    private final String RETRY_HEADER;
    private final String SCRIPT;
    private final String SCRIPT_LANG;
    private final boolean HAS_SCRIPT;
    private final boolean HAS_LANG;
    private final boolean HAS_SCRIPT_UPSERT;
    private final boolean UPSERT;

    public UpdateBulkFactory(Settings settings, MetadataExtractor metaExtractor, OpenSearchMajorVersion opensearchMajorVersion) {
        this(settings, false, metaExtractor, opensearchMajorVersion);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UpdateBulkFactory(Settings settings, boolean upsert, MetadataExtractor metaExtractor, OpenSearchMajorVersion opensearchMajorVersion) {
        super(settings, metaExtractor, opensearchMajorVersion);
        this.UPSERT = upsert;
        this.RETRY_ON_FAILURE = settings.getUpdateRetryOnConflict();
        this.RETRY_HEADER = this.getRequestParameterNames().retryOnConflict + this.RETRY_ON_FAILURE + "";
        this.HAS_SCRIPT = settings.hasUpdateScript();
        this.HAS_SCRIPT_UPSERT = settings.hasScriptUpsert();
        this.HAS_LANG = StringUtils.hasText(settings.getUpdateScriptLang());
        this.SCRIPT_LANG = ",\"lang\":\"" + settings.getUpdateScriptLang() + "\"";
        if (this.HAS_SCRIPT) {
            if (StringUtils.hasText(settings.getUpdateScriptInline())) {
                String source = "source";
                this.SCRIPT = "{\"script\":{\"" + source + "\":\"" + settings.getUpdateScriptInline() + "\"";
                return;
            } else if (StringUtils.hasText(settings.getUpdateScriptFile())) {
                this.SCRIPT = "{\"script\":{\"file\":\"" + settings.getUpdateScriptFile() + "\"";
                return;
            } else {
                if (!StringUtils.hasText(settings.getUpdateScriptStored())) throw new OpenSearchHadoopIllegalStateException("No update script found...");
                this.SCRIPT = "{\"script\":{\"stored\":\"" + settings.getUpdateScriptStored() + "\"";
            }
            return;
        } else {
            this.SCRIPT = null;
        }
    }

    @Override
    protected String getOperation() {
        return "update";
    }

    @Override
    protected void otherHeader(List<Object> list, boolean commaMightBeNeeded) {
        if (this.RETRY_ON_FAILURE > 0) {
            if (commaMightBeNeeded) {
                list.add(",");
            }
            list.add(this.RETRY_HEADER);
        }
    }

    @Override
    protected void writeObjectHeader(List<Object> list) {
        super.writeObjectHeader(list);
        FieldExtractor paramExtractor = this.getMetadataExtractorOrFallback(MetadataExtractor.Metadata.PARAMS, this.getParamExtractor());
        this.writeStrictFormatting(list, paramExtractor, this.SCRIPT);
    }

    private void writeStrictFormatting(List<Object> list, Object paramExtractor, String scriptToUse) {
        if (this.HAS_SCRIPT) {
            list.add(scriptToUse);
            if (this.HAS_LANG) {
                list.add(this.SCRIPT_LANG);
            }
            if (paramExtractor != null) {
                list.add(",\"params\":");
                list.add(paramExtractor);
            }
            list.add("}");
            if (this.HAS_SCRIPT_UPSERT) {
                list.add(",\"scripted_upsert\": true");
            }
            if (this.UPSERT) {
                list.add(",\"upsert\":");
            }
        } else {
            list.add("{");
            if (this.UPSERT) {
                list.add("\"doc_as_upsert\":true,");
            }
            list.add("\"doc\":");
        }
    }

    @Override
    protected void writeObjectEnd(List<Object> after) {
        after.add("}");
        super.writeObjectEnd(after);
    }

    @Override
    protected boolean id(List<Object> list, boolean commaMightBeNeeded) {
        boolean added = super.id(list, commaMightBeNeeded);
        Assert.isTrue(added, String.format("Operation [%s] requires an id but none was given/found", this.getOperation()));
        return added;
    }
}

