/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.serialization.bulk;

import java.util.Collection;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.serialization.builder.ValueWriter;
import org.opensearch.hadoop.serialization.bulk.TemplatedBulk;
import org.opensearch.hadoop.serialization.json.JacksonJsonGenerator;
import org.opensearch.hadoop.util.BytesArray;
import org.opensearch.hadoop.util.FastByteArrayOutputStream;

class ScriptTemplateBulk
extends TemplatedBulk {
    private final Settings settings;

    ScriptTemplateBulk(Settings settings, Collection<Object> beforeObject, Collection<Object> afterObject, ValueWriter<?> valueWriter) {
        super(beforeObject, afterObject, valueWriter);
        this.settings = settings;
    }

    @Override
    protected void doWriteObject(Object object, BytesArray storage, ValueWriter<?> writer) {
        if ("upsert".equals(this.settings.getOperation())) {
            if (this.settings.hasScriptUpsert()) {
                FastByteArrayOutputStream bos = new FastByteArrayOutputStream(storage);
                JacksonJsonGenerator generator = new JacksonJsonGenerator(bos);
                generator.writeBeginObject();
                generator.writeEndObject();
                generator.close();
            } else {
                super.doWriteObject(object, storage, writer);
            }
        }
    }
}

