/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.serialization.bulk;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.serialization.BytesConverter;
import org.opensearch.hadoop.serialization.builder.NoOpValueWriter;
import org.opensearch.hadoop.serialization.builder.ValueWriter;
import org.opensearch.hadoop.serialization.bulk.TemplatedBulk;
import org.opensearch.hadoop.serialization.field.JsonFieldExtractors;
import org.opensearch.hadoop.util.Assert;
import org.opensearch.hadoop.util.BytesArray;
import org.opensearch.hadoop.util.ObjectUtils;

class JsonTemplatedBulk
extends TemplatedBulk {
    private static Log log = LogFactory.getLog(JsonTemplatedBulk.class);
    protected final JsonFieldExtractors jsonExtractors;
    protected final BytesConverter jsonWriter;
    protected final Settings settings;

    public JsonTemplatedBulk(Collection<Object> beforeObject, Collection<Object> afterObject, JsonFieldExtractors jsonExtractors, Settings settings) {
        super(beforeObject, afterObject, new NoOpValueWriter());
        this.jsonExtractors = jsonExtractors;
        this.jsonWriter = (BytesConverter)ObjectUtils.instantiate(settings.getSerializerBytesConverterClassName(), settings);
        this.settings = settings;
    }

    @Override
    protected Object preProcess(Object object, BytesArray storage) {
        Assert.notNull(object, "Empty/null JSON document given...");
        this.jsonWriter.convert(object, storage);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("About to extract information from [%s]", storage));
        }
        this.jsonExtractors.process(storage);
        return storage;
    }

    @Override
    protected void doWriteObject(Object object, BytesArray storage, ValueWriter<?> writer) {
    }
}

