/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.serialization.builder;

import java.io.OutputStream;
import org.opensearch.hadoop.serialization.Generator;
import org.opensearch.hadoop.serialization.OpenSearchHadoopSerializationException;
import org.opensearch.hadoop.serialization.builder.ValueWriter;
import org.opensearch.hadoop.serialization.json.JacksonJsonGenerator;
import org.opensearch.hadoop.util.Assert;
import org.opensearch.hadoop.util.FastByteArrayOutputStream;

public class ContentBuilder {
    private final Generator generator;
    private final ValueWriter writer;

    private ContentBuilder(Generator generator, ValueWriter writer) {
        Assert.notNull(generator);
        this.generator = generator;
        this.writer = writer;
    }

    public static ContentBuilder generate(ValueWriter writer) {
        return new ContentBuilder(new JacksonJsonGenerator(new FastByteArrayOutputStream()), writer);
    }

    public static ContentBuilder generate(OutputStream bos, ValueWriter writer) {
        return new ContentBuilder(new JacksonJsonGenerator(bos), writer);
    }

    public ContentBuilder value(Object value) {
        ValueWriter.Result result = this.writer.write(value, this.generator);
        if (!result.isSuccesful()) {
            String message = null;
            message = value == result.unknownValue ? String.format("Cannot handle type [%s], instance [%s] using writer [%s]", value.getClass(), value, this.writer) : String.format("Cannot handle type [%s] within type [%s], instance [%s] within instance [%s] using writer [%s]", result.unknownValue.getClass(), value.getClass(), result.unknownValue, value, this.writer);
            throw new OpenSearchHadoopSerializationException(message);
        }
        return this;
    }

    public ContentBuilder flush() {
        this.generator.flush();
        return this;
    }

    public OutputStream content() {
        return (OutputStream)this.generator.getOutputTarget();
    }

    public void close() {
        this.generator.close();
    }
}

